import { ComponentPropsWithRef, forwardRef, ForwardedRef } from 'react';
import { Separator } from '@radix-ui/react-dropdown-menu';

import { styled, theme } from '../../stitches.config';

const StyledDropdownSeperator = styled(Separator, {
    height: '1px',
    margin: theme.space['2'],
    backgroundColor: theme.colors['grey-4'],
});

export type DropdownSeperatorProps = ComponentPropsWithRef<'div'>;

/**
 * DropdownSeperator component
 */
const _DropdownSeperator = (
    props: DropdownSeperatorProps,
    ref: ForwardedRef<HTMLDivElement>,
): JSX.Element => {
    const { ...otherProps } = props;

    return <StyledDropdownSeperator ref={ref} {...otherProps} />;
};

export const DropdownSeperator = forwardRef(_DropdownSeperator) as (
    props: DropdownSeperatorProps & {
        ref?: ForwardedRef<HTMLDivElement>;
    },
) => ReturnType<typeof _DropdownSeperator>;
