import { ComponentPropsWithRef, forwardRef, ForwardedRef } from 'react';
import { Label } from '@radix-ui/react-dropdown-menu';

import { styled, theme } from '../../stitches.config';

const StyledDropdownLabel = styled(Label, {
    lineHeight: theme.space['8'],
    padding: `0 ${theme.space['4']}`,
    color: theme.colors['grey-1'],
    backgroundColor: theme.colors['base'],
    fontSize: theme.fontSizes.sm,
    fontWeight: theme.fontWeights.semibold,
    variants: {
        nowrap: {
            true: {
                whiteSpace: 'nowrap',
                overflow: 'hidden',
                textOverflow: 'ellipsis',
            },
        },
    },
});

export interface DropdownLabelProps extends ComponentPropsWithRef<'div'> {
    /** Allow the label to wrap to the next line */
    nowrap?: boolean;
}

/**
 * DropdownLabel component
 */
const _DropdownLabel = (
    props: DropdownLabelProps,
    ref: ForwardedRef<HTMLDivElement>,
): JSX.Element => {
    const { children, nowrap = true, ...otherProps } = props;

    return (
        <StyledDropdownLabel ref={ref} nowrap={nowrap} {...otherProps}>
            {children}
        </StyledDropdownLabel>
    );
};

export const DropdownLabel = forwardRef(_DropdownLabel) as (
    props: DropdownLabelProps & {
        ref?: ForwardedRef<HTMLDivElement>;
    },
) => ReturnType<typeof _DropdownLabel>;
