import { ComponentProps, useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import { CurrencyPicker } from './CurrencyPicker';

export default {
    title: 'Components/CurrencyPicker',
    component: CurrencyPicker,
    argTypes: {},
};

/* Stories */
const Template: Story<ComponentProps<typeof CurrencyPicker>> = (args) => {
    const { value, onChange, ...otherArgs } = args;

    const [activeValue, setActiveValue] = useState(value);

    useEffect(() => {
        setActiveValue(value);
    }, [value]);

    /**
     * QUESTIONS:
     *
     *  1. Do we want to accept leading strings of digits with a leading $ i.e. '$234' ?
     *
     *  2. Do we want to accept string of digits with commas i.e. '432,123,232' ?
     */

    /**
     * Testing input passed into component:
     *
     * string of letters: NaN
     *
     * string of digits with a leading $: NaN
     *
     * string of digits with a comma , : NaN
     *
     * string of digits with parens (342) : NaN
     *
     *
     * string of digits with a decimal : converts
     *
     * string of digits with a hyphen : converts
     *
     * string of digits with an e (not as the first digit) : treats the e as an exponent and evaluates
     *
     *
     *
     */

    return (
        <>
            <CurrencyPicker value={'hello'}></CurrencyPicker>
            <CurrencyPicker
                value={activeValue}
                onChange={(value) => {
                    setActiveValue(value);
                    onChange(value);
                }}
                {...otherArgs}
            />
        </>
    );
};

export const Default = Template.bind({});

Default.args = {
    value: null,
    placeholder: undefined,
    disabled: false,
    valid: true,
};

export const Placeholder = Template.bind({});

Placeholder.args = {
    ...Default.args,
    placeholder: 'Enter cost',
};

// Disabled
export const Disabled = Template.bind({});

Disabled.args = {
    ...Placeholder.args,
    disabled: true,
};

// Error
export const Error = Template.bind({});

Error.args = {
    ...Placeholder.args,
    valid: false,
};
