import { ComponentProps, useState, useEffect } from 'react';
import { Story } from '@storybook/react';
import { Checklist } from './';

export default {
    title: 'Components/Checklist',
    component: Checklist,
    argTypes: {},
};

/* Stories */
const SingleTemplate: Story<ComponentProps<typeof Checklist>> = (args) => {
    const { value, onChange, ...otherArgs } = args;
    const [selectedValue, setSelectedValue] = useState(value);

    useEffect(() => {
        setSelectedValue(value);
    }, [value]);

    return (
        <Checklist
            multiple={false}
            value={selectedValue}
            onChange={(newValue) => {
                setSelectedValue(newValue);
                onChange(newValue);
            }}
            {...otherArgs}
        />
    );
};

const MultiTemplate: Story<ComponentProps<typeof Checklist>> = (args) => {
    const { value, onChange, ...otherArgs } = args;
    const [selectedValue, setSelectedValue] = useState(value);

    useEffect(() => {
        setSelectedValue(value);
    }, [value]);

    return (
        <Checklist
            multiple={true}
            value={selectedValue}
            onChange={(newValue) => {
                setSelectedValue(newValue);
                onChange(newValue);
            }}
            {...otherArgs}
        />
    );
};

const options = [
    'Option A',
    'Option B',
    'Option C',
    'Option AA',
    'Option BB',
    'Option CC',
];

// Default
export const Default = SingleTemplate.bind({});

Default.args = {
    value: 'Option B',
    options: options,
    multiple: false,
    disabled: false,
    placeholder: 'Select option',
};

export const Disabled = SingleTemplate.bind({});

Disabled.args = {
    ...Default.args,
    disabled: true,
};

export const Error = SingleTemplate.bind({});

Error.args = {
    ...Default.args,
    valid: false,
};

// Default
export const Multiple = MultiTemplate.bind({});

Multiple.args = {
    value: ['Option B', 'Option AA'],
    options: options,
    multiple: true,
    disabled: false,
    placeholder: 'Select option',
};
