import { ComponentProps, useState, useEffect } from 'react';
import { Story, Meta } from '@storybook/react';
import dayjs from 'dayjs';

import { Calendar } from './Calendar';

export default {
    title: 'Components/Calendar',
    component: Calendar,
    argTypes: {},
} as Meta;

/* Stories */

const Template: Story<ComponentProps<typeof Calendar>> = (args) => {
    const { value, onChange, ...otherArgs } = args;
    const [selectedValue, setSelectedValue] = useState(value);

    useEffect(() => {
        setSelectedValue(value);
    }, [value]);

    return (
        <Calendar
            value={selectedValue}
            onChange={(newValue) => {
                setSelectedValue(newValue);
                onChange(newValue);
            }}
            {...otherArgs}
        />
    );
};

// Default
export const Default = Template.bind({});

Default.args = {
    value: dayjs(new Date()).format('MM/DD/YYYY'),
};

// Disabled
export const Disabled = Template.bind({});

Disabled.args = {
    ...Default.args,
    disabled: true,
};

// Error
export const Error = Template.bind({});

Error.args = {
    ...Default.args,
    valid: false,
};
