import { ComponentProps } from 'react';
import { Story } from '@storybook/react';
import { Breadcrumb } from './';

export default {
    title: 'Components/Breadcrumb',
    component: Breadcrumb,
    subcomponents: {
        Item: Breadcrumb.Item,
    },
    argTypes: {},
};

const breadcrumbs = [
    { href: 'https://example.com/', label: 'Home' },
    { href: 'https://example.com/', label: 'User Management' },
    { href: 'https://example.com/', label: 'Approve Access' },
];

/* Stories */
const Template: Story<ComponentProps<typeof Breadcrumb>> = () => {
    return (
        <Breadcrumb>
            {
                //for each breadcrumb return a dom element, crumb index
                breadcrumbs.map((crumb, ci) => {
                    return (
                        <Breadcrumb.Item key={ci} href={crumb.href}>
                            {crumb.label}
                        </Breadcrumb.Item>
                    );
                })
            }
        </Breadcrumb>
    );
};

// Default
export const Default = Template.bind({});

Default.args = {
    name: 'demo',
};
