import { ComponentPropsWithRef, forwardRef, ForwardedRef } from 'react';
import { Item } from '@radix-ui/react-accordion';

export interface AccordionItemProps extends ComponentPropsWithRef<'div'> {
    /** Value of the accorion item */
    value: string;

    /** Mark the accordion item in a disabled/enabled state */
    disabled?: boolean;
}

/**
 * AccordionItem component
 */
const _AccordionItem = (
    props: AccordionItemProps,
    ref: ForwardedRef<HTMLDivElement>,
): JSX.Element => {
    const { children, value, disabled = false, ...otherProps } = props;

    return (
        <Item ref={ref} value={value} disabled={disabled} {...otherProps}>
            {children}
        </Item>
    );
};

export const AccordionItem = forwardRef(_AccordionItem) as (
    props: AccordionItemProps & {
        ref?: ForwardedRef<HTMLDivElement>;
    },
) => ReturnType<typeof _AccordionItem>;
