import { ComponentPropsWithRef, forwardRef, ForwardedRef } from 'react';
import * as RadixAccordion from '@radix-ui/react-accordion';
import { styled } from '../../stitches.config';

const StyledContent = styled(RadixAccordion.Content, {
    padding: '$2',
    height: '$space$full',
    overflowY: 'auto',
});

export type AccordionContentProps = ComponentPropsWithRef<'div'>;

/**
 * AccordionContent component
 */
const _AccordionContent = (
    props: AccordionContentProps,
    ref: ForwardedRef<HTMLHeadingElement>,
): JSX.Element => {
    const { children, ...otherProps } = props;
    return (
        <StyledContent ref={ref} {...otherProps}>
            {children}
        </StyledContent>
    );
};

export const AccordionContent = forwardRef(_AccordionContent) as (
    props: AccordionContentProps & {
        ref?: ForwardedRef<HTMLDivElement>;
    },
) => ReturnType<typeof _AccordionContent>;
