/// <reference types="react" />
import * as _stitches_react_types_theme from '@stitches/react/types/theme';
import * as _stitches_react_types_css from '@stitches/react/types/css';
import * as _stitches_react_types_styled_component from '@stitches/react/types/styled-component';
import * as _stitches_react_types_stitches from '@stitches/react/types/stitches';
import * as _stitches_react_types_css_util from '@stitches/react/types/css-util';
import * as _stitches_react_types_config from '@stitches/react/types/config';
import * as react from 'react';
import react__default, { RefObject, ComponentPropsWithRef, ComponentPropsWithoutRef, ForwardedRef, ReactNode, ComponentProps, Key } from 'react';
import * as _stitches_react_types_util from '@stitches/react/types/util';
import * as Stitches from '@stitches/react';
import { Icon as Icon$1 } from '@mdi/react';
import { CountryCode, NumberFormat } from 'libphonenumber-js';

declare const styled: <Type extends _stitches_react_types_util.Function | keyof JSX.IntrinsicElements | react.ComponentType<any>, Composers extends (string | _stitches_react_types_util.Function | react.ComponentType<any> | {
    [name: string]: unknown;
})[], CSS = _stitches_react_types_css_util.CSS<{
    sm: "(min-width: 640px)";
    md: "(min-width: 768px)";
    lg: "(min-width: 1024px)";
    xl: "(min-width: 1280px)";
    xxl: "(min-width: 1536px)";
}, {
    borderWidths: {
        none: string;
        default: string;
        thick: string;
        thicker: string;
    };
    radii: {
        none: string;
        default: string;
        full: string;
    };
    colors: {
        base: string;
        'transparent-dark-1': string;
        'transparent-dark-2': string;
        'transparent-dark-3': string;
        'transparent-dark-4': string;
        'transparent-dark-5': string;
        'transparent-light-1': string;
        'transparent-light-2': string;
        'transparent-light-3': string;
        'transparent-light-4': string;
        'transparent-light-5': string;
        'grey-1': string;
        'grey-2': string;
        'grey-3': string;
        'grey-4': string;
        'grey-5': string;
        'primary-1': string;
        'primary-2': string;
        'primary-3': string;
        'primary-4': string;
        'primary-5': string;
        'success-1': string;
        'success-2': string;
        'success-3': string;
        'success-4': string;
        'success-5': string;
        'warning-1': string;
        'warning-2': string;
        'warning-3': string;
        'warning-4': string;
        'warning-5': string;
        'error-1': string;
        'error-2': string;
        'error-3': string;
        'error-4': string;
        'error-5': string;
    };
    fontSizes: {
        default: string;
        xs: string;
        sm: string;
        md: string;
        lg: string;
        xl: string;
        xxl: string;
    };
    fontWeights: {
        hairline: string;
        thin: string;
        light: string;
        default: string;
        medium: string;
        semibold: string;
        bold: string;
        extrabold: string;
        black: string;
    };
    lineHeights: {
        none: string;
        default: string;
    };
    shadows: {
        none: string;
        default: string;
    };
    sizes: unknown;
    space: {
        auto: string;
        full: string;
        none: string;
        0: string;
        '-1': string;
        '-2': string;
        '-3': string;
        '-4': string;
        '-5': string;
        '-6': string;
        '-8': string;
        '-10': string;
        '-12': string;
        '-16': string;
        '-20': string;
        '-24': string;
        '-32': string;
        '-40': string;
        '-48': string;
        '-56': string;
        '-64': string;
        '-68': string;
        '-72': string;
        '-80': string;
        '-96': string;
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '8': string;
        '10': string;
        '12': string;
        '16': string;
        '20': string;
        '24': string;
        '32': string;
        '40': string;
        '48': string;
        '56': string;
        '64': string;
        '68': string;
        '72': string;
        '80': string;
        '96': string;
    };
}, _stitches_react_types_config.DefaultThemeMap, {}>>(type: Type, ...composers: { [K in keyof Composers]: string extends Composers[K] ? Composers[K] : Composers[K] extends string | _stitches_react_types_util.Function | react.ComponentType<any> ? Composers[K] : _stitches_react_types_stitches.RemoveIndex<CSS> & {
    variants?: {
        [x: string]: {
            [x: string]: CSS;
            [x: number]: CSS;
        };
    } | undefined;
    compoundVariants?: (("variants" extends keyof Composers[K] ? { [Name in keyof Composers[K][keyof Composers[K] & "variants"]]?: _stitches_react_types_util.String | _stitches_react_types_util.Widen<keyof Composers[K][keyof Composers[K] & "variants"][Name]> | undefined; } : _stitches_react_types_util.WideObject) & {
        css: CSS;
    })[] | undefined;
    defaultVariants?: ("variants" extends keyof Composers[K] ? { [Name_1 in keyof Composers[K][keyof Composers[K] & "variants"]]?: _stitches_react_types_util.String | _stitches_react_types_util.Widen<keyof Composers[K][keyof Composers[K] & "variants"][Name_1]> | undefined; } : _stitches_react_types_util.WideObject) | undefined;
} & CSS & { [K2 in keyof Composers[K]]: K2 extends "compoundVariants" | "defaultVariants" | "variants" ? unknown : K2 extends keyof CSS ? CSS[K2] : unknown; }; }) => _stitches_react_types_styled_component.StyledComponent<Type, _stitches_react_types_styled_component.StyledComponentProps<Composers>, {
    sm: "(min-width: 640px)";
    md: "(min-width: 768px)";
    lg: "(min-width: 1024px)";
    xl: "(min-width: 1280px)";
    xxl: "(min-width: 1536px)";
}, _stitches_react_types_css_util.CSS<{
    sm: "(min-width: 640px)";
    md: "(min-width: 768px)";
    lg: "(min-width: 1024px)";
    xl: "(min-width: 1280px)";
    xxl: "(min-width: 1536px)";
}, {
    borderWidths: {
        none: string;
        default: string;
        thick: string;
        thicker: string;
    };
    radii: {
        none: string;
        default: string;
        full: string;
    };
    colors: {
        base: string;
        'transparent-dark-1': string;
        'transparent-dark-2': string;
        'transparent-dark-3': string;
        'transparent-dark-4': string;
        'transparent-dark-5': string;
        'transparent-light-1': string;
        'transparent-light-2': string;
        'transparent-light-3': string;
        'transparent-light-4': string;
        'transparent-light-5': string;
        'grey-1': string;
        'grey-2': string;
        'grey-3': string;
        'grey-4': string;
        'grey-5': string;
        'primary-1': string;
        'primary-2': string;
        'primary-3': string;
        'primary-4': string;
        'primary-5': string;
        'success-1': string;
        'success-2': string;
        'success-3': string;
        'success-4': string;
        'success-5': string;
        'warning-1': string;
        'warning-2': string;
        'warning-3': string;
        'warning-4': string;
        'warning-5': string;
        'error-1': string;
        'error-2': string;
        'error-3': string;
        'error-4': string;
        'error-5': string;
    };
    fontSizes: {
        default: string;
        xs: string;
        sm: string;
        md: string;
        lg: string;
        xl: string;
        xxl: string;
    };
    fontWeights: {
        hairline: string;
        thin: string;
        light: string;
        default: string;
        medium: string;
        semibold: string;
        bold: string;
        extrabold: string;
        black: string;
    };
    lineHeights: {
        none: string;
        default: string;
    };
    shadows: {
        none: string;
        default: string;
    };
    sizes: unknown;
    space: {
        auto: string;
        full: string;
        none: string;
        0: string;
        '-1': string;
        '-2': string;
        '-3': string;
        '-4': string;
        '-5': string;
        '-6': string;
        '-8': string;
        '-10': string;
        '-12': string;
        '-16': string;
        '-20': string;
        '-24': string;
        '-32': string;
        '-40': string;
        '-48': string;
        '-56': string;
        '-64': string;
        '-68': string;
        '-72': string;
        '-80': string;
        '-96': string;
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '8': string;
        '10': string;
        '12': string;
        '16': string;
        '20': string;
        '24': string;
        '32': string;
        '40': string;
        '48': string;
        '56': string;
        '64': string;
        '68': string;
        '72': string;
        '80': string;
        '96': string;
    };
}, _stitches_react_types_config.DefaultThemeMap, {}>>;
declare const css: <Composers extends (string | _stitches_react_types_util.Function | react.JSXElementConstructor<any> | react.ExoticComponent<any> | {
    [name: string]: unknown;
})[], CSS = _stitches_react_types_css_util.CSS<{
    sm: "(min-width: 640px)";
    md: "(min-width: 768px)";
    lg: "(min-width: 1024px)";
    xl: "(min-width: 1280px)";
    xxl: "(min-width: 1536px)";
}, {
    borderWidths: {
        none: string;
        default: string;
        thick: string;
        thicker: string;
    };
    radii: {
        none: string;
        default: string;
        full: string;
    };
    colors: {
        base: string;
        'transparent-dark-1': string;
        'transparent-dark-2': string;
        'transparent-dark-3': string;
        'transparent-dark-4': string;
        'transparent-dark-5': string;
        'transparent-light-1': string;
        'transparent-light-2': string;
        'transparent-light-3': string;
        'transparent-light-4': string;
        'transparent-light-5': string;
        'grey-1': string;
        'grey-2': string;
        'grey-3': string;
        'grey-4': string;
        'grey-5': string;
        'primary-1': string;
        'primary-2': string;
        'primary-3': string;
        'primary-4': string;
        'primary-5': string;
        'success-1': string;
        'success-2': string;
        'success-3': string;
        'success-4': string;
        'success-5': string;
        'warning-1': string;
        'warning-2': string;
        'warning-3': string;
        'warning-4': string;
        'warning-5': string;
        'error-1': string;
        'error-2': string;
        'error-3': string;
        'error-4': string;
        'error-5': string;
    };
    fontSizes: {
        default: string;
        xs: string;
        sm: string;
        md: string;
        lg: string;
        xl: string;
        xxl: string;
    };
    fontWeights: {
        hairline: string;
        thin: string;
        light: string;
        default: string;
        medium: string;
        semibold: string;
        bold: string;
        extrabold: string;
        black: string;
    };
    lineHeights: {
        none: string;
        default: string;
    };
    shadows: {
        none: string;
        default: string;
    };
    sizes: unknown;
    space: {
        auto: string;
        full: string;
        none: string;
        0: string;
        '-1': string;
        '-2': string;
        '-3': string;
        '-4': string;
        '-5': string;
        '-6': string;
        '-8': string;
        '-10': string;
        '-12': string;
        '-16': string;
        '-20': string;
        '-24': string;
        '-32': string;
        '-40': string;
        '-48': string;
        '-56': string;
        '-64': string;
        '-68': string;
        '-72': string;
        '-80': string;
        '-96': string;
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '8': string;
        '10': string;
        '12': string;
        '16': string;
        '20': string;
        '24': string;
        '32': string;
        '40': string;
        '48': string;
        '56': string;
        '64': string;
        '68': string;
        '72': string;
        '80': string;
        '96': string;
    };
}, _stitches_react_types_config.DefaultThemeMap, {}>>(...composers: { [K in keyof Composers]: string extends Composers[K] ? Composers[K] : Composers[K] extends string | _stitches_react_types_util.Function | react.JSXElementConstructor<any> | react.ExoticComponent<any> ? Composers[K] : _stitches_react_types_stitches.RemoveIndex<CSS> & {
    variants?: {
        [x: string]: {
            [x: string]: CSS;
            [x: number]: CSS;
        };
    } | undefined;
    compoundVariants?: (("variants" extends keyof Composers[K] ? { [Name in keyof Composers[K][keyof Composers[K] & "variants"]]?: _stitches_react_types_util.String | _stitches_react_types_util.Widen<keyof Composers[K][keyof Composers[K] & "variants"][Name]> | undefined; } : _stitches_react_types_util.WideObject) & {
        css: CSS;
    })[] | undefined;
    defaultVariants?: ("variants" extends keyof Composers[K] ? { [Name_1 in keyof Composers[K][keyof Composers[K] & "variants"]]?: _stitches_react_types_util.String | _stitches_react_types_util.Widen<keyof Composers[K][keyof Composers[K] & "variants"][Name_1]> | undefined; } : _stitches_react_types_util.WideObject) | undefined;
} & CSS & { [K2 in keyof Composers[K]]: K2 extends "compoundVariants" | "defaultVariants" | "variants" ? unknown : K2 extends keyof CSS ? CSS[K2] : unknown; }; }) => _stitches_react_types_styled_component.CssComponent<_stitches_react_types_styled_component.StyledComponentType<Composers>, _stitches_react_types_styled_component.StyledComponentProps<Composers>, {
    sm: "(min-width: 640px)";
    md: "(min-width: 768px)";
    lg: "(min-width: 1024px)";
    xl: "(min-width: 1280px)";
    xxl: "(min-width: 1536px)";
}, CSS>;
declare const createTheme: <Argument0 extends string | ({
    borderWidths?: {
        none?: string | number | boolean | undefined;
        default?: string | number | boolean | undefined;
        thick?: string | number | boolean | undefined;
        thicker?: string | number | boolean | undefined;
    } | undefined;
    radii?: {
        none?: string | number | boolean | undefined;
        default?: string | number | boolean | undefined;
        full?: string | number | boolean | undefined;
    } | undefined;
    colors?: {
        base?: string | number | boolean | undefined;
        'transparent-dark-1'?: string | number | boolean | undefined;
        'transparent-dark-2'?: string | number | boolean | undefined;
        'transparent-dark-3'?: string | number | boolean | undefined;
        'transparent-dark-4'?: string | number | boolean | undefined;
        'transparent-dark-5'?: string | number | boolean | undefined;
        'transparent-light-1'?: string | number | boolean | undefined;
        'transparent-light-2'?: string | number | boolean | undefined;
        'transparent-light-3'?: string | number | boolean | undefined;
        'transparent-light-4'?: string | number | boolean | undefined;
        'transparent-light-5'?: string | number | boolean | undefined;
        'grey-1'?: string | number | boolean | undefined;
        'grey-2'?: string | number | boolean | undefined;
        'grey-3'?: string | number | boolean | undefined;
        'grey-4'?: string | number | boolean | undefined;
        'grey-5'?: string | number | boolean | undefined;
        'primary-1'?: string | number | boolean | undefined;
        'primary-2'?: string | number | boolean | undefined;
        'primary-3'?: string | number | boolean | undefined;
        'primary-4'?: string | number | boolean | undefined;
        'primary-5'?: string | number | boolean | undefined;
        'success-1'?: string | number | boolean | undefined;
        'success-2'?: string | number | boolean | undefined;
        'success-3'?: string | number | boolean | undefined;
        'success-4'?: string | number | boolean | undefined;
        'success-5'?: string | number | boolean | undefined;
        'warning-1'?: string | number | boolean | undefined;
        'warning-2'?: string | number | boolean | undefined;
        'warning-3'?: string | number | boolean | undefined;
        'warning-4'?: string | number | boolean | undefined;
        'warning-5'?: string | number | boolean | undefined;
        'error-1'?: string | number | boolean | undefined;
        'error-2'?: string | number | boolean | undefined;
        'error-3'?: string | number | boolean | undefined;
        'error-4'?: string | number | boolean | undefined;
        'error-5'?: string | number | boolean | undefined;
    } | undefined;
    fontSizes?: {
        default?: string | number | boolean | undefined;
        xs?: string | number | boolean | undefined;
        sm?: string | number | boolean | undefined;
        md?: string | number | boolean | undefined;
        lg?: string | number | boolean | undefined;
        xl?: string | number | boolean | undefined;
        xxl?: string | number | boolean | undefined;
    } | undefined;
    fontWeights?: {
        hairline?: string | number | boolean | undefined;
        thin?: string | number | boolean | undefined;
        light?: string | number | boolean | undefined;
        default?: string | number | boolean | undefined;
        medium?: string | number | boolean | undefined;
        semibold?: string | number | boolean | undefined;
        bold?: string | number | boolean | undefined;
        extrabold?: string | number | boolean | undefined;
        black?: string | number | boolean | undefined;
    } | undefined;
    lineHeights?: {
        none?: string | number | boolean | undefined;
        default?: string | number | boolean | undefined;
    } | undefined;
    shadows?: {
        none?: string | number | boolean | undefined;
        default?: string | number | boolean | undefined;
    } | undefined;
    sizes?: {} | undefined;
    space?: {
        auto?: string | number | boolean | undefined;
        full?: string | number | boolean | undefined;
        none?: string | number | boolean | undefined;
        0?: string | number | boolean | undefined;
        [-1]?: string | number | boolean | undefined;
        [-2]?: string | number | boolean | undefined;
        [-3]?: string | number | boolean | undefined;
        [-4]?: string | number | boolean | undefined;
        [-5]?: string | number | boolean | undefined;
        [-6]?: string | number | boolean | undefined;
        [-8]?: string | number | boolean | undefined;
        [-10]?: string | number | boolean | undefined;
        [-12]?: string | number | boolean | undefined;
        [-16]?: string | number | boolean | undefined;
        [-20]?: string | number | boolean | undefined;
        [-24]?: string | number | boolean | undefined;
        [-32]?: string | number | boolean | undefined;
        [-40]?: string | number | boolean | undefined;
        [-48]?: string | number | boolean | undefined;
        [-56]?: string | number | boolean | undefined;
        [-64]?: string | number | boolean | undefined;
        [-68]?: string | number | boolean | undefined;
        [-72]?: string | number | boolean | undefined;
        [-80]?: string | number | boolean | undefined;
        [-96]?: string | number | boolean | undefined;
        1?: string | number | boolean | undefined;
        2?: string | number | boolean | undefined;
        3?: string | number | boolean | undefined;
        4?: string | number | boolean | undefined;
        5?: string | number | boolean | undefined;
        6?: string | number | boolean | undefined;
        8?: string | number | boolean | undefined;
        10?: string | number | boolean | undefined;
        12?: string | number | boolean | undefined;
        16?: string | number | boolean | undefined;
        20?: string | number | boolean | undefined;
        24?: string | number | boolean | undefined;
        32?: string | number | boolean | undefined;
        40?: string | number | boolean | undefined;
        48?: string | number | boolean | undefined;
        56?: string | number | boolean | undefined;
        64?: string | number | boolean | undefined;
        68?: string | number | boolean | undefined;
        72?: string | number | boolean | undefined;
        80?: string | number | boolean | undefined;
        96?: string | number | boolean | undefined;
    } | undefined;
} & {
    [x: string]: {
        [x: string]: string | number | boolean;
        [x: number]: string | number | boolean;
    };
}), Argument1 extends string | ({
    borderWidths?: {
        none?: string | number | boolean | undefined;
        default?: string | number | boolean | undefined;
        thick?: string | number | boolean | undefined;
        thicker?: string | number | boolean | undefined;
    } | undefined;
    radii?: {
        none?: string | number | boolean | undefined;
        default?: string | number | boolean | undefined;
        full?: string | number | boolean | undefined;
    } | undefined;
    colors?: {
        base?: string | number | boolean | undefined;
        'transparent-dark-1'?: string | number | boolean | undefined;
        'transparent-dark-2'?: string | number | boolean | undefined;
        'transparent-dark-3'?: string | number | boolean | undefined;
        'transparent-dark-4'?: string | number | boolean | undefined;
        'transparent-dark-5'?: string | number | boolean | undefined;
        'transparent-light-1'?: string | number | boolean | undefined;
        'transparent-light-2'?: string | number | boolean | undefined;
        'transparent-light-3'?: string | number | boolean | undefined;
        'transparent-light-4'?: string | number | boolean | undefined;
        'transparent-light-5'?: string | number | boolean | undefined;
        'grey-1'?: string | number | boolean | undefined;
        'grey-2'?: string | number | boolean | undefined;
        'grey-3'?: string | number | boolean | undefined;
        'grey-4'?: string | number | boolean | undefined;
        'grey-5'?: string | number | boolean | undefined;
        'primary-1'?: string | number | boolean | undefined;
        'primary-2'?: string | number | boolean | undefined;
        'primary-3'?: string | number | boolean | undefined;
        'primary-4'?: string | number | boolean | undefined;
        'primary-5'?: string | number | boolean | undefined;
        'success-1'?: string | number | boolean | undefined;
        'success-2'?: string | number | boolean | undefined;
        'success-3'?: string | number | boolean | undefined;
        'success-4'?: string | number | boolean | undefined;
        'success-5'?: string | number | boolean | undefined;
        'warning-1'?: string | number | boolean | undefined;
        'warning-2'?: string | number | boolean | undefined;
        'warning-3'?: string | number | boolean | undefined;
        'warning-4'?: string | number | boolean | undefined;
        'warning-5'?: string | number | boolean | undefined;
        'error-1'?: string | number | boolean | undefined;
        'error-2'?: string | number | boolean | undefined;
        'error-3'?: string | number | boolean | undefined;
        'error-4'?: string | number | boolean | undefined;
        'error-5'?: string | number | boolean | undefined;
    } | undefined;
    fontSizes?: {
        default?: string | number | boolean | undefined;
        xs?: string | number | boolean | undefined;
        sm?: string | number | boolean | undefined;
        md?: string | number | boolean | undefined;
        lg?: string | number | boolean | undefined;
        xl?: string | number | boolean | undefined;
        xxl?: string | number | boolean | undefined;
    } | undefined;
    fontWeights?: {
        hairline?: string | number | boolean | undefined;
        thin?: string | number | boolean | undefined;
        light?: string | number | boolean | undefined;
        default?: string | number | boolean | undefined;
        medium?: string | number | boolean | undefined;
        semibold?: string | number | boolean | undefined;
        bold?: string | number | boolean | undefined;
        extrabold?: string | number | boolean | undefined;
        black?: string | number | boolean | undefined;
    } | undefined;
    lineHeights?: {
        none?: string | number | boolean | undefined;
        default?: string | number | boolean | undefined;
    } | undefined;
    shadows?: {
        none?: string | number | boolean | undefined;
        default?: string | number | boolean | undefined;
    } | undefined;
    sizes?: {} | undefined;
    space?: {
        auto?: string | number | boolean | undefined;
        full?: string | number | boolean | undefined;
        none?: string | number | boolean | undefined;
        0?: string | number | boolean | undefined;
        [-1]?: string | number | boolean | undefined;
        [-2]?: string | number | boolean | undefined;
        [-3]?: string | number | boolean | undefined;
        [-4]?: string | number | boolean | undefined;
        [-5]?: string | number | boolean | undefined;
        [-6]?: string | number | boolean | undefined;
        [-8]?: string | number | boolean | undefined;
        [-10]?: string | number | boolean | undefined;
        [-12]?: string | number | boolean | undefined;
        [-16]?: string | number | boolean | undefined;
        [-20]?: string | number | boolean | undefined;
        [-24]?: string | number | boolean | undefined;
        [-32]?: string | number | boolean | undefined;
        [-40]?: string | number | boolean | undefined;
        [-48]?: string | number | boolean | undefined;
        [-56]?: string | number | boolean | undefined;
        [-64]?: string | number | boolean | undefined;
        [-68]?: string | number | boolean | undefined;
        [-72]?: string | number | boolean | undefined;
        [-80]?: string | number | boolean | undefined;
        [-96]?: string | number | boolean | undefined;
        1?: string | number | boolean | undefined;
        2?: string | number | boolean | undefined;
        3?: string | number | boolean | undefined;
        4?: string | number | boolean | undefined;
        5?: string | number | boolean | undefined;
        6?: string | number | boolean | undefined;
        8?: string | number | boolean | undefined;
        10?: string | number | boolean | undefined;
        12?: string | number | boolean | undefined;
        16?: string | number | boolean | undefined;
        20?: string | number | boolean | undefined;
        24?: string | number | boolean | undefined;
        32?: string | number | boolean | undefined;
        40?: string | number | boolean | undefined;
        48?: string | number | boolean | undefined;
        56?: string | number | boolean | undefined;
        64?: string | number | boolean | undefined;
        68?: string | number | boolean | undefined;
        72?: string | number | boolean | undefined;
        80?: string | number | boolean | undefined;
        96?: string | number | boolean | undefined;
    } | undefined;
} & {
    [x: string]: {
        [x: string]: string | number | boolean;
        [x: number]: string | number | boolean;
    };
})>(nameOrScalesArg0: Argument0, nameOrScalesArg1?: Argument1 | undefined) => string & {
    className: string;
    selector: string;
} & (Argument0 extends string ? _stitches_react_types_stitches.ThemeTokens<Argument1, "smss"> : _stitches_react_types_stitches.ThemeTokens<Argument0, "smss">);
declare const globalCss: <Styles extends {
    [K: string]: any;
}>(...styles: ({
    '@import'?: unknown;
    '@font-face'?: unknown;
} & { [K in keyof Styles]: K extends "@import" ? string | string[] : K extends "@font-face" ? _stitches_react_types_css.AtRule.FontFace | _stitches_react_types_css.AtRule.FontFace[] : K extends `@keyframes ${string}` ? {
    [x: string]: _stitches_react_types_css_util.CSS<{
        sm: "(min-width: 640px)";
        md: "(min-width: 768px)";
        lg: "(min-width: 1024px)";
        xl: "(min-width: 1280px)";
        xxl: "(min-width: 1536px)";
    }, {
        borderWidths: {
            none: string;
            default: string;
            thick: string;
            thicker: string;
        };
        radii: {
            none: string;
            default: string;
            full: string;
        };
        colors: {
            base: string;
            'transparent-dark-1': string;
            'transparent-dark-2': string;
            'transparent-dark-3': string;
            'transparent-dark-4': string;
            'transparent-dark-5': string;
            'transparent-light-1': string;
            'transparent-light-2': string;
            'transparent-light-3': string;
            'transparent-light-4': string;
            'transparent-light-5': string;
            'grey-1': string;
            'grey-2': string;
            'grey-3': string;
            'grey-4': string;
            'grey-5': string;
            'primary-1': string;
            'primary-2': string;
            'primary-3': string;
            'primary-4': string;
            'primary-5': string;
            'success-1': string;
            'success-2': string;
            'success-3': string;
            'success-4': string;
            'success-5': string;
            'warning-1': string;
            'warning-2': string;
            'warning-3': string;
            'warning-4': string;
            'warning-5': string;
            'error-1': string;
            'error-2': string;
            'error-3': string;
            'error-4': string;
            'error-5': string;
        };
        fontSizes: {
            default: string;
            xs: string;
            sm: string;
            md: string;
            lg: string;
            xl: string;
            xxl: string;
        };
        fontWeights: {
            hairline: string;
            thin: string;
            light: string;
            default: string;
            medium: string;
            semibold: string;
            bold: string;
            extrabold: string;
            black: string;
        };
        lineHeights: {
            none: string;
            default: string;
        };
        shadows: {
            none: string;
            default: string;
        };
        sizes: unknown;
        space: {
            auto: string;
            full: string;
            none: string;
            0: string;
            '-1': string;
            '-2': string;
            '-3': string;
            '-4': string;
            '-5': string;
            '-6': string;
            '-8': string;
            '-10': string;
            '-12': string;
            '-16': string;
            '-20': string;
            '-24': string;
            '-32': string;
            '-40': string;
            '-48': string;
            '-56': string;
            '-64': string;
            '-68': string;
            '-72': string;
            '-80': string;
            '-96': string;
            '1': string;
            '2': string;
            '3': string;
            '4': string;
            '5': string;
            '6': string;
            '8': string;
            '10': string;
            '12': string;
            '16': string;
            '20': string;
            '24': string;
            '32': string;
            '40': string;
            '48': string;
            '56': string;
            '64': string;
            '68': string;
            '72': string;
            '80': string;
            '96': string;
        };
    }, _stitches_react_types_config.DefaultThemeMap, {}>;
} : K extends `@property ${string}` ? _stitches_react_types_css.AtRule.Property : _stitches_react_types_css_util.CSS<{
    sm: "(min-width: 640px)";
    md: "(min-width: 768px)";
    lg: "(min-width: 1024px)";
    xl: "(min-width: 1280px)";
    xxl: "(min-width: 1536px)";
}, {
    borderWidths: {
        none: string;
        default: string;
        thick: string;
        thicker: string;
    };
    radii: {
        none: string;
        default: string;
        full: string;
    };
    colors: {
        base: string;
        'transparent-dark-1': string;
        'transparent-dark-2': string;
        'transparent-dark-3': string;
        'transparent-dark-4': string;
        'transparent-dark-5': string;
        'transparent-light-1': string;
        'transparent-light-2': string;
        'transparent-light-3': string;
        'transparent-light-4': string;
        'transparent-light-5': string;
        'grey-1': string;
        'grey-2': string;
        'grey-3': string;
        'grey-4': string;
        'grey-5': string;
        'primary-1': string;
        'primary-2': string;
        'primary-3': string;
        'primary-4': string;
        'primary-5': string;
        'success-1': string;
        'success-2': string;
        'success-3': string;
        'success-4': string;
        'success-5': string;
        'warning-1': string;
        'warning-2': string;
        'warning-3': string;
        'warning-4': string;
        'warning-5': string;
        'error-1': string;
        'error-2': string;
        'error-3': string;
        'error-4': string;
        'error-5': string;
    };
    fontSizes: {
        default: string;
        xs: string;
        sm: string;
        md: string;
        lg: string;
        xl: string;
        xxl: string;
    };
    fontWeights: {
        hairline: string;
        thin: string;
        light: string;
        default: string;
        medium: string;
        semibold: string;
        bold: string;
        extrabold: string;
        black: string;
    };
    lineHeights: {
        none: string;
        default: string;
    };
    shadows: {
        none: string;
        default: string;
    };
    sizes: unknown;
    space: {
        auto: string;
        full: string;
        none: string;
        0: string;
        '-1': string;
        '-2': string;
        '-3': string;
        '-4': string;
        '-5': string;
        '-6': string;
        '-8': string;
        '-10': string;
        '-12': string;
        '-16': string;
        '-20': string;
        '-24': string;
        '-32': string;
        '-40': string;
        '-48': string;
        '-56': string;
        '-64': string;
        '-68': string;
        '-72': string;
        '-80': string;
        '-96': string;
        '1': string;
        '2': string;
        '3': string;
        '4': string;
        '5': string;
        '6': string;
        '8': string;
        '10': string;
        '12': string;
        '16': string;
        '20': string;
        '24': string;
        '32': string;
        '40': string;
        '48': string;
        '56': string;
        '64': string;
        '68': string;
        '72': string;
        '80': string;
        '96': string;
    };
}, _stitches_react_types_config.DefaultThemeMap, {}>; })[]) => () => string;
declare const theme: string & {
    className: string;
    selector: string;
} & {
    borderWidths: {
        none: _stitches_react_types_theme.Token<"none", string, "borderWidths", "smss">;
        default: _stitches_react_types_theme.Token<"default", string, "borderWidths", "smss">;
        thick: _stitches_react_types_theme.Token<"thick", string, "borderWidths", "smss">;
        thicker: _stitches_react_types_theme.Token<"thicker", string, "borderWidths", "smss">;
    };
    radii: {
        none: _stitches_react_types_theme.Token<"none", string, "radii", "smss">;
        default: _stitches_react_types_theme.Token<"default", string, "radii", "smss">;
        full: _stitches_react_types_theme.Token<"full", string, "radii", "smss">;
    };
    colors: {
        base: _stitches_react_types_theme.Token<"base", string, "colors", "smss">;
        'transparent-dark-1': _stitches_react_types_theme.Token<"transparent-dark-1", string, "colors", "smss">;
        'transparent-dark-2': _stitches_react_types_theme.Token<"transparent-dark-2", string, "colors", "smss">;
        'transparent-dark-3': _stitches_react_types_theme.Token<"transparent-dark-3", string, "colors", "smss">;
        'transparent-dark-4': _stitches_react_types_theme.Token<"transparent-dark-4", string, "colors", "smss">;
        'transparent-dark-5': _stitches_react_types_theme.Token<"transparent-dark-5", string, "colors", "smss">;
        'transparent-light-1': _stitches_react_types_theme.Token<"transparent-light-1", string, "colors", "smss">;
        'transparent-light-2': _stitches_react_types_theme.Token<"transparent-light-2", string, "colors", "smss">;
        'transparent-light-3': _stitches_react_types_theme.Token<"transparent-light-3", string, "colors", "smss">;
        'transparent-light-4': _stitches_react_types_theme.Token<"transparent-light-4", string, "colors", "smss">;
        'transparent-light-5': _stitches_react_types_theme.Token<"transparent-light-5", string, "colors", "smss">;
        'grey-1': _stitches_react_types_theme.Token<"grey-1", string, "colors", "smss">;
        'grey-2': _stitches_react_types_theme.Token<"grey-2", string, "colors", "smss">;
        'grey-3': _stitches_react_types_theme.Token<"grey-3", string, "colors", "smss">;
        'grey-4': _stitches_react_types_theme.Token<"grey-4", string, "colors", "smss">;
        'grey-5': _stitches_react_types_theme.Token<"grey-5", string, "colors", "smss">;
        'primary-1': _stitches_react_types_theme.Token<"primary-1", string, "colors", "smss">;
        'primary-2': _stitches_react_types_theme.Token<"primary-2", string, "colors", "smss">;
        'primary-3': _stitches_react_types_theme.Token<"primary-3", string, "colors", "smss">;
        'primary-4': _stitches_react_types_theme.Token<"primary-4", string, "colors", "smss">;
        'primary-5': _stitches_react_types_theme.Token<"primary-5", string, "colors", "smss">;
        'success-1': _stitches_react_types_theme.Token<"success-1", string, "colors", "smss">;
        'success-2': _stitches_react_types_theme.Token<"success-2", string, "colors", "smss">;
        'success-3': _stitches_react_types_theme.Token<"success-3", string, "colors", "smss">;
        'success-4': _stitches_react_types_theme.Token<"success-4", string, "colors", "smss">;
        'success-5': _stitches_react_types_theme.Token<"success-5", string, "colors", "smss">;
        'warning-1': _stitches_react_types_theme.Token<"warning-1", string, "colors", "smss">;
        'warning-2': _stitches_react_types_theme.Token<"warning-2", string, "colors", "smss">;
        'warning-3': _stitches_react_types_theme.Token<"warning-3", string, "colors", "smss">;
        'warning-4': _stitches_react_types_theme.Token<"warning-4", string, "colors", "smss">;
        'warning-5': _stitches_react_types_theme.Token<"warning-5", string, "colors", "smss">;
        'error-1': _stitches_react_types_theme.Token<"error-1", string, "colors", "smss">;
        'error-2': _stitches_react_types_theme.Token<"error-2", string, "colors", "smss">;
        'error-3': _stitches_react_types_theme.Token<"error-3", string, "colors", "smss">;
        'error-4': _stitches_react_types_theme.Token<"error-4", string, "colors", "smss">;
        'error-5': _stitches_react_types_theme.Token<"error-5", string, "colors", "smss">;
    };
    fontSizes: {
        default: _stitches_react_types_theme.Token<"default", string, "fontSizes", "smss">;
        xs: _stitches_react_types_theme.Token<"xs", string, "fontSizes", "smss">;
        sm: _stitches_react_types_theme.Token<"sm", string, "fontSizes", "smss">;
        md: _stitches_react_types_theme.Token<"md", string, "fontSizes", "smss">;
        lg: _stitches_react_types_theme.Token<"lg", string, "fontSizes", "smss">;
        xl: _stitches_react_types_theme.Token<"xl", string, "fontSizes", "smss">;
        xxl: _stitches_react_types_theme.Token<"xxl", string, "fontSizes", "smss">;
    };
    fontWeights: {
        hairline: _stitches_react_types_theme.Token<"hairline", string, "fontWeights", "smss">;
        thin: _stitches_react_types_theme.Token<"thin", string, "fontWeights", "smss">;
        light: _stitches_react_types_theme.Token<"light", string, "fontWeights", "smss">;
        default: _stitches_react_types_theme.Token<"default", string, "fontWeights", "smss">;
        medium: _stitches_react_types_theme.Token<"medium", string, "fontWeights", "smss">;
        semibold: _stitches_react_types_theme.Token<"semibold", string, "fontWeights", "smss">;
        bold: _stitches_react_types_theme.Token<"bold", string, "fontWeights", "smss">;
        extrabold: _stitches_react_types_theme.Token<"extrabold", string, "fontWeights", "smss">;
        black: _stitches_react_types_theme.Token<"black", string, "fontWeights", "smss">;
    };
    lineHeights: {
        none: _stitches_react_types_theme.Token<"none", string, "lineHeights", "smss">;
        default: _stitches_react_types_theme.Token<"default", string, "lineHeights", "smss">;
    };
    shadows: {
        none: _stitches_react_types_theme.Token<"none", string, "shadows", "smss">;
        default: _stitches_react_types_theme.Token<"default", string, "shadows", "smss">;
    };
    sizes: {};
    space: {
        auto: _stitches_react_types_theme.Token<"auto", string, "space", "smss">;
        full: _stitches_react_types_theme.Token<"full", string, "space", "smss">;
        none: _stitches_react_types_theme.Token<"none", string, "space", "smss">;
        0: _stitches_react_types_theme.Token<"0", string, "space", "smss">;
        [-1]: _stitches_react_types_theme.Token<"-1", string, "space", "smss">;
        [-2]: _stitches_react_types_theme.Token<"-2", string, "space", "smss">;
        [-3]: _stitches_react_types_theme.Token<"-3", string, "space", "smss">;
        [-4]: _stitches_react_types_theme.Token<"-4", string, "space", "smss">;
        [-5]: _stitches_react_types_theme.Token<"-5", string, "space", "smss">;
        [-6]: _stitches_react_types_theme.Token<"-6", string, "space", "smss">;
        [-8]: _stitches_react_types_theme.Token<"-8", string, "space", "smss">;
        [-10]: _stitches_react_types_theme.Token<"-10", string, "space", "smss">;
        [-12]: _stitches_react_types_theme.Token<"-12", string, "space", "smss">;
        [-16]: _stitches_react_types_theme.Token<"-16", string, "space", "smss">;
        [-20]: _stitches_react_types_theme.Token<"-20", string, "space", "smss">;
        [-24]: _stitches_react_types_theme.Token<"-24", string, "space", "smss">;
        [-32]: _stitches_react_types_theme.Token<"-32", string, "space", "smss">;
        [-40]: _stitches_react_types_theme.Token<"-40", string, "space", "smss">;
        [-48]: _stitches_react_types_theme.Token<"-48", string, "space", "smss">;
        [-56]: _stitches_react_types_theme.Token<"-56", string, "space", "smss">;
        [-64]: _stitches_react_types_theme.Token<"-64", string, "space", "smss">;
        [-68]: _stitches_react_types_theme.Token<"-68", string, "space", "smss">;
        [-72]: _stitches_react_types_theme.Token<"-72", string, "space", "smss">;
        [-80]: _stitches_react_types_theme.Token<"-80", string, "space", "smss">;
        [-96]: _stitches_react_types_theme.Token<"-96", string, "space", "smss">;
        1: _stitches_react_types_theme.Token<"1", string, "space", "smss">;
        2: _stitches_react_types_theme.Token<"2", string, "space", "smss">;
        3: _stitches_react_types_theme.Token<"3", string, "space", "smss">;
        4: _stitches_react_types_theme.Token<"4", string, "space", "smss">;
        5: _stitches_react_types_theme.Token<"5", string, "space", "smss">;
        6: _stitches_react_types_theme.Token<"6", string, "space", "smss">;
        8: _stitches_react_types_theme.Token<"8", string, "space", "smss">;
        10: _stitches_react_types_theme.Token<"10", string, "space", "smss">;
        12: _stitches_react_types_theme.Token<"12", string, "space", "smss">;
        16: _stitches_react_types_theme.Token<"16", string, "space", "smss">;
        20: _stitches_react_types_theme.Token<"20", string, "space", "smss">;
        24: _stitches_react_types_theme.Token<"24", string, "space", "smss">;
        32: _stitches_react_types_theme.Token<"32", string, "space", "smss">;
        40: _stitches_react_types_theme.Token<"40", string, "space", "smss">;
        48: _stitches_react_types_theme.Token<"48", string, "space", "smss">;
        56: _stitches_react_types_theme.Token<"56", string, "space", "smss">;
        64: _stitches_react_types_theme.Token<"64", string, "space", "smss">;
        68: _stitches_react_types_theme.Token<"68", string, "space", "smss">;
        72: _stitches_react_types_theme.Token<"72", string, "space", "smss">;
        80: _stitches_react_types_theme.Token<"80", string, "space", "smss">;
        96: _stitches_react_types_theme.Token<"96", string, "space", "smss">;
    };
};
declare const config: {
    prefix: "smss";
    media: {
        sm: "(min-width: 640px)";
        md: "(min-width: 768px)";
        lg: "(min-width: 1024px)";
        xl: "(min-width: 1280px)";
        xxl: "(min-width: 1536px)";
    };
    theme: {
        borderWidths: {
            none: string;
            default: string;
            thick: string;
            thicker: string;
        };
        radii: {
            none: string;
            default: string;
            full: string;
        };
        colors: {
            base: string;
            'transparent-dark-1': string;
            'transparent-dark-2': string;
            'transparent-dark-3': string;
            'transparent-dark-4': string;
            'transparent-dark-5': string;
            'transparent-light-1': string;
            'transparent-light-2': string;
            'transparent-light-3': string;
            'transparent-light-4': string;
            'transparent-light-5': string;
            'grey-1': string;
            'grey-2': string;
            'grey-3': string;
            'grey-4': string;
            'grey-5': string;
            'primary-1': string;
            'primary-2': string;
            'primary-3': string;
            'primary-4': string;
            'primary-5': string;
            'success-1': string;
            'success-2': string;
            'success-3': string;
            'success-4': string;
            'success-5': string;
            'warning-1': string;
            'warning-2': string;
            'warning-3': string;
            'warning-4': string;
            'warning-5': string;
            'error-1': string;
            'error-2': string;
            'error-3': string;
            'error-4': string;
            'error-5': string;
        };
        fontSizes: {
            default: string;
            xs: string;
            sm: string;
            md: string;
            lg: string;
            xl: string;
            xxl: string;
        };
        fontWeights: {
            hairline: string;
            thin: string;
            light: string;
            default: string;
            medium: string;
            semibold: string;
            bold: string;
            extrabold: string;
            black: string;
        };
        lineHeights: {
            none: string;
            default: string;
        };
        shadows: {
            none: string;
            default: string;
        };
        sizes: unknown;
        space: {
            auto: string;
            full: string;
            none: string;
            0: string;
            '-1': string;
            '-2': string;
            '-3': string;
            '-4': string;
            '-5': string;
            '-6': string;
            '-8': string;
            '-10': string;
            '-12': string;
            '-16': string;
            '-20': string;
            '-24': string;
            '-32': string;
            '-40': string;
            '-48': string;
            '-56': string;
            '-64': string;
            '-68': string;
            '-72': string;
            '-80': string;
            '-96': string;
            '1': string;
            '2': string;
            '3': string;
            '4': string;
            '5': string;
            '6': string;
            '8': string;
            '10': string;
            '12': string;
            '16': string;
            '20': string;
            '24': string;
            '32': string;
            '40': string;
            '48': string;
            '56': string;
            '64': string;
            '68': string;
            '72': string;
            '80': string;
            '96': string;
        };
    };
    themeMap: _stitches_react_types_config.DefaultThemeMap;
    utils: {};
};
declare const keyframes: (style: {
    [offset: string]: _stitches_react_types_css_util.CSS<{
        sm: "(min-width: 640px)";
        md: "(min-width: 768px)";
        lg: "(min-width: 1024px)";
        xl: "(min-width: 1280px)";
        xxl: "(min-width: 1536px)";
    }, {
        borderWidths: {
            none: string;
            default: string;
            thick: string;
            thicker: string;
        };
        radii: {
            none: string;
            default: string;
            full: string;
        };
        colors: {
            base: string;
            'transparent-dark-1': string;
            'transparent-dark-2': string;
            'transparent-dark-3': string;
            'transparent-dark-4': string;
            'transparent-dark-5': string;
            'transparent-light-1': string;
            'transparent-light-2': string;
            'transparent-light-3': string;
            'transparent-light-4': string;
            'transparent-light-5': string;
            'grey-1': string;
            'grey-2': string;
            'grey-3': string;
            'grey-4': string;
            'grey-5': string;
            'primary-1': string;
            'primary-2': string;
            'primary-3': string;
            'primary-4': string;
            'primary-5': string;
            'success-1': string;
            'success-2': string;
            'success-3': string;
            'success-4': string;
            'success-5': string;
            'warning-1': string;
            'warning-2': string;
            'warning-3': string;
            'warning-4': string;
            'warning-5': string;
            'error-1': string;
            'error-2': string;
            'error-3': string;
            'error-4': string;
            'error-5': string;
        };
        fontSizes: {
            default: string;
            xs: string;
            sm: string;
            md: string;
            lg: string;
            xl: string;
            xxl: string;
        };
        fontWeights: {
            hairline: string;
            thin: string;
            light: string;
            default: string;
            medium: string;
            semibold: string;
            bold: string;
            extrabold: string;
            black: string;
        };
        lineHeights: {
            none: string;
            default: string;
        };
        shadows: {
            none: string;
            default: string;
        };
        sizes: unknown;
        space: {
            auto: string;
            full: string;
            none: string;
            0: string;
            '-1': string;
            '-2': string;
            '-3': string;
            '-4': string;
            '-5': string;
            '-6': string;
            '-8': string;
            '-10': string;
            '-12': string;
            '-16': string;
            '-20': string;
            '-24': string;
            '-32': string;
            '-40': string;
            '-48': string;
            '-56': string;
            '-64': string;
            '-68': string;
            '-72': string;
            '-80': string;
            '-96': string;
            '1': string;
            '2': string;
            '3': string;
            '4': string;
            '5': string;
            '6': string;
            '8': string;
            '10': string;
            '12': string;
            '16': string;
            '20': string;
            '24': string;
            '32': string;
            '40': string;
            '48': string;
            '56': string;
            '64': string;
            '68': string;
            '72': string;
            '80': string;
            '96': string;
        };
    }, _stitches_react_types_config.DefaultThemeMap, {}>;
}) => {
    (): string;
    name: string;
};
declare const getCssText: () => string;
declare const globalStyles: () => string;
declare type StitchesCSS = Stitches.CSS<typeof config>;

/**
 * @link https://usehooks.com/useDebounce/
 */
declare function useDebounce<T>(value: T, delay: number): T;

/**
 * Merge the default value with the normal value and update when either change
 * @param props
 * @returns the value and a method to set it
 */
declare function useFocusTrap(): {
    setTrap: (node: HTMLElement | null) => void;
};

/**
 * Generate a unique id
 * @param id - optional user id to use
 * @returns a unique id for an element
 */
declare function useId(id?: string): string;

/**
 * Watch for changes on an element an
 * @param ref - element to watch for resizes
 * @param callback - tallback to trigger when the element resizes
 * @returns
 */
declare const useIntersectionObserver: (ref: RefObject<HTMLElement>, callback: () => void, options?: IntersectionObserverInit | undefined) => void;

/**
 * Watch for changes on an element an
 * @param ref - element to watch for resizes
 * @param callback - tallback to trigger when the element resizes
 * @returns
 */
declare const useResizeObserver: (ref: RefObject<HTMLElement>, callback: (entry: DOMRectReadOnly) => void) => void;

interface useValueProps<V> {
    /** Value to track */
    value?: V;
    /** Default Value of the input */
    defaultValue?: V;
    /** Value if no value is set */
    initialValue: V;
    /** Callback that is triggered when the value changes */
    onChange?: (value: V) => void;
}
/**
 * Merge the default value with the normal value and update when either change
 * @param props
 * @returns the value and a method to set it
 */
declare function useValue<V>(props: useValueProps<V>): [V, (updated: V) => void];

interface BaseAccordion<V> extends Omit<ComponentPropsWithRef<'div'>, 'onChange' | 'defaultValue'> {
    /** Value of the accordion */
    value: V;
    /** Callback that is triggered when the value changes */
    onChange?: (value: V) => void;
    /** Mark the accordion in a disabled/enabled state */
    disabled?: boolean;
    /** Mark the accordion as collapsible */
    collapsible?: boolean;
}
interface SingleAccordion extends BaseAccordion<string> {
    multiple: false;
}
interface MultipleAccordion extends BaseAccordion<string[]> {
    multiple: true;
}
declare type AccordionProps = SingleAccordion | MultipleAccordion;

declare type AccordionContentProps = ComponentPropsWithRef<'div'>;

interface AccordionItemProps extends ComponentPropsWithRef<'div'> {
    /** Value of the accorion item */
    value: string;
    /** Mark the accordion item in a disabled/enabled state */
    disabled?: boolean;
}

declare type AccordionTriggerProps = ComponentPropsWithRef<'h1'>;

declare const AccordionNameSpace: ((props: AccordionProps & {
    ref?: react.ForwardedRef<HTMLDivElement> | undefined;
}) => JSX.Element) & {
    Content: (props: Pick<react.DetailedHTMLProps<react.HTMLAttributes<HTMLDivElement>, HTMLDivElement>, "key" | keyof react.HTMLAttributes<HTMLDivElement>> & {
        ref?: ((instance: HTMLDivElement | null) => void) | react.RefObject<HTMLDivElement> | null | undefined;
    } & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    Item: (props: AccordionItemProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    Trigger: (props: Pick<react.DetailedHTMLProps<react.HTMLAttributes<HTMLHeadingElement>, HTMLHeadingElement>, "key" | keyof react.HTMLAttributes<HTMLHeadingElement>> & {
        ref?: ((instance: HTMLHeadingElement | null) => void) | react.RefObject<HTMLHeadingElement> | null | undefined;
    } & {
        ref?: react.ForwardedRef<HTMLHeadingElement> | undefined;
    }) => JSX.Element;
};

interface InputOptions<V> {
    /** ID of the input */
    id?: string;
    /** Value of the input */
    value?: V;
    /** Default Value of the input */
    defaultValue?: V;
    /** Callback that is triggered when the value changes */
    onChange?: (value: V) => void;
    /** Mark the input in a disabled/enabled state */
    disabled?: boolean;
    /** Mark the input in a valid/invalid state */
    valid?: boolean;
}

interface BaseFormInputProps<V> extends InputOptions<V>, Omit<ComponentPropsWithRef<'div'>, 'value' | 'defaultValue' | 'defaultChecked' | 'onChange'> {
    /** Set the size of the FormInput */
    size?: 'sm' | 'md' | 'lg';
}

interface BaseCalendarProps extends Omit<ComponentPropsWithoutRef<'div'>, 'value' | 'defaultValue' | 'defaultChecked' | 'onChange'> {
    /** Format of the Calendar's value */
    format?: string;
}

interface IconButtonProps extends ComponentPropsWithRef<'button'> {
    /** Rendered color of the IconButton */
    color?: 'primary' | 'success' | 'error' | 'warning' | 'grey';
    /** Rendered size of the IconButton */
    size?: BaseFormInputProps<never>['size'];
    /** Type of the button. Defaults to 'button' */
    type?: 'reset' | 'submit' | 'button';
}
/**
 * IconButton component
 */
declare const _IconButton: (props: IconButtonProps, ref: ForwardedRef<HTMLButtonElement>) => JSX.Element;
declare const IconButton: (props: IconButtonProps & {
    ref?: ForwardedRef<HTMLButtonElement>;
}) => ReturnType<typeof _IconButton>;

interface AlertProps extends ComponentPropsWithRef<'div'> {
    /** Rendered color of the Button */
    color?: 'primary' | 'success' | 'error' | 'warning';
    /** Rendered variant of the Alert */
    variant?: 'filled' | 'outline' | 'notification';
    /** Action to pass into the Alert */
    action?: ReactNode;
    /** Toggle to show the close icon */
    closeable?: boolean;
    /** Callback triggered on close */
    onClose?: () => void;
    /** Props to pass to the close */
    closeProps?: Omit<IconButtonProps, 'size'>;
}
/**
 * Alert component
 */
declare const _Alert: (props: AlertProps, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Alert: (props: AlertProps & {
    ref?: ForwardedRef<HTMLDivElement>;
}) => ReturnType<typeof _Alert>;

interface BreadcrumbProps extends react__default.ComponentPropsWithRef<'ol'> {
    /** Seperator to seperate the breadcrumbs */
    seperator?: react__default.ReactNode;
}

interface BreadcrumbItemProps extends react__default.ComponentPropsWithRef<'a'> {
    href: HTMLAnchorElement['href'];
}

declare const BreadcrumbNameSpace: react.ForwardRefExoticComponent<Pick<BreadcrumbProps, "prefix" | "color" | "translate" | "hidden" | "dir" | "slot" | "style" | "title" | "aria-hidden" | "defaultValue" | "onChange" | "key" | "defaultChecked" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "draggable" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "children" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancel" | "onTouchCancelCapture" | "onTouchEnd" | "onTouchEndCapture" | "onTouchMove" | "onTouchMoveCapture" | "onTouchStart" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "type" | "start" | "reversed" | "seperator"> & react.RefAttributes<HTMLOListElement>> & {
    Item: react.ForwardRefExoticComponent<Pick<BreadcrumbItemProps, "prefix" | "color" | "translate" | "hidden" | "media" | "dir" | "slot" | "style" | "title" | "aria-hidden" | "defaultValue" | "onChange" | "key" | "defaultChecked" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "draggable" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "children" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancel" | "onTouchCancelCapture" | "onTouchEnd" | "onTouchEndCapture" | "onTouchMove" | "onTouchMoveCapture" | "onTouchStart" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "type" | "download" | "href" | "hrefLang" | "ping" | "rel" | "target" | "referrerPolicy"> & react.RefAttributes<HTMLAnchorElement>>;
};

interface ButtonProps extends ComponentPropsWithRef<'button'> {
    /** Rendered color of the Button */
    color?: 'primary' | 'success' | 'error' | 'warning' | 'grey';
    /** Rendered size of the Button */
    size?: BaseFormInputProps<never>['size'];
    /** Set to true to take up the full space */
    block?: boolean;
    /** Rendered variant of the Button */
    variant?: 'filled' | 'outline' | 'text';
    /** Type of the button. Defaults to 'button' */
    type?: 'reset' | 'submit' | 'button';
    /** Content to add before the children */
    prepend?: React.ReactNode;
    /** Content to add after the children */
    append?: React.ReactNode;
}
/**
 * Button component
 */
declare const _Button: (props: ButtonProps, ref: ForwardedRef<HTMLButtonElement>) => JSX.Element;
declare const Button: (props: ButtonProps & {
    ref?: ForwardedRef<HTMLButtonElement>;
}) => ReturnType<typeof _Button>;

interface CalendarProps extends InputOptions<string>, BaseCalendarProps {
}
/**
 * Calendar component
 */
declare const _Calendar: (props: CalendarProps, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Calendar: (props: CalendarProps & {
    ref?: ForwardedRef<HTMLDivElement>;
}) => ReturnType<typeof _Calendar>;

interface CheckboxProps extends InputOptions<boolean>, Omit<ComponentPropsWithRef<'label'>, 'value' | 'defaultValue' | 'defaultChecked' | 'onChange'> {
    /** Mark the Checkbox in an indeterminate state. The box must be checked to show the indicator */
    indeterminate?: boolean;
    /** Props to pass to the input */
    inputProps?: React.InputHTMLAttributes<HTMLInputElement>;
}
/**
 * Checkbox component
 */
declare const _Checkbox: (props: CheckboxProps, ref: ForwardedRef<HTMLLabelElement>) => JSX.Element;
declare const Checkbox: (props: CheckboxProps & {
    ref?: ForwardedRef<HTMLLabelElement>;
}) => ReturnType<typeof _Checkbox>;

interface BaseChecklist<O, V> extends BaseFormInputProps<V> {
    /** Options to render in the list of the Checklist */
    options: O[];
    /** Allow multiple options to be selected */
    multiple?: boolean;
    /** Show a select all button when multiple */
    selectAll?: boolean;
    /** Placeholder to show when there is no value */
    placeholder?: string;
    /** Props to pass to the input */
    inputProps?: React.InputHTMLAttributes<HTMLInputElement>;
    /** Search term */
    search?: string;
    /** Filter the options on search */
    filter?: boolean;
    /** Callback that is triggered when search is updated */
    onSearch?: (value: string) => void;
    /** Callback that is triggered when the end of the list is reached */
    onLoad?: () => void;
    /** Callback that is triggered on search. This returns true if the option should be included. */
    getSearch?: (search: string, option: O) => boolean;
    /** Callback that is triggered to get the unique key of an option */
    getKey?: (option: O) => string;
    /** Callback that is triggered to get the display of an option */
    getDisplay?: (option: O) => ReactNode;
}
declare type SingleChecklist<O> = BaseChecklist<O, O | null>;
declare type MultipleChecklist<O> = BaseChecklist<O, O[]>;
declare type ChecklistProps<O, multiple extends boolean> = multiple extends true ? MultipleChecklist<O> : SingleChecklist<O>;
declare const _Checklist: <O, multiple extends boolean>(props: ChecklistProps<O, multiple>, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Checklist: <O, multiple extends boolean>(props: ChecklistProps<O, multiple> & {
    ref?: ForwardedRef<HTMLDivElement> | undefined;
}) => ReturnType<typeof _Checklist>;

interface CurrencyPickerProps extends BaseFormInputProps<number | null> {
    /** Placeholder to show when there is no value */
    placeholder?: string;
    /** Props to pass to the input */
    inputProps?: react__default.InputHTMLAttributes<HTMLInputElement>;
}
declare const _CurrencyPicker: (props: CurrencyPickerProps, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const CurrencyPicker: (props: CurrencyPickerProps & {
    ref?: ForwardedRef<HTMLDivElement>;
}) => ReturnType<typeof _CurrencyPicker>;

interface DatepickerProps extends BaseCalendarProps, BaseFormInputProps<string> {
    /** Placeholder to show when there is no value */
    placeholder?: string;
    /** Props to pass to the input */
    inputProps?: React.InputHTMLAttributes<HTMLInputElement>;
    /** Container to append the calendar to */
    container?: HTMLElement | null;
}
declare const _Datepicker: (props: DatepickerProps, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Datepicker: (props: DatepickerProps & {
    ref?: ForwardedRef<HTMLDivElement>;
}) => ReturnType<typeof _Datepicker>;

interface DropdownProps {
    /** Dropdown Trigger and Content */
    children: ReactNode;
    /** Boolean to control the state of the dropdown */
    open?: boolean;
    /** Callback that is triggered when the dropdown is opened */
    onOpen?: () => void;
    /** Callback that is triggered when the dropdown is closed */
    onClose?: () => void;
}

interface DropdownContentProps extends ComponentPropsWithRef<'div'> {
    /** Content to display in the popover */
    children: ReactNode;
    /** Side where the content is position (relative to the trigger)  */
    side?: 'top' | 'right' | 'bottom' | 'left';
    /** Pixel distance the popover is away from the side  */
    offset?: number;
    /** Alignment of the content (relative to the trigger)  */
    align?: 'start' | 'center' | 'end';
    /** Container to append the dropdown to */
    container?: HTMLElement | null;
}

interface DropdownItemProps extends Omit<ComponentPropsWithRef<'div'>, 'onSelect'> {
    /** Mark the item in a disabled/enabled state */
    disabled?: boolean;
    /** Callback that is triggered when the item is selected */
    onSelect?: (event: Event) => void;
}

interface DropdownLabelProps extends ComponentPropsWithRef<'div'> {
    /** Allow the label to wrap to the next line */
    nowrap?: boolean;
}

declare type DropdownSeperatorProps = ComponentPropsWithRef<'div'>;

interface DropdownSubMenuProps {
    /** DropdownSubMenu Trigger and Content */
    children: ReactNode;
}

interface DropdownSubMenuContentProps extends ComponentPropsWithRef<'div'> {
    /** Content to display in the popover */
    children: ReactNode;
    /** Container to append the dropdown to */
    container?: HTMLElement | null;
}

interface DropdownSubMenuTriggerProps extends Omit<ComponentPropsWithRef<'div'>, 'onSelect'> {
    /** Mark the item in a disabled/enabled state */
    disabled?: boolean;
}

interface DropdownTriggerProps {
    /** Content to act as the popover trigger */
    children: ReactNode;
}

declare const DropdownNameSpace: ((props: DropdownProps) => JSX.Element) & {
    Content: (props: DropdownContentProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    Item: (props: DropdownItemProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    Label: (props: DropdownLabelProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    Seperator: (props: Pick<react.DetailedHTMLProps<react.HTMLAttributes<HTMLDivElement>, HTMLDivElement>, "key" | keyof react.HTMLAttributes<HTMLDivElement>> & {
        ref?: ((instance: HTMLDivElement | null) => void) | react.RefObject<HTMLDivElement> | null | undefined;
    } & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    SubMenu: (props: DropdownSubMenuProps) => JSX.Element;
    SubMenuContent: (props: DropdownSubMenuContentProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    SubMenuTrigger: (props: DropdownSubMenuTriggerProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    Trigger: (props: DropdownTriggerProps & {
        ref?: react.ForwardedRef<HTMLButtonElement> | undefined;
    }) => JSX.Element;
};

declare type FormValue = {
    layout: 'horizontal' | 'vertical';
    labelOptions: {
        width?: StitchesCSS['width'];
    };
};

interface FormProps extends Omit<ComponentPropsWithoutRef<'form'>, 'onSubmit'> {
    /** Layout of the form */
    layout?: FormValue['layout'];
    /** Options to wrap the label with */
    labelOptions?: FormValue['labelOptions'];
    /** Callback that is triggered on submit of the form */
    onSubmit?: () => void;
}

interface FormGroupProps {
    /** Children to render */
    children: ReactNode;
    /** Layout of the form */
    layout?: FormValue['layout'];
    /** Options to wrap the label with */
    labelOptions?: FormValue['labelOptions'];
}

interface FormDescriptionProps extends ComponentPropsWithRef<'div'> {
    /** Allow the FormDescription to wrap to the next line */
    nowrap?: boolean;
}

interface FormErrorProps extends ComponentPropsWithRef<'div'> {
    /** Allow the FormError to wrap to the next line */
    nowrap?: boolean;
}

interface FormLabelProps extends ComponentPropsWithRef<'label'> {
    /** Allow the label to wrap to the next line */
    nowrap?: boolean;
}

declare type FormFieldOptions = Partial<Pick<InputOptions<unknown>, 'id'>>;
interface FormFieldProps extends FormFieldOptions, Omit<ComponentPropsWithoutRef<'div'>, 'value' | 'defaultValue' | 'defaultChecked' | 'onChange'> {
    /** Layout of the label */
    layout?: FormValue['layout'];
    /** Content to render in the label */
    label?: ReactNode;
    /** Props to pass to the label */
    labelProps?: FormLabelProps;
    /** Content to render in the description */
    description?: ReactNode;
    /** Props to pass to the description */
    descriptionProps?: FormDescriptionProps;
    /** Content to render in the error */
    error?: ReactNode;
    /** Props to pass to the error */
    errorProps?: FormErrorProps;
    /** Children to render */
    children: ReactNode | ((props: {
        getFieldProps: <T>(props?: T) => Record<string, unknown>;
        getLabelProps: <T extends FormLabelProps>(props?: T) => Record<string, unknown>;
        getDescriptionProps: <T extends FormDescriptionProps>(props?: T) => Record<string, unknown>;
        getErrorProps: <T extends FormErrorProps>(props?: T) => Record<string, unknown>;
    }) => JSX.Element);
}

declare const FormNameSpace: ((props: FormProps) => JSX.Element) & {
    Group: (props: FormGroupProps) => JSX.Element;
    Field: (props: FormFieldProps) => JSX.Element;
    Label: (props: FormLabelProps & {
        ref?: react.ForwardedRef<HTMLLabelElement> | undefined;
    }) => JSX.Element;
    Error: (props: FormErrorProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    Description: (props: FormDescriptionProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
};

interface BaseFileDropzoneProps<V> extends InputOptions<V>, Omit<ComponentPropsWithRef<'div'>, 'value' | 'defaultValue' | 'defaultChecked' | 'onChange'> {
    /** Allow multiple files to be added */
    multiple?: boolean;
    /** Description to show on the filepicker */
    description?: string;
    /** List of allowed file types */
    extensions?: string[];
    /** Props to pass to the input */
    inputProps?: react__default.InputHTMLAttributes<HTMLInputElement>;
}
declare type FileValue<Multiple extends boolean> = Multiple extends true ? File[] : File | null;
declare type FileDropzoneProps<Multiple extends boolean> = BaseFileDropzoneProps<FileValue<Multiple>>;
declare const _FileDropzone: <Multiple extends boolean>(props: FileDropzoneProps<Multiple>, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const FileDropzone: <Multiple extends boolean>(props: FileDropzoneProps<Multiple> & {
    ref?: react__default.ForwardedRef<HTMLDivElement> | undefined;
}) => ReturnType<typeof _FileDropzone>;

interface FlexProps extends react__default.ComponentPropsWithRef<'div'> {
    /** Direction of the flex box */
    direction?: StitchesCSS['flexDirection'];
    /** Justify the content */
    justify?: StitchesCSS['justifyContent'];
    /** Align the content */
    align?: StitchesCSS['alignItems'];
    /** Wrap the content */
    wrap?: StitchesCSS['flexWrap'];
    /** */
    basis?: StitchesCSS['flexBasis'];
    /** */
    grow?: StitchesCSS['flexGrow'];
    /** */
    shrink?: StitchesCSS['flexShrink'];
    /** Gap between the children */
    gap?: StitchesCSS['gap'];
}
declare const Flex: react__default.ForwardRefExoticComponent<Pick<FlexProps, "prefix" | "color" | "direction" | "translate" | "gap" | "hidden" | "dir" | "slot" | "style" | "title" | "aria-hidden" | "defaultValue" | "onChange" | "key" | "defaultChecked" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "draggable" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "children" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancel" | "onTouchCancelCapture" | "onTouchEnd" | "onTouchEndCapture" | "onTouchMove" | "onTouchMoveCapture" | "onTouchStart" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "wrap" | "justify" | "align" | "basis" | "grow" | "shrink"> & react__default.RefAttributes<HTMLDivElement>>;

declare type GridValue = {
    /** Number of columns in the grid */
    columns: number;
    /** Size of the gutter */
    gutterX: StitchesCSS['padding'];
    /** Size of the gutter */
    gutterY: StitchesCSS['padding'];
};

interface GridProps extends ComponentPropsWithRef<'div'> {
    /** Number of columns in the grid */
    columns?: GridValue['columns'];
    /** Size of the gutter */
    gutterX?: GridValue['gutterX'];
    /** Size of the gutter */
    gutterY?: GridValue['gutterY'];
    /** Justify the content */
    justify?: StitchesCSS['justifyContent'];
    /** Align the content */
    align?: StitchesCSS['alignItems'];
    /** Align the content */
    wrap?: StitchesCSS['flexWrap'];
}

interface GridItemProps extends ComponentPropsWithRef<'div'> {
    /** Number of columns to span the grid */
    span?: number;
    /** Responsive of columns to span the grid */
    responsive?: {
        sm?: number;
        md?: number;
        lg?: number;
        xl?: number;
        xxl?: number;
    };
}

declare const GridNameSpace: ((props: GridProps & {
    ref?: react.ForwardedRef<HTMLLabelElement> | undefined;
}) => JSX.Element) & {
    Item: (props: GridItemProps & {
        ref?: react.ForwardedRef<HTMLLabelElement> | undefined;
    }) => JSX.Element;
};

declare type IconProps = ComponentPropsWithRef<typeof Icon$1>;
declare const Icon: (props: IconProps) => JSX.Element;

declare type Value = string | number;
interface InputProps<V extends Value> extends BaseFormInputProps<V> {
    /** Type of the input */
    type?: HTMLInputElement['type'];
    /** Placeholder to show when there is no value */
    placeholder?: string;
    /** Specifies autocomplete on the input */
    autoComplete?: HTMLInputElement['autocomplete'];
    /** Props to pass to the input */
    inputProps?: React.InputHTMLAttributes<HTMLInputElement>;
}
/**
 * Input component
 */
declare const _Input: <V extends Value>(props: InputProps<V>, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Input: <V extends Value>(props: InputProps<V> & {
    ref?: ForwardedRef<HTMLDivElement> | undefined;
}) => ReturnType<typeof _Input>;

interface LoadingProps extends react__default.ComponentPropsWithRef<'div'> {
    /** Mark the loading in a open/closed state */
    open: boolean;
    /** Time till the loading is open */
    delay?: number;
    /** Message to render in the Loading */
    message?: react__default.ReactNode;
    /** Description to render in the Loading */
    description?: react__default.ReactNode;
}
/**
 * Loading component
 */
declare const Loading: react__default.ForwardRefExoticComponent<Pick<LoadingProps, "prefix" | "color" | "translate" | "hidden" | "dir" | "slot" | "style" | "title" | "aria-hidden" | "defaultValue" | "onChange" | "key" | "defaultChecked" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "draggable" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "children" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancel" | "onTouchCancelCapture" | "onTouchEnd" | "onTouchEndCapture" | "onTouchMove" | "onTouchMoveCapture" | "onTouchStart" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "open" | "description" | "delay" | "message"> & react__default.RefAttributes<HTMLDivElement>>;

interface ModalProps extends ComponentPropsWithoutRef<'div'> {
    /** Mark the modal in a open/closed state */
    open?: boolean;
    /** Callback triggered on open */
    onOpen?: (open: true) => void;
    /** Callback triggered on close */
    onClose?: (open: false) => void;
}

interface ModalBodyProps {
    /** Content to act as the modal body */
    children: ReactNode;
}

interface ModalContentProps {
    /** Container for the modal's content */
    container?: HTMLElement;
    /** Content to act as the modal's content */
    children: ReactNode;
    /** Size of the modal's content */
    size?: 'sm' | 'md' | 'lg';
}

interface ModalCloseProps {
    /** Content to act as the modal close */
    children: ReactNode;
}

interface ModalFooterProps extends ComponentPropsWithRef<'div'> {
    /** Content to act as the modal footer */
    children: ReactNode;
}

interface ModalHeaderProps extends ComponentPropsWithRef<'div'> {
    /** Content to act as the modal's header */
    children: ReactNode;
    /** Allow the modal to be closed */
    closeable?: boolean;
    /** Description to pass into the header */
    description?: ReactNode;
}

interface ModalTriggerProps {
    /** Content to act as the modal trigger */
    children: ReactNode;
}

declare const ModalNameSpace: ((props: ModalProps) => JSX.Element) & {
    Body: (props: ModalBodyProps & {
        ref?: react.ForwardedRef<HTMLButtonElement> | undefined;
    }) => JSX.Element;
    Content: (props: ModalContentProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    Close: (props: ModalCloseProps & {
        ref?: react.ForwardedRef<HTMLButtonElement> | undefined;
    }) => JSX.Element;
    Footer: (props: ModalFooterProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    Header: (props: ModalHeaderProps & {
        ref?: react.ForwardedRef<HTMLHeadingElement> | undefined;
    }) => JSX.Element;
    Trigger: (props: ModalTriggerProps & {
        ref?: react.ForwardedRef<HTMLButtonElement> | undefined;
    }) => JSX.Element;
};

interface NotificationContainerProps extends ComponentPropsWithoutRef<'div'> {
    /** Content to render the notifications in */
    children: ReactNode;
    /** Container to render the notifications in */
    container?: HTMLElement | null;
    /** Position of the notifications */
    position?: 'top-right' | 'top-left' | 'bottom-right' | 'bottom-left';
}

interface NotificationItemProps {
    /** Content to render into the NotificationItem */
    children: ReactNode;
    /** Allow the notifications to be autoclosed */
    autoClose: boolean;
    /** Time till the notification is closed */
    delay: number;
    /** Called when to close the item */
    onClose: () => void;
}

declare type NotificationValue<S> = {
    /** List of notifications */
    notifications: {
        id: string;
        state: S;
    }[];
    /** Add a new item to the notifications */
    add: (state: S, id?: string) => void;
    /** Remove a notification from the list */
    remove: (id: string) => void;
};
interface NotificationProviderProps<S> extends ComponentPropsWithoutRef<'div'> {
    /** Content to render the notifications in */
    children?: ReactNode;
    /** Method to Render the alert */
    render: (value: NotificationValue<S>, state: S, id: string) => ReactNode;
    /** Container to render the notifications in */
    container?: NotificationContainerProps['container'];
    /** Position of the notifications */
    position?: NotificationContainerProps['position'];
    /** Allow the notifications to be autoclosed */
    autoClose?: NotificationItemProps['autoClose'];
    /** Time till the notification is closed */
    delay?: NotificationItemProps['delay'];
    /** Maximum number of notifications to render at one time */
    limit?: number;
}

declare const createNotification: <S>() => {
    useNotification: () => NotificationValue<S>;
    Notification: (props: NotificationProviderProps<S>) => JSX.Element;
};

declare const NotificationService: {
    useNotification: () => NotificationValue<{
        /** Color of the notification */
        color: AlertProps['color'];
        /** Content to pass into the notification */
        content: ReactNode;
    }>;
    Notification: (props: NotificationProviderProps<{
        /** Color of the notification */
        color: AlertProps['color'];
        /** Content to pass into the notification */
        content: ReactNode;
    }>) => JSX.Element;
};
declare type NotificationProps = Omit<ComponentProps<typeof NotificationService.Notification>, 'render'>;
/**
 * Notification component
 */
declare const Notification: (props: NotificationProps) => JSX.Element;
declare const useNotification: () => NotificationValue<{
    /** Color of the notification */
    color: AlertProps['color'];
    /** Content to pass into the notification */
    content: ReactNode;
}>;

interface OverrideProps extends ComponentPropsWithoutRef<'div'> {
    /** Theme to override the child components */
    theme: ReturnType<typeof createTheme>;
}
declare const Override: (props: OverrideProps) => JSX.Element;

interface PaginationProps extends Omit<react__default.ComponentPropsWithRef<'div'>, 'value' | 'defaultValue' | 'onChange'> {
    /** Value of the selected page. */
    value: number;
    /** Default selected page. */
    defaultValue?: number;
    /** Callback that is triggered when the selected page changes */
    onChange?: (value: number) => void;
    /** Mark the pagination in a disabled/enabled state */
    disabled?: boolean;
    /** Total number of pages */
    total: number;
    /** Number of siblings when in the middle of the range */
    sibling?: number;
}
declare const Pagination: react__default.ForwardRefExoticComponent<Pick<PaginationProps, "prefix" | "color" | "translate" | "hidden" | "dir" | "slot" | "style" | "title" | "disabled" | "aria-hidden" | "value" | "defaultValue" | "onChange" | "key" | "defaultChecked" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "draggable" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "children" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancel" | "onTouchCancelCapture" | "onTouchEnd" | "onTouchEndCapture" | "onTouchMove" | "onTouchMoveCapture" | "onTouchStart" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "total" | "sibling"> & react__default.RefAttributes<HTMLDivElement>>;

interface PhoneNumberPickerProps extends BaseFormInputProps<string | null> {
    /** Placeholder to show when there is no value */
    placeholder: string;
    /** country */
    country: CountryCode;
    /** Format allows developer to choose which formatting style (i.e. international, national, etc) */
    format: NumberFormat;
    /** Props to pass to the input */
    inputProps?: react__default.InputHTMLAttributes<HTMLInputElement>;
}
declare const _PhoneNumberPicker: (props: PhoneNumberPickerProps, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const PhoneNumberPicker: (props: PhoneNumberPickerProps & {
    ref?: ForwardedRef<HTMLDivElement>;
}) => ReturnType<typeof _PhoneNumberPicker>;

interface PillProps extends ComponentPropsWithRef<'div'> {
    /** Rendered color of the Pill */
    color?: 'primary' | 'success' | 'error' | 'warning' | 'grey';
    /** Toggle to show the close icon */
    closeable?: boolean;
    /** Callback triggered on close */
    onClose?: (event: React.MouseEvent) => void;
    /** Props to pass to the close */
    closeProps?: Omit<IconButtonProps, 'size'>;
}
declare const _Pill: (props: PillProps, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Pill: (props: PillProps & {
    ref?: ForwardedRef<HTMLDivElement>;
}) => ReturnType<typeof _Pill>;

interface PopoverProps {
    /** Popover Trigger and Content */
    children: ReactNode;
    /** Boolean to control the state of the popover */
    open?: boolean;
    /** Callback that is triggered when the popover is opened */
    onOpen?: () => void;
    /** Callback that is triggered when the popover is closed */
    onClose?: () => void;
}

interface PopoverTriggerProps {
    /** Content to act as the popover trigger */
    children: ReactNode;
}

interface PopoverContentProps extends ComponentPropsWithRef<'div'> {
    /** Content to display in the popover */
    children: ReactNode;
    /** Side where the content is position (relative to the trigger)  */
    side?: 'top' | 'right' | 'bottom' | 'left';
    /** Pixel distance the popover is away from the side  */
    offset?: number;
    /** Alignment of the content (relative to the trigger)  */
    align?: 'start' | 'center' | 'end';
    /** Container to append the popover to */
    container?: HTMLElement | null;
}

declare const PopoverNameSpace: ((props: PopoverProps) => JSX.Element) & {
    Trigger: (props: PopoverTriggerProps & {
        ref?: react.ForwardedRef<HTMLButtonElement> | undefined;
    }) => JSX.Element;
    Content: (props: PopoverContentProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
};

interface RadioProps extends InputOptions<string>, Omit<react__default.ComponentPropsWithRef<'div'>, 'value' | 'defaultValue' | 'defaultChecked' | 'onChange' | 'dir'> {
    /** Orientation of the component */
    orientation?: 'horizontal' | 'vertical';
}

interface RadioItemProps extends Omit<InputOptions<string>, 'onChange'>, Omit<react__default.ComponentPropsWithRef<'label'>, 'value' | 'defaultValue' | 'defaultChecked' | 'onChange'> {
}

declare const RadioNameSpace: react.ForwardRefExoticComponent<Pick<RadioProps, "prefix" | "color" | "translate" | "hidden" | "slot" | "style" | "title" | "disabled" | "aria-hidden" | "value" | "defaultValue" | "onChange" | "key" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "draggable" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "children" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancel" | "onTouchCancelCapture" | "onTouchEnd" | "onTouchEndCapture" | "onTouchMove" | "onTouchMoveCapture" | "onTouchStart" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "valid" | "orientation"> & react.RefAttributes<HTMLDivElement>> & {
    Item: react.ForwardRefExoticComponent<Pick<RadioItemProps, "prefix" | "color" | "translate" | "hidden" | "dir" | "form" | "slot" | "style" | "title" | "disabled" | "aria-hidden" | "value" | "defaultValue" | "key" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "draggable" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "children" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancel" | "onTouchCancelCapture" | "onTouchEnd" | "onTouchEndCapture" | "onTouchMove" | "onTouchMoveCapture" | "onTouchStart" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "valid" | "htmlFor"> & react.RefAttributes<HTMLLabelElement>>;
};

interface ScrollProps extends Omit<ComponentPropsWithRef<'div'>, 'dir' | 'onScroll'> {
    /** Type of the scroll */
    type?: 'hover' | 'auto' | 'always' | 'scroll';
    /** Allow horizontal scrolling */
    horizontal?: boolean;
    /** Allow vertical scrolling */
    vertical?: boolean;
    /** Callback that is triggered when the area is scrolle */
    onScroll?: (event: React.UIEvent<HTMLDivElement>) => void;
}
/**
 * Scroll component
 */
declare const _Scroll: (props: ScrollProps, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Scroll: (props: ScrollProps & {
    ref?: ForwardedRef<HTMLDivElement>;
}) => ReturnType<typeof _Scroll>;

interface BaseSelectProps<O, V> extends BaseFormInputProps<V> {
    /** Options to render in the list of the Select */
    options: O[];
    /** Placeholder to show when there is no value */
    placeholder?: string;
    /** Props to pass to the input */
    inputProps?: react__default.InputHTMLAttributes<HTMLInputElement>;
    /** allows for selection of multiple values */
    multiple?: boolean;
    /** Search term */
    search?: string;
    /** Filter the options on search */
    filter?: boolean;
    /** Callback that is triggered when search is updated */
    onSearch?: (value: string) => void;
    /** Callback that is triggered when the end of the list is reached */
    onLoad?: () => void;
    /** Callback that is triggered on search. This returns true if the option should be included. */
    getSearch?: (search: string, option: O) => boolean;
    /** Callback that is triggered to get the unique key of an option */
    getKey?: (option: O) => string;
    /** Callback that is triggered to get the display of an option */
    getDisplay?: (option: O) => ReactNode;
    /** Container to append the list to */
    container?: HTMLElement | null;
}
declare type SingleSelect<O> = BaseSelectProps<O, O | null>;
declare type MultipleSelect<O> = BaseSelectProps<O, O[]>;
declare type SelectProps<O, multiple extends boolean> = multiple extends true ? MultipleSelect<O> : SingleSelect<O>;
declare const _Select: <O, multiple extends boolean>(props: SelectProps<O, multiple>, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Select: <O, multiple extends boolean>(props: SelectProps<O, multiple> & {
    ref?: react__default.ForwardedRef<HTMLDivElement> | undefined;
}) => ReturnType<typeof _Select>;

interface StepperProps extends Omit<react__default.ComponentPropsWithRef<'ul'>, 'value' | 'defaultValue' | 'onChange'> {
    /** Value of the stepper */
    value?: string;
    /** Default Value of the stepper */
    defaultValue?: string;
    /** Callback that is triggered when the step changes */
    onChange?: (value: string) => void;
    /** Can the steps be interacted with */
    interactive?: boolean;
    /** Layout of the steps */
    layout?: 'horizontal' | 'vertical';
}

interface StepperStepProps extends Omit<react__default.ComponentPropsWithRef<'li'>, 'value' | 'defaultValue' | 'onChange'> {
    /** value of the step */
    value: string;
    /** Mark the step in a disabled/enabled state */
    disabled?: boolean;
    /** Mark the step in a valid/invalid state */
    valid?: boolean;
}

declare const StepperNameSpace: react.ForwardRefExoticComponent<Pick<StepperProps, "prefix" | "color" | "translate" | "hidden" | "dir" | "slot" | "style" | "title" | "aria-hidden" | "value" | "defaultValue" | "onChange" | "key" | "defaultChecked" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "draggable" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "children" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancel" | "onTouchCancelCapture" | "onTouchEnd" | "onTouchEndCapture" | "onTouchMove" | "onTouchMoveCapture" | "onTouchStart" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "layout" | "interactive"> & react.RefAttributes<HTMLUListElement>> & {
    Step: react.ForwardRefExoticComponent<Pick<StepperStepProps, "prefix" | "color" | "translate" | "hidden" | "dir" | "slot" | "style" | "title" | "disabled" | "aria-hidden" | "value" | "key" | "defaultChecked" | "suppressContentEditableWarning" | "suppressHydrationWarning" | "accessKey" | "className" | "contentEditable" | "contextMenu" | "draggable" | "id" | "lang" | "placeholder" | "spellCheck" | "tabIndex" | "radioGroup" | "role" | "about" | "datatype" | "inlist" | "property" | "resource" | "typeof" | "vocab" | "autoCapitalize" | "autoCorrect" | "autoSave" | "itemProp" | "itemScope" | "itemType" | "itemID" | "itemRef" | "results" | "security" | "unselectable" | "inputMode" | "is" | "aria-activedescendant" | "aria-atomic" | "aria-autocomplete" | "aria-busy" | "aria-checked" | "aria-colcount" | "aria-colindex" | "aria-colspan" | "aria-controls" | "aria-current" | "aria-describedby" | "aria-details" | "aria-disabled" | "aria-dropeffect" | "aria-errormessage" | "aria-expanded" | "aria-flowto" | "aria-grabbed" | "aria-haspopup" | "aria-invalid" | "aria-keyshortcuts" | "aria-label" | "aria-labelledby" | "aria-level" | "aria-live" | "aria-modal" | "aria-multiline" | "aria-multiselectable" | "aria-orientation" | "aria-owns" | "aria-placeholder" | "aria-posinset" | "aria-pressed" | "aria-readonly" | "aria-relevant" | "aria-required" | "aria-roledescription" | "aria-rowcount" | "aria-rowindex" | "aria-rowspan" | "aria-selected" | "aria-setsize" | "aria-sort" | "aria-valuemax" | "aria-valuemin" | "aria-valuenow" | "aria-valuetext" | "children" | "dangerouslySetInnerHTML" | "onCopy" | "onCopyCapture" | "onCut" | "onCutCapture" | "onPaste" | "onPasteCapture" | "onCompositionEnd" | "onCompositionEndCapture" | "onCompositionStart" | "onCompositionStartCapture" | "onCompositionUpdate" | "onCompositionUpdateCapture" | "onFocus" | "onFocusCapture" | "onBlur" | "onBlurCapture" | "onChangeCapture" | "onBeforeInput" | "onBeforeInputCapture" | "onInput" | "onInputCapture" | "onReset" | "onResetCapture" | "onSubmit" | "onSubmitCapture" | "onInvalid" | "onInvalidCapture" | "onLoad" | "onLoadCapture" | "onError" | "onErrorCapture" | "onKeyDown" | "onKeyDownCapture" | "onKeyPress" | "onKeyPressCapture" | "onKeyUp" | "onKeyUpCapture" | "onAbort" | "onAbortCapture" | "onCanPlay" | "onCanPlayCapture" | "onCanPlayThrough" | "onCanPlayThroughCapture" | "onDurationChange" | "onDurationChangeCapture" | "onEmptied" | "onEmptiedCapture" | "onEncrypted" | "onEncryptedCapture" | "onEnded" | "onEndedCapture" | "onLoadedData" | "onLoadedDataCapture" | "onLoadedMetadata" | "onLoadedMetadataCapture" | "onLoadStart" | "onLoadStartCapture" | "onPause" | "onPauseCapture" | "onPlay" | "onPlayCapture" | "onPlaying" | "onPlayingCapture" | "onProgress" | "onProgressCapture" | "onRateChange" | "onRateChangeCapture" | "onSeeked" | "onSeekedCapture" | "onSeeking" | "onSeekingCapture" | "onStalled" | "onStalledCapture" | "onSuspend" | "onSuspendCapture" | "onTimeUpdate" | "onTimeUpdateCapture" | "onVolumeChange" | "onVolumeChangeCapture" | "onWaiting" | "onWaitingCapture" | "onAuxClick" | "onAuxClickCapture" | "onClick" | "onClickCapture" | "onContextMenu" | "onContextMenuCapture" | "onDoubleClick" | "onDoubleClickCapture" | "onDrag" | "onDragCapture" | "onDragEnd" | "onDragEndCapture" | "onDragEnter" | "onDragEnterCapture" | "onDragExit" | "onDragExitCapture" | "onDragLeave" | "onDragLeaveCapture" | "onDragOver" | "onDragOverCapture" | "onDragStart" | "onDragStartCapture" | "onDrop" | "onDropCapture" | "onMouseDown" | "onMouseDownCapture" | "onMouseEnter" | "onMouseLeave" | "onMouseMove" | "onMouseMoveCapture" | "onMouseOut" | "onMouseOutCapture" | "onMouseOver" | "onMouseOverCapture" | "onMouseUp" | "onMouseUpCapture" | "onSelect" | "onSelectCapture" | "onTouchCancel" | "onTouchCancelCapture" | "onTouchEnd" | "onTouchEndCapture" | "onTouchMove" | "onTouchMoveCapture" | "onTouchStart" | "onTouchStartCapture" | "onPointerDown" | "onPointerDownCapture" | "onPointerMove" | "onPointerMoveCapture" | "onPointerUp" | "onPointerUpCapture" | "onPointerCancel" | "onPointerCancelCapture" | "onPointerEnter" | "onPointerEnterCapture" | "onPointerLeave" | "onPointerLeaveCapture" | "onPointerOver" | "onPointerOverCapture" | "onPointerOut" | "onPointerOutCapture" | "onGotPointerCapture" | "onGotPointerCaptureCapture" | "onLostPointerCapture" | "onLostPointerCaptureCapture" | "onScroll" | "onScrollCapture" | "onWheel" | "onWheelCapture" | "onAnimationStart" | "onAnimationStartCapture" | "onAnimationEnd" | "onAnimationEndCapture" | "onAnimationIteration" | "onAnimationIterationCapture" | "onTransitionEnd" | "onTransitionEndCapture" | "valid"> & react.RefAttributes<HTMLLIElement>>;
};

declare type TableValue = {
    /** Make the head fixed as a user scrolls */
    sticky: boolean;
    /** Highlight rows on hover */
    highlight: boolean;
    /** Add strips to the rows */
    striped: boolean;
    /** Value to determine table cell */
    cellType: 'head' | 'body' | null;
};

interface TableProps extends ComponentPropsWithRef<'table'> {
    /** Show the border **/
    border?: boolean;
    /** Layout the table */
    layout?: StitchesCSS['tableLayout'];
    /** Make the head fixed as a user scrolls */
    sticky?: TableValue['sticky'];
    /** Highlight rows on hover */
    highlight?: TableValue['highlight'];
    /** Add strips to the rows */
    striped?: TableValue['striped'];
}

declare type TableBodyProps = ComponentPropsWithRef<'tbody'>;

interface BaseTableCell {
    /** Vertical Alignment of the cell */
    verticalAlign?: StitchesCSS['verticalAlign'];
    /** Width of the cell */
    width?: StitchesCSS['width'];
}
declare type HeaderTableCell = BaseTableCell & ComponentPropsWithRef<'th'>;
declare type DataTableCell = BaseTableCell & ComponentPropsWithRef<'td'>;
declare type TableCellProps<H extends boolean> = H extends true ? HeaderTableCell : DataTableCell;

declare type TableHeadProps = ComponentPropsWithRef<'thead'>;

declare type TableRowProps = ComponentPropsWithRef<'tr'>;

declare const TableNameSpace: ((props: TableProps & {
    ref?: react.ForwardedRef<HTMLTableElement> | undefined;
}) => JSX.Element) & {
    Body: (props: Pick<react.DetailedHTMLProps<react.HTMLAttributes<HTMLTableSectionElement>, HTMLTableSectionElement>, "key" | keyof react.HTMLAttributes<HTMLTableSectionElement>> & {
        ref?: ((instance: HTMLTableSectionElement | null) => void) | react.RefObject<HTMLTableSectionElement> | null | undefined;
    } & {
        ref?: react.ForwardedRef<HTMLTableSectionElement> | undefined;
    }) => JSX.Element;
    Cell: <H extends boolean>(props: TableCellProps<H> & {
        ref?: react.ForwardedRef<HTMLTableCellElement> | undefined;
    }) => JSX.Element;
    Head: (props: Pick<react.DetailedHTMLProps<react.HTMLAttributes<HTMLTableSectionElement>, HTMLTableSectionElement>, "key" | keyof react.HTMLAttributes<HTMLTableSectionElement>> & {
        ref?: ((instance: HTMLTableSectionElement | null) => void) | react.RefObject<HTMLTableSectionElement> | null | undefined;
    } & {
        ref?: react.ForwardedRef<HTMLTableSectionElement> | undefined;
    }) => JSX.Element;
    Row: (props: Pick<react.DetailedHTMLProps<react.HTMLAttributes<HTMLTableRowElement>, HTMLTableRowElement>, "key" | keyof react.HTMLAttributes<HTMLTableRowElement>> & {
        ref?: ((instance: HTMLTableRowElement | null) => void) | react.RefObject<HTMLTableRowElement> | null | undefined;
    } & {
        ref?: react.ForwardedRef<HTMLTableRowElement> | undefined;
    }) => JSX.Element;
};

interface TabsProps extends Omit<ComponentPropsWithRef<'div'>, 'onChange' | 'defaultValue' | 'dir'> {
    /** Value of the tabs */
    value: string;
    /** Callback that is triggered when the value changes */
    onChange?: (value: string) => void;
    /** Mark the tabs in a disabled/enabled state */
    disabled?: boolean;
}

interface TabsListProps extends ComponentPropsWithRef<'div'> {
    /** Allow the items to loop through the list */
    loop?: boolean;
}

interface TabsTriggerProps extends ComponentPropsWithRef<'button'> {
    /** Value of the trigger */
    value: string;
    /** Mark the input in a disabled/enabled state */
    disabled: boolean;
}

interface TabsContentProps extends ComponentPropsWithRef<'div'> {
    /** Value of the content */
    value: string;
}

declare const TabsNameSpace: ((props: TabsProps & {
    ref?: react.ForwardedRef<HTMLDivElement> | undefined;
}) => JSX.Element) & {
    List: (props: TabsListProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
    Trigger: (props: TabsTriggerProps & {
        ref?: react.ForwardedRef<HTMLButtonElement> | undefined;
    }) => JSX.Element;
    Content: (props: TabsContentProps & {
        ref?: react.ForwardedRef<HTMLDivElement> | undefined;
    }) => JSX.Element;
};

interface TextareaProps extends BaseFormInputProps<string> {
    /** Placeholder to show when there is no value */
    placeholder?: string;
    /** Specifies autocomplete on the textarea */
    autoComplete?: HTMLTextAreaElement['autocomplete'];
    /** Props to pass to the textarea */
    textareaProps?: React.InputHTMLAttributes<HTMLTextAreaElement>;
}
/**
 * Textarea component
 */
declare const _Textarea: (props: TextareaProps, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Textarea: (props: TextareaProps & {
    ref?: ForwardedRef<HTMLDivElement>;
}) => ReturnType<typeof _Textarea>;

interface ThemeProps {
    /** Content to use as the theme */
    children: ReactNode;
    /** Theme to use for the components */
    theme?: ReturnType<typeof createTheme>;
    /** Apply the reset CSS */
    reset?: boolean;
    /** Element to apply the theme to */
    root?: HTMLElement;
}
declare const Theme: (props: ThemeProps) => JSX.Element;

interface TooltipProps extends ComponentPropsWithRef<'div'> {
    /** Tooltip Trigger  */
    children: ReactNode;
    /** Content to show in the tooltip */
    content: ReactNode;
    /** Key passed to the content that will force a rerender when it changes */
    contentKey?: Key | null;
    /** Boolean to control the state of the tooltip */
    open?: boolean;
    /** Callback that is triggered when the tooltip is opened */
    onOpen?: () => void;
    /** Callback that is triggered when the tooltip is closed */
    onClose?: () => void;
    /** Side where the content is position (relative to the trigger)  */
    side?: 'top' | 'right' | 'bottom' | 'left';
    /** Pixel distance the Tooltip is away from the side  */
    offset?: number;
    /** Alignment of the content (relative to the trigger)  */
    align?: 'start' | 'center' | 'end';
    /** Container to append the tooltip to */
    container?: HTMLElement | null;
}
/**
 * Tooltip component
 */
declare const _Tooltip: (props: TooltipProps, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Tooltip: (props: TooltipProps & {
    ref?: ForwardedRef<HTMLDivElement>;
}) => ReturnType<typeof _Tooltip>;

declare type SingleTypeahead<O> = Omit<SelectProps<O, false>, 'value' | 'defaultValue' | 'onChange'> & Pick<BaseFormInputProps<string>, 'value' | 'defaultValue' | 'onChange'>;
declare type MultipleTypeahead<O> = Omit<SelectProps<O, true>, 'value' | 'defaultValue' | 'onChange'> & Pick<BaseFormInputProps<string[]>, 'value' | 'defaultValue' | 'onChange'>;
declare type TypeaheadProps<O, multiple extends boolean> = multiple extends true ? MultipleTypeahead<O> : SingleTypeahead<O>;
/**
 * Typeahead component
 */
declare const _Typeahead: <O, multiple extends boolean>(props: TypeaheadProps<O, multiple>, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Typeahead: <O, multiple extends boolean>(props: TypeaheadProps<O, multiple> & {
    ref?: ForwardedRef<HTMLDivElement> | undefined;
}) => ReturnType<typeof _Typeahead>;

interface SwitchProps extends InputOptions<boolean>, Omit<ComponentPropsWithRef<'div'>, 'value' | 'defaultValue' | 'defaultChecked' | 'onChange'> {
}
/**
 * Switch component
 */
declare const _Switch: (props: SwitchProps, ref: ForwardedRef<HTMLDivElement>) => JSX.Element;
declare const Switch: (props: SwitchProps & {
    ref?: ForwardedRef<HTMLDivElement>;
}) => ReturnType<typeof _Switch>;

export { AccordionNameSpace as Accordion, AccordionContentProps, AccordionItemProps, AccordionProps, AccordionTriggerProps, Alert, AlertProps, BreadcrumbNameSpace as Breadcrumb, BreadcrumbItemProps, BreadcrumbProps, Button, ButtonProps, Calendar, CalendarProps, Checkbox, CheckboxProps, Checklist, ChecklistProps, CurrencyPicker, CurrencyPickerProps, Datepicker, DatepickerProps, DropdownNameSpace as Dropdown, DropdownContentProps, DropdownItemProps, DropdownLabelProps, DropdownProps, DropdownSeperatorProps, DropdownSubMenuContentProps, DropdownSubMenuProps, DropdownSubMenuTriggerProps, DropdownTriggerProps, FileDropzone, FileDropzoneProps, Flex, FlexProps, FormNameSpace as Form, FormDescriptionProps, FormErrorProps, FormFieldProps, FormGroupProps, FormLabelProps, FormProps, GridNameSpace as Grid, GridItemProps, GridProps, Icon, IconButton, IconButtonProps, IconProps, Input, InputProps, Loading, LoadingProps, ModalNameSpace as Modal, ModalBodyProps, ModalCloseProps, ModalContentProps, ModalFooterProps, ModalHeaderProps, ModalProps, ModalTriggerProps, Notification, NotificationProps, Override, OverrideProps, Pagination, PaginationProps, PhoneNumberPicker, PhoneNumberPickerProps, Pill, PillProps, PopoverNameSpace as Popover, PopoverContentProps, PopoverProps, PopoverTriggerProps, RadioNameSpace as Radio, RadioItemProps, RadioProps, Scroll, ScrollProps, Select, SelectProps, StepperNameSpace as Stepper, StepperProps, StepperStepProps, StitchesCSS, Switch, SwitchProps, TableNameSpace as Table, TableBodyProps, TableCellProps, TableHeadProps, TableProps, TableRowProps, TabsNameSpace as Tabs, TabsContentProps, TabsListProps, TabsProps, TabsTriggerProps, Textarea, TextareaProps, Theme, ThemeProps, Tooltip, TooltipProps, Typeahead, TypeaheadProps, config, createNotification, createTheme, css, getCssText, globalCss, globalStyles, keyframes, styled, theme, useDebounce, useFocusTrap, useId, useIntersectionObserver, useNotification, useResizeObserver, useValue };
