/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.turtle;

import java.math.BigInteger;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.namespace.RDF;
import org.semanticweb.yars.nx.namespace.XSD;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.turtle.Prologue;
import org.semanticweb.yars.turtle.TurtleParseException;

public class TurtleParserBase {
    static final Logger _log = Logger.getLogger(TurtleParserBase.class.getName());
    int _bnodeid = 0;
    boolean strictTurtle = true;
    protected final Literal XSD_TRUE = new Literal("true", XSD.BOOLEAN);
    protected final Literal XSD_FALSE = new Literal("false", XSD.BOOLEAN);
    protected final Node nRDFtype = RDF.TYPE;
    protected final Node nRDFnil = RDF.NIL;
    protected final Node nRDFfirst = RDF.FIRST;
    protected final Node nRDFrest = RDF.REST;
    protected final Node nRDFsubject = RDF.SUBJECT;
    protected final Node nRDFpredicate = RDF.PREDICATE;
    protected final Node nRDFobject = RDF.OBJECT;
    Callback _callback;
    protected Prologue _prologue = new Prologue();

    public void setPrologue(Prologue prologue) {
        this._prologue = prologue;
    }

    public Prologue getPrologue() {
        return this._prologue;
    }

    protected Literal createLiteralInteger(String lexicalForm) {
        return new Literal(lexicalForm, XSD.INTEGER);
    }

    protected Literal createLiteralDouble(String lexicalForm) {
        return new Literal(lexicalForm, XSD.DOUBLE);
    }

    protected Literal createLiteralDecimal(String lexicalForm) {
        return new Literal(lexicalForm, XSD.DECIMAL);
    }

    protected Resource createResource(String s) {
        if (s.equals("<>")) {
            return new Resource(this._prologue.getBaseURI().toString());
        }
        URI u = URI.create(s.substring(1, s.length() - 1));
        _log.log(Level.FINE, "Creating resource {0}, absolute? {1}", new Object[]{s, u.isAbsolute()});
        if (!u.isAbsolute()) {
            _log.log(Level.FINE, "Resolving {0} relative to {1}", new Object[]{u, this._prologue.getBaseURI()});
            u = this._prologue.getBaseURI().resolve(u);
        }
        return new Resource(u.toString());
    }

    protected Node stripSign(Node node) {
        if (!(node instanceof Literal)) {
            return node;
        }
        return node;
    }

    protected long integerValue(String s) throws TurtleParseException {
        try {
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            if (s.startsWith("0x")) {
                s = s.substring(2);
                return Long.parseLong(s, 16);
            }
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            try {
                BigInteger integer = new BigInteger(s);
                throw new TurtleParseException("Number '" + s + "' is a valid number but can't not be stored in a long");
            }
            catch (NumberFormatException numberFormatException) {
                throw new TurtleParseException(ex, -1, -1);
            }
        }
    }

    protected double doubleValue(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        double valDouble = Double.parseDouble(s);
        return valDouble;
    }

    protected static String stripQuotes(String s) {
        return s.substring(1, s.length() - 1);
    }

    protected static String stripQuotes3(String s) {
        return s.substring(3, s.length() - 3);
    }

    public static String stripChars(String s, int n) {
        return s.substring(n, s.length());
    }

    protected String resolvePName(String qname, int line, int column) throws TurtleParseException {
        int idx = qname.indexOf(58);
        String prefix = qname.substring(0, idx);
        String local = qname.substring(idx + 1);
        local = TurtleParserBase.unescapePName(local, line, column);
        _log.log(Level.FINE, "Expanding prefix {0}, localname {1}", new Object[]{prefix, local});
        String s = this._prologue.expandPrefix(prefix);
        if (s == null) {
            throw new TurtleParseException("Unresolved prefix: " + qname, line, column);
        }
        return s + local;
    }

    public BNode getBNode(String id) {
        return new BNode(id);
    }

    protected void startTriplesBlock() {
    }

    protected void endTriplesBlock() {
    }

    protected Node createListNode(int line, int column) {
        return this.createBNode();
    }

    public BNode createBNode() {
        String s = this._prologue.getBaseURI().toString();
        return BNode.createBNode((String)s, (String)("b" + this._bnodeid++));
    }

    protected Node createBNode(String label, int line, int column) {
        String s = this._prologue.getBaseURI().toString();
        return BNode.createBNode((String)s, (String)label);
    }

    protected String fixupPrefix(String prefix, int line, int column) {
        if (prefix.endsWith(":")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    protected void setPrefix(int line, int column, String prefix, String uri) {
        this._prologue.setPrefix(prefix, uri);
    }

    protected void setBase(String base, int line, int column) {
        this._prologue.setBaseURI(new Resource(base.substring(1, base.length() - 1)));
    }

    protected void emitTriple(int line, int column, Nodes triple) {
        this._callback.processStatement(triple.getNodeArray());
    }

    public static String unescapeStr(String s) throws TurtleParseException {
        return TurtleParserBase.unescape(s, '\\', false, 1, 1);
    }

    public static String unescapeStr(String s, int line, int column) throws TurtleParseException {
        return TurtleParserBase.unescape(s, '\\', false, line, column);
    }

    public static String unescape(String s, char escape, boolean pointCodeOnly, int line, int column) throws TurtleParseException {
        int i = s.indexOf(escape);
        if (i == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.substring(0, i));
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    ++line;
                    column = 1;
                    break;
                }
                default: {
                    ++column;
                }
            }
            if (ch != escape) {
                sb.append(ch);
            } else {
                int x;
                if (i >= s.length() - 1) {
                    throw new TurtleParseException("Illegal escape at end of string", line, column);
                }
                char ch2 = s.charAt(i + 1);
                ++column;
                ++i;
                if (ch2 == 'u') {
                    if (i + 4 >= s.length()) {
                        throw new TurtleParseException("\\u escape too short", line, column);
                    }
                    x = TurtleParserBase.hex(s, i + 1, 4, line, column);
                    sb.append((char)x);
                    i += 4;
                    column += 4;
                } else if (ch2 == 'U') {
                    if (i + 8 >= s.length()) {
                        throw new TurtleParseException("\\U escape too short", line, column);
                    }
                    x = TurtleParserBase.hex(s, i + 1, 8, line, column);
                    sb.append((char)x);
                    i += 8;
                    column += 8;
                } else if (pointCodeOnly) {
                    sb.append('\\');
                    sb.append(ch2);
                    ++i;
                } else {
                    char ch3 = '\u0000';
                    switch (ch2) {
                        case 'n': {
                            ch3 = '\n';
                            break;
                        }
                        case 't': {
                            ch3 = '\t';
                            break;
                        }
                        case 'r': {
                            ch3 = '\r';
                            break;
                        }
                        case 'b': {
                            ch3 = '\b';
                            break;
                        }
                        case 'f': {
                            ch3 = '\f';
                            break;
                        }
                        case '\'': {
                            ch3 = '\'';
                            break;
                        }
                        case '\"': {
                            ch3 = '\"';
                            break;
                        }
                        case '\\': {
                            ch3 = '\\';
                            break;
                        }
                        default: {
                            throw new TurtleParseException("Unknown escape: \\" + ch2, line, column);
                        }
                    }
                    sb.append(ch3);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static int hex(String s, int i, int len, int line, int column) throws TurtleParseException {
        int x = 0;
        for (int j = i; j < i + len; ++j) {
            char ch = s.charAt(j);
            ++column;
            int k = 0;
            switch (ch) {
                case '0': {
                    k = 0;
                    break;
                }
                case '1': {
                    k = 1;
                    break;
                }
                case '2': {
                    k = 2;
                    break;
                }
                case '3': {
                    k = 3;
                    break;
                }
                case '4': {
                    k = 4;
                    break;
                }
                case '5': {
                    k = 5;
                    break;
                }
                case '6': {
                    k = 6;
                    break;
                }
                case '7': {
                    k = 7;
                    break;
                }
                case '8': {
                    k = 8;
                    break;
                }
                case '9': {
                    k = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    k = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    k = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    k = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    k = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    k = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    k = 15;
                    break;
                }
                default: {
                    throw new TurtleParseException("Illegal hex escape: " + ch, line, column);
                }
            }
            x = (x << 4) + k;
        }
        return x;
    }

    public static String unescapePName(String s, int line, int column) throws TurtleParseException {
        char escape = '\\';
        int idx = s.indexOf(escape);
        if (idx == -1) {
            return s;
        }
        int len = s.length();
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    ++line;
                    column = 1;
                    break;
                }
                default: {
                    ++column;
                }
            }
            if (ch != escape) {
                sb.append(ch);
                continue;
            }
            if (i >= s.length() - 1) {
                throw new TurtleParseException("Illegal escape at end of string", line, column);
            }
            char ch2 = s.charAt(i + 1);
            ++column;
            ++i;
            switch (ch2) {
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '~': {
                    sb.append(ch2);
                    continue block6;
                }
                default: {
                    throw new TurtleParseException("Illegal prefix name escape: " + ch2, line, column);
                }
            }
        }
        return sb.toString();
    }

    protected void warnDeprecation(String msg) {
        System.err.println(msg);
    }
}

