/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.turtle;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.Resource;

public class Prologue {
    static final Logger _log = Logger.getLogger(Prologue.class.getName());
    Map<String, String> _prefixes = new HashMap<String, String>();
    URI _baseURI = null;

    public void setPrefix(String prefix, String s) {
        if ((s = s.substring(1, s.length() - 1)).length() == 0) {
            s = this._baseURI.toString();
        }
        URI u = URI.create(s);
        _log.log(Level.FINE, "Creating resource {0}, absolute? {1}", new Object[]{s, u.isAbsolute()});
        if (!u.isAbsolute()) {
            _log.log(Level.FINE, "Resolving {0} relative to {1}", new Object[]{u, this.getBaseURI()});
            u = this.getBaseURI().resolve(u);
        }
        _log.log(Level.FINE, "@prefix {0}: {1}", new Object[]{prefix, u.toString()});
        this._prefixes.put(prefix, u.toString());
    }

    public String expandPrefix(String prefix) {
        return this._prefixes.get(prefix);
    }

    public URI getBaseURI() {
        return this._baseURI;
    }

    public void setBaseURI(Resource base) {
        this.setBase(URI.create(base.getLabel()));
    }

    public void setBase(URI base) {
        if (this._baseURI == null) {
            this._baseURI = base;
            if (!this._baseURI.isAbsolute()) {
                throw new IllegalArgumentException("Document URI " + base + " needs to be absolute!");
            }
        } else {
            this._baseURI = this._baseURI.resolve(base);
        }
    }
}

