/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.rdfxml;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Nodes;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.namespace.RDF;
import org.semanticweb.yars.nx.parser.Callback;
import org.semanticweb.yars.nx.parser.ParseException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RdfXmlParserBase
extends DefaultHandler {
    private static Logger _log = Logger.getLogger(RdfXmlParserBase.class.getName());
    private boolean _skolemise = false;
    private boolean _strict = false;
    private String _escapedDocURI = null;
    public static final String BNODE_PREFIX = "bnode";
    private static final String XML_BASE = "xml:base";
    private static final String XML_LANG = "xml:lang";
    private static final String XML_SPACE = "xml:space";
    private static final String XML_ID = "xml:id";
    private static final String XML_PREFIX = "xml:";
    private static final String NULL = "";
    private ArrayList<Node> _fifoS;
    private ScopedThing<URI> _sbq;
    private ScopedThing<String> _slang;
    private TreeSet<Integer> _sptr;
    private Resource _sptlp = null;
    private int _sptldepth = 0;
    private HashMap<Integer, Integer> _li;
    private HashMap<Integer, Node> _coll;
    private HashMap<String, HashSet<URI>> _ids;
    private URI _currentBase;
    private int _currentLi = 0;
    private Node _currentColl = null;
    private Node _currentReify = null;
    private int _depth = 0;
    private int _bnode = 0;
    private String _currentLang = null;
    private Resource _datatype = null;
    private HashMap<String, String> _xmllPrefixes = null;
    private StringBuffer _prefixDefinition = null;
    private Resource _con = null;
    private State _state = State.START;
    private ResourceDescription _currentPRD = null;
    private Node _currentS = null;
    private Resource _currentP = null;
    private Locator _loc = null;
    private StringBuffer _currentL = null;
    private Callback _c;
    private static final Node[] NOT_ALLOWED_NODE = new Node[]{RDF.ABOUT, RDF.DATATYPE, RDF.ID, RDF.NODEID, RDF.PARSETYPE, RDF.RESOURCE};
    private static final HashSet<Node> NOT_ALLOWED_NODE_TS = new HashSet();
    private static final String[] RDF_SUBJ_NODE_NAMES = new String[]{"Description", "Bag", "Seq", "Alt", "List", "Statement", "Property"};
    private static final String[] RDF_PROP_NODE_NAMES = new String[]{"type", "subject", "predicate", "object", "first", "rest", "value", "li"};
    private static final String[] RDF_SUBJ_ATTR_NAMES = new String[]{"about", "ID", "nodeID", "type"};
    private static final String[] RDF_PROP_ATTR_NAMES = new String[]{"ID", "nodeID", "datatype", "parseType", "resource"};
    private static final HashSet<String> RDF_SUBJ_NODE_NAMES_TS = new HashSet();
    private static final HashSet<String> RDF_PROP_NODE_NAMES_TS = new HashSet();
    private static final HashSet<String> RDF_SUBJ_ATTR_NAMES_TS = new HashSet();
    private static final HashSet<String> RDF_PROP_ATTR_NAMES_TS = new HashSet();

    public RdfXmlParserBase(String docURI, Callback c) throws SAXException {
        this(docURI, c, true, null);
    }

    public RdfXmlParserBase(String docURI, Callback c, boolean skolemise) throws SAXException {
        this(docURI, c, skolemise, null);
    }

    public RdfXmlParserBase(String docURI, Callback c, boolean skolemise, boolean strict) throws SAXException {
        this(docURI, c, skolemise, strict, null);
    }

    public RdfXmlParserBase(String docURI, Callback c, boolean skolemise, Resource con) throws SAXException {
        this(docURI, c, skolemise, false, con);
    }

    public RdfXmlParserBase(String docURI, Callback c, boolean skolemise, boolean strict, Resource con) throws SAXException {
        for (Node node : NOT_ALLOWED_NODE) {
            NOT_ALLOWED_NODE_TS.add(node);
        }
        for (String string : RDF_SUBJ_NODE_NAMES) {
            RDF_SUBJ_NODE_NAMES_TS.add(string);
        }
        for (String string : RDF_PROP_NODE_NAMES) {
            RDF_PROP_NODE_NAMES_TS.add(string);
        }
        for (String string : RDF_SUBJ_ATTR_NAMES) {
            RDF_SUBJ_ATTR_NAMES_TS.add(string);
        }
        for (String string : RDF_PROP_ATTR_NAMES) {
            RDF_PROP_ATTR_NAMES_TS.add(string);
        }
        this._fifoS = new ArrayList();
        this.initialiseBaseURI(docURI);
        this.setDocumentURI(docURI);
        this._sbq = new ScopedThing<URI>(this._currentBase);
        this._sptr = new TreeSet();
        this._slang = new ScopedThing<String>(NULL);
        this._li = new HashMap();
        this._coll = new HashMap();
        this._ids = new HashMap();
        this._skolemise = skolemise;
        this._c = c;
        this._con = con;
        this._strict = strict;
    }

    private void setDocumentURI(String docURI) {
        this._escapedDocURI = BNode.escapeForBNode((String)docURI);
    }

    @Override
    public void startDocument() throws SAXException {
        this._c.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        this._c.endDocument();
    }

    @Override
    public void startElement(String name, String lname, String qname, Attributes attrs) throws SAXException {
        Resource uri;
        if (name == null || name.equals(NULL) && !this._state.equals(State.PTL_XML)) {
            if (lname.equals("RDF") && this._state.equals(State.START)) {
                this.warning("Unqualified use of 'rdf:RDF' is deprecated.");
                uri = RDF.RDF;
            } else if (RDF_SUBJ_NODE_NAMES_TS.contains(lname) && this._state.expectOpenResource()) {
                this.warning("Unqualified use of RDF name '" + lname + "' is deprecated.");
                uri = RdfXmlParserBase.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + lname);
            } else if (RDF_PROP_NODE_NAMES_TS.contains(lname) && this._state.expectOpenProperty()) {
                this.warning("Unqualified use of RDF name '" + lname + "' is deprecated.");
                uri = RdfXmlParserBase.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + lname);
            } else {
                this.error("Unqualified attribute name '" + lname + "' found.");
                uri = RdfXmlParserBase.createResource(this.resolveFullURI(lname, false));
            }
        } else {
            uri = RdfXmlParserBase.createResource(name + lname);
        }
        this.nodeIsAllowed(qname, uri);
        if (this._state.equals(State.START)) {
            this.checkAndHandleLang(attrs);
            this.checkAndHandleBaseURI(attrs);
            this._state = State.OR;
            if (!uri.equals((Object)RDF.RDF)) {
                this.initialiseCurrentResource(uri, attrs);
                this._state = State.CR_OP;
            }
        } else if (this._state.equals(State.OR)) {
            this.initialiseCurrentResource(uri, attrs);
            this._state = State.CR_OP;
        } else if (this._state.equals(State.CR_OP)) {
            this._state = State.T_CP_OR;
            this.initialiseCurrentProperty(uri, attrs);
        } else if (this._state.equals(State.T_CP_OR)) {
            this._currentL = null;
            Node old = this._currentS;
            this.initialiseCurrentResource(uri, attrs);
            this.handleStatement(new Node[]{old, this._currentP, this._currentS});
            this._state = State.CR_OP;
        } else if (this._state.equals(State.CP)) {
            this.fatalError("Expecting close property tag, not open element tag '" + qname + "'.");
        } else if (this._state.equals(State.T_CP)) {
            this.fatalError("Expecting close property, not open element tag '" + qname + "'.");
        } else if (this._state.equals(State.PTC_OR_CP)) {
            BNode collID = this.generateBNode();
            if (this._currentColl == null) {
                this.handleStatement(new Node[]{this._currentS, this._currentP, collID});
                this._fifoS.add(this._currentS);
            } else {
                this.handleStatement(new Node[]{this._currentColl, RDF.REST, collID});
            }
            this.initialiseCurrentResource(uri, attrs);
            this.handleStatement(new Node[]{collID, RDF.FIRST, this._currentS});
            this._currentColl = null;
            this._coll.put(this._depth, (Node)collID);
            this._state = State.CR_OP;
        } else if (this._state.equals(State.PTL_XML)) {
            if (uri.equals((Object)this._sptlp)) {
                ++this._sptldepth;
            }
            this.handleParseTypeLiteralStartElement(name, lname, qname, attrs);
        } else if (this._state.equals(State.PTR_OP_CP)) {
            Node old = this._currentS;
            this._currentS = this.generateBNode();
            this._fifoS.add(this._currentS);
            this.handleStatement(new Node[]{old, this._currentP, this._currentS});
            this._state = State.T_CP_OR;
            this.initialiseCurrentProperty(uri, attrs);
        }
        this._sbq.incrementScope();
        this._slang.incrementScope();
    }

    private void handleParseTypeLiteralStartElement(String name, String lname, String qname, Attributes attrs) {
        this.checkXMLLiteralPrefix(name, lname, qname);
        this._currentL.append("<" + qname);
        for (int i = 0; i < attrs.getLength(); ++i) {
            this._currentL.append(" " + attrs.getQName(i) + "=\"" + attrs.getValue(i) + "\"");
            this.checkXMLLiteralPrefix(attrs.getURI(i), attrs.getQName(i), attrs.getLocalName(i));
        }
        if (this._prefixDefinition != null) {
            this._currentL.append(this._prefixDefinition.toString());
            this._prefixDefinition = null;
        }
        this._currentL.append(">");
    }

    private void checkAndHandleBaseURI(Attributes attrs) throws SAXException {
        int b = attrs.getIndex(XML_BASE);
        if (b == -1) {
            return;
        }
        this.initialiseBaseURI(attrs.getValue(b));
        this._sbq.addNewScopedElement(this._currentBase);
    }

    private void checkAndHandleLang(Attributes attrs) throws SAXException {
        int b = attrs.getIndex(XML_LANG);
        if (b == -1) {
            return;
        }
        this.initialiseLang(attrs.getValue(b));
        if (this._currentLang == null) {
            this._slang.addNewScopedElement(NULL);
        } else {
            this._slang.addNewScopedElement(this._currentLang);
        }
    }

    private void initialiseLang(String lang) throws SAXException {
        this._currentLang = lang.isEmpty() ? null : lang.toLowerCase(Locale.ENGLISH);
    }

    private void initialiseBaseURI(String base) throws SAXException {
        if (base.contains(" ")) {
            this.warning("Base uri '" + base + "' contains a space.");
            base = base.replaceAll(" ", "+");
        }
        try {
            this._currentBase = new URI(base);
        }
        catch (URISyntaxException e) {
            this.fatalError(new SAXException(e));
        }
        if (!this._currentBase.isAbsolute()) {
            this.fatalError(new SAXException((Exception)((Object)new RDFXMLParseException("Cannot have relative xml:base value: '" + base + "'."))));
        }
    }

    private void initialiseCurrentResource(Resource rq, Attributes attrs) throws SAXException {
        this._currentLi = 0;
        this._currentS = null;
        ResourceDescription temp = new ResourceDescription();
        if (!rq.equals((Object)RDF.DESCRIPTION)) {
            temp.addEdge(new Node[]{RDF.TYPE, rq});
        }
        this.checkAndHandleBaseURI(attrs);
        this.checkAndHandleLang(attrs);
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node[] edge = this.handleSubjectAttributePair(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
            if (edge == null) continue;
            temp.addEdge(edge);
        }
        if (this._currentS == null) {
            this._currentS = this.generateBNode();
        }
        this._fifoS.add(this._currentS);
        for (Node[] edge : temp.getEdges()) {
            this.handleStatement(this._currentS, edge[0], edge[1]);
        }
    }

    private Node[] handleSubjectAttributePair(String name, String lname, String qname, String o) throws SAXException {
        Resource p;
        if (name == null || name.equals(NULL)) {
            if (RDF_SUBJ_ATTR_NAMES_TS.contains(lname)) {
                this.warning("Unqualified use of RDF name '" + lname + "' is deprecated.");
                p = RdfXmlParserBase.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + lname);
            } else {
                this.error("Unqualified attribute name '" + lname + "' found.");
                p = RdfXmlParserBase.createResource(this.resolveFullURI(lname, false));
            }
        } else {
            p = RdfXmlParserBase.createResource(name + lname);
        }
        if (p.equals((Object)RDF.ABOUT)) {
            if (this._currentS != null) {
                this.fatalError("rdf:about used for resource already identified as '" + this._currentS + "'.");
            }
            this._currentS = RdfXmlParserBase.createResource(this.resolveFullURI(o, false));
            return null;
        }
        if (p.equals((Object)RDF.ID)) {
            if (this._currentS != null) {
                this.fatalError("rdf:ID used for resource already identified as '" + this._currentS + "'.");
            }
            this._currentS = RdfXmlParserBase.createResource(this.resolveFullURI(o, true));
            return null;
        }
        if (p.equals((Object)RDF.NODEID)) {
            if (this._currentS != null) {
                this.fatalError("rdf:nodeID used for resource already identified as '" + this._currentS + "'.");
            }
            this._currentS = this.generateBNode(o);
            return null;
        }
        if (p.equals((Object)RDF.TYPE)) {
            return new Node[]{RDF.TYPE, RdfXmlParserBase.createResource(o)};
        }
        if (qname.equals(XML_BASE)) {
            return null;
        }
        if (qname.equals(XML_LANG)) {
            return null;
        }
        return new Node[]{p, this.createLiteral(o)};
    }

    private String resolveFullURI(String id, boolean rdfID) throws SAXException {
        URI uri = null;
        int oldLength = id.length();
        if (oldLength != (id = id.trim()).length()) {
            this.warning("Leading or trailing whitespace in id " + id + ".");
        }
        if (id.contains(" ")) {
            this.warning("ID " + id + " contains a space.");
            id = id.replaceAll(" ", "+");
        }
        try {
            uri = rdfID ? new URI("#" + id) : new URI(id);
        }
        catch (URISyntaxException e) {
            this.fatalError(new SAXException(e));
        }
        if (uri.isAbsolute()) {
            if (rdfID) {
                this.error("Absolute URI provided for rdf:ID. Not resolving against base URI.");
            }
            return id;
        }
        if (id.isEmpty()) {
            if (this._currentBase.getFragment() != null) {
                return this.removeFragment(this._currentBase);
            }
            return this._currentBase.toString();
        }
        if (!(this._currentBase.getPath() != null && this._currentBase.getPath().length() != 0 || this._currentBase.toString().endsWith("/"))) {
            try {
                return new URL(this._currentBase.toURL(), id).toString();
            }
            catch (MalformedURLException e) {
                this.error("MalformedURLException resolving base:" + this._currentBase + " id: " + id);
            }
        }
        URI full = this._currentBase.resolve(uri);
        if (rdfID) {
            if (this.trackDuplicateIds(id, full)) {
                this.warning("Duplicate value '" + id + "' for rdf:ID attribute.");
            }
            if (!Pattern.matches("(?:(?:_|(?:(?:[a-zA-Z]|\\xC3[\\x80-\\x96\\x98-\\xB6\\xB8-\\xBF]|\\xC4[\\x80-\\xB1\\xB4-\\xBE]|\\xC5[\\x81-\\x88\\x8A-\\xBE]|\\xC6[\\x80-\\xBF]|\\xC7[\\x80-\\x83\\x8D-\\xB0\\xB4\\xB5\\xBA-\\xBF]|\\xC8[\\x80-\\x97]|\\xC9[\\x90-\\xBF]|\\xCA[\\x80-\\xA8\\xBB-\\xBF]|\\xCB[\\x80\\x81]|\\xCE[\\x86\\x88-\\x8A\\x8C\\x8E-\\xA1\\xA3-\\xBF]|\\xCF[\\x80-\\x8E\\x90-\\x96\\x9A\\x9C\\x9E\\xA0\\xA2-\\xB3]|\\xD0[\\x81-\\x8C\\x8E-\\xBF]|\\xD1[\\x80-\\x8F\\x91-\\x9C\\x9E-\\xBF]|\\xD2[\\x80\\x81\\x90-\\xBF]|\\xD3[\\x80-\\x84\\x87\\x88\\x8B\\x8C\\x90-\\xAB\\xAE-\\xB5\\xB8\\xB9]|\\xD4[\\xB1-\\xBF]|\\xD5[\\x80-\\x96\\x99\\xA1-\\xBF]|\\xD6[\\x80-\\x86]|\\xD7[\\x90-\\xAA\\xB0-\\xB2]|\\xD8[\\xA1-\\xBA]|\\xD9[\\x81-\\x8A\\xB1-\\xBF]|\\xDA[\\x80-\\xB7\\xBA-\\xBE]|\\xDB[\\x80-\\x8E\\x90-\\x93\\x95\\xA5\\xA6]|\\xE0(?:\\xA4[\\x85-\\xB9\\xBD]|\\xA5[\\x98-\\xA1]|\\xA6[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB6-\\xB9]|\\xA7[\\x9C\\x9D\\x9F-\\xA1\\xB0\\xB1]|\\xA8[\\x85-\\x8A\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5\\xB6\\xB8\\xB9]|\\xA9[\\x99-\\x9C\\x9E\\xB2-\\xB4]|\\xAA[\\x85-\\x8B\\x8D\\x8F-\\x91\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5-\\xB9\\xBD]|\\xAB\\xA0|\\xAC[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB6-\\xB9\\xBD]|\\xAD[\\x9C\\x9D\\x9F-\\xA1]|\\xAE[\\x85-\\x8A\\x8E-\\x90\\x92-\\x95\\x99\\x9A\\x9C\\x9E\\x9F\\xA3\\xA4\\xA8-\\xAA\\xAE-\\xB5\\xB7-\\xB9]|\\xB0[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB1[\\xA0\\xA1]|\\xB2[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB3[\\x9E\\xA0\\xA1]|\\xB4[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB9]|\\xB5[\\xA0\\xA1]|\\xB8[\\x81-\\xAE\\xB0\\xB2\\xB3]|\\xB9[\\x80-\\x85]|\\xBA[\\x81\\x82\\x84\\x87\\x88\\x8A\\x8D\\x94-\\x97\\x99-\\x9F\\xA1-\\xA3\\xA5\\xA7\\xAA\\xAB\\xAD\\xAE\\xB0\\xB2\\xB3\\xBD]|\\xBB[\\x80-\\x84]|\\xBD[\\x80-\\x87\\x89-\\xA9])|\\xE1(?:\\x82[\\xA0-\\xBF]|\\x83[\\x80-\\x85\\x90-\\xB6]|\\x84[\\x80\\x82\\x83\\x85-\\x87\\x89\\x8B\\x8C\\x8E-\\x92\\xBC\\xBE]|\\x85[\\x80\\x8C\\x8E\\x90\\x94\\x95\\x99\\x9F-\\xA1\\xA3\\xA5\\xA7\\xA9\\xAD\\xAE\\xB2\\xB3\\xB5]|\\x86[\\x9E\\xA8\\xAB\\xAE\\xAF\\xB7\\xB8\\xBA\\xBC-\\xBF]|\\x87[\\x80-\\x82\\xAB\\xB0\\xB9]|[\\xB8\\xB9][\\x80-\\xBF]|\\xBA[\\x80-\\x9B\\xA0-\\xBF]|\\xBB[\\x80-\\xB9]|\\xBC[\\x80-\\x95\\x98-\\x9D\\xA0-\\xBF]|\\xBD[\\x80-\\x85\\x88-\\x8D\\x90-\\x97\\x99\\x9B\\x9D\\x9F-\\xBD]|\\xBE[\\x80-\\xB4\\xB6-\\xBC\\xBE]|\\xBF[\\x82-\\x84\\x86-\\x8C\\x90-\\x93\\x96-\\x9B\\xA0-\\xAC\\xB2-\\xB4\\xB6-\\xBC])|\\xE2(?:\\x84[\\xA6\\xAA\\xAB\\xAE]|\\x86[\\x80-\\x82])|\\xE3(?:\\x81[\\x81-\\xBF]|\\x82[\\x80-\\x94\\xA1-\\xBF]|\\x83[\\x80-\\xBA]|\\x84[\\x85-\\xAC])|\\xEA(?:[\\xB0-\\xBF][\\x80-\\xBF])|\\xEB(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xEC(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xED(?:[\\x80-\\x9D][\\x80-\\xBF]|\\x9E[\\x80-\\xA3]))|(?:\\xE3\\x80[\\x87\\xA1-\\xA9]|\\xE4(?:[\\xB8-\\xBF][\\x80-\\xBF])|\\xE5(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE6(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE7(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE8(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE9(?:[\\x80-\\xBD][\\x80-\\xBF]|\\xBE[\\x80-\\xA5]))))(?:[-._]|(?:(?:[a-zA-Z]|\\xC3[\\x80-\\x96\\x98-\\xB6\\xB8-\\xBF]|\\xC4[\\x80-\\xB1\\xB4-\\xBE]|\\xC5[\\x81-\\x88\\x8A-\\xBE]|\\xC6[\\x80-\\xBF]|\\xC7[\\x80-\\x83\\x8D-\\xB0\\xB4\\xB5\\xBA-\\xBF]|\\xC8[\\x80-\\x97]|\\xC9[\\x90-\\xBF]|\\xCA[\\x80-\\xA8\\xBB-\\xBF]|\\xCB[\\x80\\x81]|\\xCE[\\x86\\x88-\\x8A\\x8C\\x8E-\\xA1\\xA3-\\xBF]|\\xCF[\\x80-\\x8E\\x90-\\x96\\x9A\\x9C\\x9E\\xA0\\xA2-\\xB3]|\\xD0[\\x81-\\x8C\\x8E-\\xBF]|\\xD1[\\x80-\\x8F\\x91-\\x9C\\x9E-\\xBF]|\\xD2[\\x80\\x81\\x90-\\xBF]|\\xD3[\\x80-\\x84\\x87\\x88\\x8B\\x8C\\x90-\\xAB\\xAE-\\xB5\\xB8\\xB9]|\\xD4[\\xB1-\\xBF]|\\xD5[\\x80-\\x96\\x99\\xA1-\\xBF]|\\xD6[\\x80-\\x86]|\\xD7[\\x90-\\xAA\\xB0-\\xB2]|\\xD8[\\xA1-\\xBA]|\\xD9[\\x81-\\x8A\\xB1-\\xBF]|\\xDA[\\x80-\\xB7\\xBA-\\xBE]|\\xDB[\\x80-\\x8E\\x90-\\x93\\x95\\xA5\\xA6]|\\xE0(?:\\xA4[\\x85-\\xB9\\xBD]|\\xA5[\\x98-\\xA1]|\\xA6[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB6-\\xB9]|\\xA7[\\x9C\\x9D\\x9F-\\xA1\\xB0\\xB1]|\\xA8[\\x85-\\x8A\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5\\xB6\\xB8\\xB9]|\\xA9[\\x99-\\x9C\\x9E\\xB2-\\xB4]|\\xAA[\\x85-\\x8B\\x8D\\x8F-\\x91\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5-\\xB9\\xBD]|\\xAB\\xA0|\\xAC[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB6-\\xB9\\xBD]|\\xAD[\\x9C\\x9D\\x9F-\\xA1]|\\xAE[\\x85-\\x8A\\x8E-\\x90\\x92-\\x95\\x99\\x9A\\x9C\\x9E\\x9F\\xA3\\xA4\\xA8-\\xAA\\xAE-\\xB5\\xB7-\\xB9]|\\xB0[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB1[\\xA0\\xA1]|\\xB2[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB3[\\x9E\\xA0\\xA1]|\\xB4[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB9]|\\xB5[\\xA0\\xA1]|\\xB8[\\x81-\\xAE\\xB0\\xB2\\xB3]|\\xB9[\\x80-\\x85]|\\xBA[\\x81\\x82\\x84\\x87\\x88\\x8A\\x8D\\x94-\\x97\\x99-\\x9F\\xA1-\\xA3\\xA5\\xA7\\xAA\\xAB\\xAD\\xAE\\xB0\\xB2\\xB3\\xBD]|\\xBB[\\x80-\\x84]|\\xBD[\\x80-\\x87\\x89-\\xA9])|\\xE1(?:\\x82[\\xA0-\\xBF]|\\x83[\\x80-\\x85\\x90-\\xB6]|\\x84[\\x80\\x82\\x83\\x85-\\x87\\x89\\x8B\\x8C\\x8E-\\x92\\xBC\\xBE]|\\x85[\\x80\\x8C\\x8E\\x90\\x94\\x95\\x99\\x9F-\\xA1\\xA3\\xA5\\xA7\\xA9\\xAD\\xAE\\xB2\\xB3\\xB5]|\\x86[\\x9E\\xA8\\xAB\\xAE\\xAF\\xB7\\xB8\\xBA\\xBC-\\xBF]|\\x87[\\x80-\\x82\\xAB\\xB0\\xB9]|[\\xB8\\xB9][\\x80-\\xBF]|\\xBA[\\x80-\\x9B\\xA0-\\xBF]|\\xBB[\\x80-\\xB9]|\\xBC[\\x80-\\x95\\x98-\\x9D\\xA0-\\xBF]|\\xBD[\\x80-\\x85\\x88-\\x8D\\x90-\\x97\\x99\\x9B\\x9D\\x9F-\\xBD]|\\xBE[\\x80-\\xB4\\xB6-\\xBC\\xBE]|\\xBF[\\x82-\\x84\\x86-\\x8C\\x90-\\x93\\x96-\\x9B\\xA0-\\xAC\\xB2-\\xB4\\xB6-\\xBC])|\\xE2(?:\\x84[\\xA6\\xAA\\xAB\\xAE]|\\x86[\\x80-\\x82])|\\xE3(?:\\x81[\\x81-\\xBF]|\\x82[\\x80-\\x94\\xA1-\\xBF]|\\x83[\\x80-\\xBA]|\\x84[\\x85-\\xAC])|\\xEA(?:[\\xB0-\\xBF][\\x80-\\xBF])|\\xEB(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xEC(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xED(?:[\\x80-\\x9D][\\x80-\\xBF]|\\x9E[\\x80-\\xA3]))|(?:\\xE3\\x80[\\x87\\xA1-\\xA9]|\\xE4(?:[\\xB8-\\xBF][\\x80-\\xBF])|\\xE5(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE6(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE7(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE8(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE9(?:[\\x80-\\xBD][\\x80-\\xBF]|\\xBE[\\x80-\\xA5])))|(?:[0-9]|\\xD9[\\xA0-\\xA9]|\\xDB[\\xB0-\\xB9]|\\xE0(?:\\xA5[\\xA6-\\xAF]|\\xA7[\\xA6-\\xAF]|\\xA9[\\xA6-\\xAF]|\\xAB[\\xA6-\\xAF]|\\xAD[\\xA6-\\xAF]|\\xAF[\\xA7-\\xAF]|\\xB1[\\xA6-\\xAF]|\\xB3[\\xA6-\\xAF]|\\xB5[\\xA6-\\xAF]|\\xB9[\\x90-\\x99]|\\xBB[\\x90-\\x99]|\\xBC[\\xA0-\\xA9]))|(?:\\xCC[\\x80-\\xBF]|\\xCD[\\x80-\\x85\\xA0\\xA1]|\\xD2[\\x83-\\x86]|\\xD6[\\x91-\\xA1\\xA3-\\xB9\\xBB-\\xBD\\xBF]|\\xD7[\\x81\\x82\\x84]|\\xD9[\\x8B-\\x92\\xB0]|\\xDB[\\x96-\\xA4\\xA7\\xA8\\xAA-\\xAD]|\\xE0(?:\\xA4[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xA5[\\x80-\\x8D\\x91-\\x94\\xA2\\xA3]|\\xA6[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xA7[\\x80-\\x84\\x87\\x88\\x8B-\\x8D\\x97\\xA2\\xA3]|\\xA8[\\x82\\xBC\\xBE\\xBF]|\\xA9[\\x80-\\x82\\x87\\x88\\x8B-\\x8D\\xB0\\xB1]|\\xAA[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xAB[\\x80-\\x85\\x87-\\x89\\x8B-\\x8D]|\\xAC[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xAD[\\x80-\\x83\\x87\\x88\\x8B-\\x8D\\x96\\x97]|\\xAE[\\x82\\x83\\xBE\\xBF]|\\xAF[\\x80-\\x82\\x86-\\x88\\x8A-\\x8D\\x97]|\\xB0[\\x81-\\x83\\xBE\\xBF]|\\xB1[\\x80-\\x84\\x86-\\x88\\x8A-\\x8D\\x95\\x96]|\\xB2[\\x82\\x83\\xBE\\xBF]|\\xB3[\\x80-\\x84\\x86-\\x88\\x8A-\\x8D\\x95\\x96]|\\xB4[\\x82\\x83\\xBE\\xBF]|\\xB5[\\x80-\\x83\\x86-\\x88\\x8A-\\x8D\\x97]|\\xB8[\\xB1\\xB4-\\xBA]|\\xB9[\\x87-\\x8E]|\\xBA[\\xB1\\xB4-\\xB9\\xBB\\xBC]|\\xBB[\\x88-\\x8D]|\\xBC[\\x98\\x99\\xB5\\xB7\\xB9\\xBE\\xBF]|\\xBD[\\xB1-\\xBF]|\\xBE[\\x80-\\x84\\x86-\\x8B\\x90-\\x95\\x97\\x99-\\xAD\\xB1-\\xB7\\xB9])|\\xE2\\x83[\\x90-\\x9C\\xA1]|\\xE3(?:\\x80[\\xAA-\\xAF]|\\x82[\\x99\\x9A]))|(?:\\xC2\\xB7|\\xCB[\\x90\\x91]|\\xCE\\x87|\\xD9\\x80|\\xE0(?:\\xB9\\x86|\\xBB\\x86)|\\xE3(?:\\x80[\\x85\\xB1-\\xB5]|\\x82[\\x9D\\x9E]|\\x83[\\xBC-\\xBE])))*)", id)) {
                this.warning("ID value '" + id + "' is not a valid XML NCName.");
            }
        }
        return full.toString();
    }

    private boolean trackDuplicateIds(String id, URI uri) {
        HashSet<URI> urisForId = this._ids.get(id);
        if (urisForId == null) {
            urisForId = new HashSet();
            this._ids.put(id, urisForId);
        }
        return !urisForId.add(uri);
    }

    private String removeFragment(URI u) throws SAXException {
        try {
            return new URI(u.getScheme().toLowerCase(), u.getUserInfo(), u.getHost().toLowerCase(), u.getPort(), u.getPath(), u.getQuery(), null).toString();
        }
        catch (URISyntaxException e) {
            this.error("URISyntaxException removing fragment from base:" + u);
            return u.toString();
        }
    }

    private Literal createLiteral(String s) {
        Literal l;
        if (this._datatype != null) {
            l = new Literal(s, this._datatype);
            this._datatype = null;
        } else {
            l = this._currentLang != null ? new Literal(s, this._currentLang) : new Literal(s);
        }
        return l;
    }

    private void initialiseCurrentProperty(Resource uri, Attributes attrs) throws SAXException {
        this._currentP = uri;
        if (this._currentP.equals((Object)RDF.LI)) {
            ++this._currentLi;
            this._li.put(this._depth, this._currentLi);
            this._currentP = RdfXmlParserBase.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#_" + this._currentLi);
        }
        ++this._depth;
        this.checkAndHandleBaseURI(attrs);
        this.checkAndHandleLang(attrs);
        for (int i = 0; i < attrs.getLength(); ++i) {
            this.handlePropertyAttributePair(attrs.getURI(i), attrs.getLocalName(i), attrs.getQName(i), attrs.getValue(i));
        }
        if (this._currentPRD != null) {
            Node id = this._currentPRD.getIdentifier();
            if (id == null) {
                id = this.generateBNode();
            }
            this.handleStatement(new Node[]{this._currentS, this._currentP, id});
            for (Node[] edge : this._currentPRD.getEdges()) {
                this.handleStatement(id, edge[0], edge[1]);
            }
            this._currentPRD = null;
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this._state.equals(State.PTL_XML)) {
            this.handleXMLLiteralPrefixMapping(prefix, uri);
        }
    }

    private void handleXMLLiteralPrefixMapping(String prefix, String uri) {
        this._xmllPrefixes.put(prefix, uri);
        if (this._prefixDefinition == null) {
            this._prefixDefinition = new StringBuffer();
        }
        this._prefixDefinition.append(" " + this.createPrefixDefinition(prefix, uri));
    }

    private String createPrefixDefinition(String prefix, String uri) {
        if (prefix == null || prefix.isEmpty()) {
            return "xmlns=\"" + uri + "\"";
        }
        return "xmlns:" + prefix + "=\"" + uri + "\"";
    }

    private String getPrefix(String qname, String lname) {
        if (qname.length() == lname.length()) {
            return NULL;
        }
        return qname.substring(0, qname.length() - (lname.length() + 1));
    }

    private void checkXMLLiteralPrefix(String name, String lname, String qname) {
        if (name.equals(NULL)) {
            return;
        }
        String prefix = this.getPrefix(qname, lname);
        if (this._xmllPrefixes.get(prefix) == null) {
            this.handleXMLLiteralPrefixMapping(prefix, name);
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this._state.equals(State.PTL_XML)) {
            this._xmllPrefixes.remove(prefix);
        }
    }

    private void handlePropertyAttributePair(String name, String lname, String qname, String o) throws SAXException {
        Resource p;
        if (name == null || name.equals(NULL)) {
            if (RDF_PROP_ATTR_NAMES_TS.contains(lname)) {
                this.warning("Unqualified use of RDF name " + lname + " is deprecated.");
                p = RdfXmlParserBase.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#" + lname);
            } else {
                if (lname.startsWith("xml")) {
                    return;
                }
                this.error("Unqualified attribute name " + lname + " found.");
                p = RdfXmlParserBase.createResource(this.resolveFullURI(lname, false));
            }
        } else {
            p = RdfXmlParserBase.createResource(name + lname);
        }
        if (p.equals((Object)RDF.RESOURCE)) {
            if (this._currentPRD != null && this._currentPRD.getIdentifier() != null) {
                this.fatalError("Cannot have more than one rdf:resource/rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.T_CP)) {
                this.fatalError("Cannot have both rdf:datatype and rdf:resource attached as attributes to a property.");
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:resource attached as attributes to a property.");
            } else if (this._state.equals(State.PTL_XML)) {
                this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:resource attached as attributes to a property.");
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:resource attached as attributes to a property.");
            }
            Resource id = RdfXmlParserBase.createResource(this.resolveFullURI(o, false));
            if (this._currentPRD == null) {
                this._currentPRD = new ResourceDescription((Node)id);
            } else {
                this._currentPRD.setIdentifier((Node)id);
            }
            this._state = State.CP;
        } else if (p.equals((Object)RDF.NODEID)) {
            if (this._currentPRD != null && this._currentPRD.getIdentifier() != null) {
                this.fatalError("Cannot have more than one rdf:resource/rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.T_CP)) {
                this.fatalError("Cannot have both rdf:datatype and rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.PTL_XML)) {
                this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:nodeID attached as attributes to a property.");
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:nodeID attached as attributes to a property.");
            }
            BNode id = this.generateBNode(o);
            if (this._currentPRD == null) {
                this._currentPRD = new ResourceDescription((Node)id);
            } else {
                this._currentPRD.setIdentifier((Node)id);
            }
            this._state = State.CP;
        } else if (p.equals((Object)RDF.TYPE)) {
            if (this._state.equals(State.T_CP)) {
                this.fatalError("Cannot have both rdf:datatype and rdf:type attached as attributes to a property.");
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:type attached as attributes to a property.");
            } else if (this._state.equals(State.PTL_XML)) {
                this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:type attached as attributes to a property.");
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:type attached as attributes to a property.");
            }
            if (this._currentPRD == null) {
                this._currentPRD = new ResourceDescription();
            }
            this._currentPRD.addEdge(new Node[]{RDF.TYPE, RdfXmlParserBase.createResource(o)});
            this._state = State.CP;
        } else if (!(qname.equals(XML_BASE) || qname.equals(XML_LANG) || qname.equals(XML_SPACE) || qname.equals(XML_ID) || qname.startsWith(XML_PREFIX))) {
            if (p.equals((Object)RDF.DATATYPE)) {
                if (this._state.equals(State.CP)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:resource attached as attributes to a property.");
                } else if (this._state.equals(State.PTC_OR_CP)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Collection' attached as attributes to a property.");
                } else if (this._state.equals(State.PTL_XML)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Literal' attached as attributes to a property.");
                } else if (this._state.equals(State.PTR_OP_CP)) {
                    this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Resource' attached as attributes to a property.");
                }
                this._datatype = RdfXmlParserBase.createResource(this.resolveFullURI(o, false));
                this._state = State.T_CP;
            } else if (p.equals((Object)RDF.PARSETYPE)) {
                if (o.equals("Collection")) {
                    if (this._state.equals(State.CP)) {
                        this.fatalError("Cannot have both rdf:resource and rdf:parseType='Collection' attached as attributes to a property.");
                    } else if (this._state.equals(State.T_CP)) {
                        this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Collection' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTL_XML)) {
                        this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:parseType='Collection' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTR_OP_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:parseType='Collection' attached as attributes to a property.");
                    }
                    this._state = State.PTC_OR_CP;
                } else if (o.equals("Literal")) {
                    if (this._state.equals(State.CP)) {
                        this.fatalError("Cannot have both rdf:resource and rdf:parseType='Literal' attached as attributes to a property.");
                    } else if (this._state.equals(State.T_CP)) {
                        this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Literal' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTC_OR_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:parseType='Literal' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTR_OP_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Resource' and rdf:parseType='Literal' attached as attributes to a property.");
                    }
                    this._state = State.PTL_XML;
                    this._sptlp = this._currentP;
                    this._sptldepth = 0;
                    this._xmllPrefixes = new HashMap();
                    this._currentL = new StringBuffer();
                } else if (o.equals("Resource")) {
                    if (this._state.equals(State.CP)) {
                        this.fatalError("Cannot have both rdf:resource and rdf:parseType='Resource' attached as attributes to a property.");
                    } else if (this._state.equals(State.T_CP)) {
                        this.fatalError("Cannot have both rdf:datatype and rdf:parseType='Resource' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTC_OR_CP)) {
                        this.fatalError("Cannot have both rdf:parseType='Collection' and rdf:parseType='Resource' attached as attributes to a property.");
                    } else if (this._state.equals(State.PTL_XML)) {
                        this.fatalError("Cannot have both rdf:parseType='Literal' and rdf:parseType='Resource' attached as attributes to a property.");
                    }
                    this._currentL = null;
                    this._sptr.add(this._depth);
                    this._state = State.PTR_OP_CP;
                }
            } else if (p.equals((Object)RDF.ID)) {
                this._currentReify = RdfXmlParserBase.createResource(this.resolveFullURI(o, true));
            } else {
                if (this._state.equals(State.T_CP)) {
                    this.fatalError("Cannot have both rdf:datatype and " + qname + " attached as attributes to a property.");
                } else if (this._state.equals(State.PTC_OR_CP)) {
                    this.fatalError("Cannot have both rdf:parseType='Collection' and " + qname + " attached as attributes to a property.");
                } else if (this._state.equals(State.PTL_XML)) {
                    this.fatalError("Cannot have both rdf:parseType='Literal' and " + qname + " attached as attributes to a property.");
                } else if (this._state.equals(State.PTR_OP_CP)) {
                    this.fatalError("Cannot have both rdf:parseType='Resource' and " + qname + " attached as attributes to a property.");
                }
                if (this._currentPRD == null) {
                    this._currentPRD = new ResourceDescription();
                }
                this._currentPRD.addEdge(new Node[]{p, this.createLiteral(o)});
                this._state = State.CP;
            }
        }
    }

    @Override
    public void endElement(String name, String lname, String qname) throws SAXException {
        String lang;
        boolean endptl;
        Resource rq = RdfXmlParserBase.createResource(name + lname);
        URI base = this._sbq.decrementScope();
        if (base != null) {
            this._currentBase = base;
        }
        boolean ptr = this._sptr.remove(this._depth);
        boolean bl = endptl = this._sptldepth == 0 && this._sptlp != null && (this._sptlp.equals((Object)rq) || RdfXmlParserBase.isCMP(this._sptlp) && RdfXmlParserBase.isCMP(rq));
        if (!rq.equals((Object)RDF.RDF) && !this._state.equals(State.OR)) {
            String s;
            if (this._state.equals(State.CR_OP)) {
                Integer li;
                this._fifoS.remove(this._fifoS.size() - 1);
                this._li.remove(this._depth);
                if (ptr) {
                    this._currentS = this._fifoS.get(this._fifoS.size() - 1);
                    li = this._li.get(this._depth - 1);
                    if (li != null) {
                        this._currentLi = li;
                    }
                    --this._depth;
                } else if (this._depth > 0) {
                    this._currentS = this._fifoS.get(this._fifoS.size() - 1);
                    li = this._li.get(this._depth - 1);
                    if (li != null) {
                        this._currentLi = li;
                    }
                    this._state = State.CP;
                    Node cc = this._coll.get(this._depth);
                    if (cc != null) {
                        this._currentColl = cc;
                        this._state = State.PTC_OR_CP;
                    }
                } else {
                    this._state = State.START;
                }
            } else if (this._state.equals(State.T_CP_OR) || this._state.equals(State.T_CP)) {
                s = NULL;
                if (this._currentL != null) {
                    s = this._currentL.toString();
                }
                Literal l = this.createLiteral(s);
                this.handleStatement(new Node[]{this._currentS, this._currentP, l});
                this._currentL = null;
                --this._depth;
                this._state = State.CR_OP;
            } else if (this._state.equals(State.CP)) {
                --this._depth;
                this._state = State.CR_OP;
            } else if (this._state.equals(State.PTC_OR_CP)) {
                this._coll.remove(this._depth);
                if (this._currentColl != null) {
                    this.handleStatement(new Node[]{this._currentColl, RDF.REST, RDF.NIL});
                    this._currentColl = null;
                } else {
                    this.handleStatement(new Node[]{this._currentS, this._currentP, RDF.NIL});
                }
                --this._depth;
                this._state = State.CR_OP;
            } else if (this._state.equals(State.PTL_XML)) {
                if (endptl) {
                    s = NULL;
                    this._state = State.CR_OP;
                    if (this._currentL != null) {
                        s = this._currentL.toString();
                    }
                    this._datatype = RDF.XMLLITERAL;
                    Literal l = this.createLiteral(s);
                    this.handleStatement(new Node[]{this._currentS, this._currentP, l});
                    this._currentL = null;
                    this._sptldepth = 0;
                    this._sptlp = null;
                    --this._depth;
                } else {
                    if (rq.equals((Object)this._sptlp)) {
                        --this._sptldepth;
                    }
                    this.handleParseTypeLiteralEndElement(name, lname, qname);
                }
            } else if (this._state.equals(State.PTR_OP_CP)) {
                this.handleStatement(new Node[]{this._currentS, this._currentP, this.generateBNode()});
                --this._depth;
                this._state = State.CR_OP;
            }
        }
        if ((lang = this._slang.decrementScope()) != null) {
            this._currentLang = lang.equals(NULL) ? null : lang.toLowerCase();
        }
    }

    private static boolean isCMP(Resource p1) {
        return p1.equals((Object)RDF.LI) || p1.toString().startsWith("<http://www.w3.org/1999/02/22-rdf-syntax-ns#_");
    }

    private void handleParseTypeLiteralEndElement(String name, String lname, String qname) {
        this._currentL.append("</" + qname + ">");
    }

    private BNode generateBNode() {
        ++this._bnode;
        if (this._skolemise) {
            return new BNode(this._escapedDocURI + "xx" + BNODE_PREFIX + (this._bnode - 1));
        }
        return new BNode(BNODE_PREFIX + (this._bnode - 1));
    }

    private BNode generateBNode(String nodeID) throws SAXException {
        int oldLength = nodeID.length();
        if (oldLength != (nodeID = nodeID.trim()).length()) {
            this.warning("Leading or trailing whitespace in rdf:nodeID " + nodeID + ".");
        }
        if (!Pattern.matches("(?:(?:_|(?:(?:[a-zA-Z]|\\xC3[\\x80-\\x96\\x98-\\xB6\\xB8-\\xBF]|\\xC4[\\x80-\\xB1\\xB4-\\xBE]|\\xC5[\\x81-\\x88\\x8A-\\xBE]|\\xC6[\\x80-\\xBF]|\\xC7[\\x80-\\x83\\x8D-\\xB0\\xB4\\xB5\\xBA-\\xBF]|\\xC8[\\x80-\\x97]|\\xC9[\\x90-\\xBF]|\\xCA[\\x80-\\xA8\\xBB-\\xBF]|\\xCB[\\x80\\x81]|\\xCE[\\x86\\x88-\\x8A\\x8C\\x8E-\\xA1\\xA3-\\xBF]|\\xCF[\\x80-\\x8E\\x90-\\x96\\x9A\\x9C\\x9E\\xA0\\xA2-\\xB3]|\\xD0[\\x81-\\x8C\\x8E-\\xBF]|\\xD1[\\x80-\\x8F\\x91-\\x9C\\x9E-\\xBF]|\\xD2[\\x80\\x81\\x90-\\xBF]|\\xD3[\\x80-\\x84\\x87\\x88\\x8B\\x8C\\x90-\\xAB\\xAE-\\xB5\\xB8\\xB9]|\\xD4[\\xB1-\\xBF]|\\xD5[\\x80-\\x96\\x99\\xA1-\\xBF]|\\xD6[\\x80-\\x86]|\\xD7[\\x90-\\xAA\\xB0-\\xB2]|\\xD8[\\xA1-\\xBA]|\\xD9[\\x81-\\x8A\\xB1-\\xBF]|\\xDA[\\x80-\\xB7\\xBA-\\xBE]|\\xDB[\\x80-\\x8E\\x90-\\x93\\x95\\xA5\\xA6]|\\xE0(?:\\xA4[\\x85-\\xB9\\xBD]|\\xA5[\\x98-\\xA1]|\\xA6[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB6-\\xB9]|\\xA7[\\x9C\\x9D\\x9F-\\xA1\\xB0\\xB1]|\\xA8[\\x85-\\x8A\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5\\xB6\\xB8\\xB9]|\\xA9[\\x99-\\x9C\\x9E\\xB2-\\xB4]|\\xAA[\\x85-\\x8B\\x8D\\x8F-\\x91\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5-\\xB9\\xBD]|\\xAB\\xA0|\\xAC[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB6-\\xB9\\xBD]|\\xAD[\\x9C\\x9D\\x9F-\\xA1]|\\xAE[\\x85-\\x8A\\x8E-\\x90\\x92-\\x95\\x99\\x9A\\x9C\\x9E\\x9F\\xA3\\xA4\\xA8-\\xAA\\xAE-\\xB5\\xB7-\\xB9]|\\xB0[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB1[\\xA0\\xA1]|\\xB2[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB3[\\x9E\\xA0\\xA1]|\\xB4[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB9]|\\xB5[\\xA0\\xA1]|\\xB8[\\x81-\\xAE\\xB0\\xB2\\xB3]|\\xB9[\\x80-\\x85]|\\xBA[\\x81\\x82\\x84\\x87\\x88\\x8A\\x8D\\x94-\\x97\\x99-\\x9F\\xA1-\\xA3\\xA5\\xA7\\xAA\\xAB\\xAD\\xAE\\xB0\\xB2\\xB3\\xBD]|\\xBB[\\x80-\\x84]|\\xBD[\\x80-\\x87\\x89-\\xA9])|\\xE1(?:\\x82[\\xA0-\\xBF]|\\x83[\\x80-\\x85\\x90-\\xB6]|\\x84[\\x80\\x82\\x83\\x85-\\x87\\x89\\x8B\\x8C\\x8E-\\x92\\xBC\\xBE]|\\x85[\\x80\\x8C\\x8E\\x90\\x94\\x95\\x99\\x9F-\\xA1\\xA3\\xA5\\xA7\\xA9\\xAD\\xAE\\xB2\\xB3\\xB5]|\\x86[\\x9E\\xA8\\xAB\\xAE\\xAF\\xB7\\xB8\\xBA\\xBC-\\xBF]|\\x87[\\x80-\\x82\\xAB\\xB0\\xB9]|[\\xB8\\xB9][\\x80-\\xBF]|\\xBA[\\x80-\\x9B\\xA0-\\xBF]|\\xBB[\\x80-\\xB9]|\\xBC[\\x80-\\x95\\x98-\\x9D\\xA0-\\xBF]|\\xBD[\\x80-\\x85\\x88-\\x8D\\x90-\\x97\\x99\\x9B\\x9D\\x9F-\\xBD]|\\xBE[\\x80-\\xB4\\xB6-\\xBC\\xBE]|\\xBF[\\x82-\\x84\\x86-\\x8C\\x90-\\x93\\x96-\\x9B\\xA0-\\xAC\\xB2-\\xB4\\xB6-\\xBC])|\\xE2(?:\\x84[\\xA6\\xAA\\xAB\\xAE]|\\x86[\\x80-\\x82])|\\xE3(?:\\x81[\\x81-\\xBF]|\\x82[\\x80-\\x94\\xA1-\\xBF]|\\x83[\\x80-\\xBA]|\\x84[\\x85-\\xAC])|\\xEA(?:[\\xB0-\\xBF][\\x80-\\xBF])|\\xEB(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xEC(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xED(?:[\\x80-\\x9D][\\x80-\\xBF]|\\x9E[\\x80-\\xA3]))|(?:\\xE3\\x80[\\x87\\xA1-\\xA9]|\\xE4(?:[\\xB8-\\xBF][\\x80-\\xBF])|\\xE5(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE6(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE7(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE8(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE9(?:[\\x80-\\xBD][\\x80-\\xBF]|\\xBE[\\x80-\\xA5]))))(?:[-._]|(?:(?:[a-zA-Z]|\\xC3[\\x80-\\x96\\x98-\\xB6\\xB8-\\xBF]|\\xC4[\\x80-\\xB1\\xB4-\\xBE]|\\xC5[\\x81-\\x88\\x8A-\\xBE]|\\xC6[\\x80-\\xBF]|\\xC7[\\x80-\\x83\\x8D-\\xB0\\xB4\\xB5\\xBA-\\xBF]|\\xC8[\\x80-\\x97]|\\xC9[\\x90-\\xBF]|\\xCA[\\x80-\\xA8\\xBB-\\xBF]|\\xCB[\\x80\\x81]|\\xCE[\\x86\\x88-\\x8A\\x8C\\x8E-\\xA1\\xA3-\\xBF]|\\xCF[\\x80-\\x8E\\x90-\\x96\\x9A\\x9C\\x9E\\xA0\\xA2-\\xB3]|\\xD0[\\x81-\\x8C\\x8E-\\xBF]|\\xD1[\\x80-\\x8F\\x91-\\x9C\\x9E-\\xBF]|\\xD2[\\x80\\x81\\x90-\\xBF]|\\xD3[\\x80-\\x84\\x87\\x88\\x8B\\x8C\\x90-\\xAB\\xAE-\\xB5\\xB8\\xB9]|\\xD4[\\xB1-\\xBF]|\\xD5[\\x80-\\x96\\x99\\xA1-\\xBF]|\\xD6[\\x80-\\x86]|\\xD7[\\x90-\\xAA\\xB0-\\xB2]|\\xD8[\\xA1-\\xBA]|\\xD9[\\x81-\\x8A\\xB1-\\xBF]|\\xDA[\\x80-\\xB7\\xBA-\\xBE]|\\xDB[\\x80-\\x8E\\x90-\\x93\\x95\\xA5\\xA6]|\\xE0(?:\\xA4[\\x85-\\xB9\\xBD]|\\xA5[\\x98-\\xA1]|\\xA6[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB6-\\xB9]|\\xA7[\\x9C\\x9D\\x9F-\\xA1\\xB0\\xB1]|\\xA8[\\x85-\\x8A\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5\\xB6\\xB8\\xB9]|\\xA9[\\x99-\\x9C\\x9E\\xB2-\\xB4]|\\xAA[\\x85-\\x8B\\x8D\\x8F-\\x91\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB5-\\xB9\\xBD]|\\xAB\\xA0|\\xAC[\\x85-\\x8C\\x8F\\x90\\x93-\\xA8\\xAA-\\xB0\\xB2\\xB3\\xB6-\\xB9\\xBD]|\\xAD[\\x9C\\x9D\\x9F-\\xA1]|\\xAE[\\x85-\\x8A\\x8E-\\x90\\x92-\\x95\\x99\\x9A\\x9C\\x9E\\x9F\\xA3\\xA4\\xA8-\\xAA\\xAE-\\xB5\\xB7-\\xB9]|\\xB0[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB1[\\xA0\\xA1]|\\xB2[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB3\\xB5-\\xB9]|\\xB3[\\x9E\\xA0\\xA1]|\\xB4[\\x85-\\x8C\\x8E-\\x90\\x92-\\xA8\\xAA-\\xB9]|\\xB5[\\xA0\\xA1]|\\xB8[\\x81-\\xAE\\xB0\\xB2\\xB3]|\\xB9[\\x80-\\x85]|\\xBA[\\x81\\x82\\x84\\x87\\x88\\x8A\\x8D\\x94-\\x97\\x99-\\x9F\\xA1-\\xA3\\xA5\\xA7\\xAA\\xAB\\xAD\\xAE\\xB0\\xB2\\xB3\\xBD]|\\xBB[\\x80-\\x84]|\\xBD[\\x80-\\x87\\x89-\\xA9])|\\xE1(?:\\x82[\\xA0-\\xBF]|\\x83[\\x80-\\x85\\x90-\\xB6]|\\x84[\\x80\\x82\\x83\\x85-\\x87\\x89\\x8B\\x8C\\x8E-\\x92\\xBC\\xBE]|\\x85[\\x80\\x8C\\x8E\\x90\\x94\\x95\\x99\\x9F-\\xA1\\xA3\\xA5\\xA7\\xA9\\xAD\\xAE\\xB2\\xB3\\xB5]|\\x86[\\x9E\\xA8\\xAB\\xAE\\xAF\\xB7\\xB8\\xBA\\xBC-\\xBF]|\\x87[\\x80-\\x82\\xAB\\xB0\\xB9]|[\\xB8\\xB9][\\x80-\\xBF]|\\xBA[\\x80-\\x9B\\xA0-\\xBF]|\\xBB[\\x80-\\xB9]|\\xBC[\\x80-\\x95\\x98-\\x9D\\xA0-\\xBF]|\\xBD[\\x80-\\x85\\x88-\\x8D\\x90-\\x97\\x99\\x9B\\x9D\\x9F-\\xBD]|\\xBE[\\x80-\\xB4\\xB6-\\xBC\\xBE]|\\xBF[\\x82-\\x84\\x86-\\x8C\\x90-\\x93\\x96-\\x9B\\xA0-\\xAC\\xB2-\\xB4\\xB6-\\xBC])|\\xE2(?:\\x84[\\xA6\\xAA\\xAB\\xAE]|\\x86[\\x80-\\x82])|\\xE3(?:\\x81[\\x81-\\xBF]|\\x82[\\x80-\\x94\\xA1-\\xBF]|\\x83[\\x80-\\xBA]|\\x84[\\x85-\\xAC])|\\xEA(?:[\\xB0-\\xBF][\\x80-\\xBF])|\\xEB(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xEC(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xED(?:[\\x80-\\x9D][\\x80-\\xBF]|\\x9E[\\x80-\\xA3]))|(?:\\xE3\\x80[\\x87\\xA1-\\xA9]|\\xE4(?:[\\xB8-\\xBF][\\x80-\\xBF])|\\xE5(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE6(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE7(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE8(?:[\\x80-\\xBF][\\x80-\\xBF])|\\xE9(?:[\\x80-\\xBD][\\x80-\\xBF]|\\xBE[\\x80-\\xA5])))|(?:[0-9]|\\xD9[\\xA0-\\xA9]|\\xDB[\\xB0-\\xB9]|\\xE0(?:\\xA5[\\xA6-\\xAF]|\\xA7[\\xA6-\\xAF]|\\xA9[\\xA6-\\xAF]|\\xAB[\\xA6-\\xAF]|\\xAD[\\xA6-\\xAF]|\\xAF[\\xA7-\\xAF]|\\xB1[\\xA6-\\xAF]|\\xB3[\\xA6-\\xAF]|\\xB5[\\xA6-\\xAF]|\\xB9[\\x90-\\x99]|\\xBB[\\x90-\\x99]|\\xBC[\\xA0-\\xA9]))|(?:\\xCC[\\x80-\\xBF]|\\xCD[\\x80-\\x85\\xA0\\xA1]|\\xD2[\\x83-\\x86]|\\xD6[\\x91-\\xA1\\xA3-\\xB9\\xBB-\\xBD\\xBF]|\\xD7[\\x81\\x82\\x84]|\\xD9[\\x8B-\\x92\\xB0]|\\xDB[\\x96-\\xA4\\xA7\\xA8\\xAA-\\xAD]|\\xE0(?:\\xA4[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xA5[\\x80-\\x8D\\x91-\\x94\\xA2\\xA3]|\\xA6[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xA7[\\x80-\\x84\\x87\\x88\\x8B-\\x8D\\x97\\xA2\\xA3]|\\xA8[\\x82\\xBC\\xBE\\xBF]|\\xA9[\\x80-\\x82\\x87\\x88\\x8B-\\x8D\\xB0\\xB1]|\\xAA[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xAB[\\x80-\\x85\\x87-\\x89\\x8B-\\x8D]|\\xAC[\\x81-\\x83\\xBC\\xBE\\xBF]|\\xAD[\\x80-\\x83\\x87\\x88\\x8B-\\x8D\\x96\\x97]|\\xAE[\\x82\\x83\\xBE\\xBF]|\\xAF[\\x80-\\x82\\x86-\\x88\\x8A-\\x8D\\x97]|\\xB0[\\x81-\\x83\\xBE\\xBF]|\\xB1[\\x80-\\x84\\x86-\\x88\\x8A-\\x8D\\x95\\x96]|\\xB2[\\x82\\x83\\xBE\\xBF]|\\xB3[\\x80-\\x84\\x86-\\x88\\x8A-\\x8D\\x95\\x96]|\\xB4[\\x82\\x83\\xBE\\xBF]|\\xB5[\\x80-\\x83\\x86-\\x88\\x8A-\\x8D\\x97]|\\xB8[\\xB1\\xB4-\\xBA]|\\xB9[\\x87-\\x8E]|\\xBA[\\xB1\\xB4-\\xB9\\xBB\\xBC]|\\xBB[\\x88-\\x8D]|\\xBC[\\x98\\x99\\xB5\\xB7\\xB9\\xBE\\xBF]|\\xBD[\\xB1-\\xBF]|\\xBE[\\x80-\\x84\\x86-\\x8B\\x90-\\x95\\x97\\x99-\\xAD\\xB1-\\xB7\\xB9])|\\xE2\\x83[\\x90-\\x9C\\xA1]|\\xE3(?:\\x80[\\xAA-\\xAF]|\\x82[\\x99\\x9A]))|(?:\\xC2\\xB7|\\xCB[\\x90\\x91]|\\xCE\\x87|\\xD9\\x80|\\xE0(?:\\xB9\\x86|\\xBB\\x86)|\\xE3(?:\\x80[\\x85\\xB1-\\xB5]|\\x82[\\x9D\\x9E]|\\x83[\\xBC-\\xBE])))*)", nodeID)) {
            this.warning("nodeID value '" + nodeID + "' is not a valid XML NCName.");
        }
        nodeID = BNode.escapeForBNode((String)nodeID);
        if (this._skolemise) {
            return new BNode(this._escapedDocURI + "xx" + nodeID);
        }
        return new BNode(nodeID);
    }

    private void warning(String msg) throws SAXException {
        SAXException e = new SAXException((Exception)((Object)new RDFXMLParseException("WARNING: " + msg + " " + this.getLocation())));
        this.warning(e);
    }

    private void error(String msg) throws SAXException {
        SAXException e = new SAXException((Exception)((Object)new RDFXMLParseException("ERROR: " + msg + " " + this.getLocation())));
        this.error(e);
    }

    private void fatalError(String msg) throws SAXException {
        SAXException e = new SAXException((Exception)((Object)new RDFXMLParseException("FATAL ERROR: " + msg + " " + this.getLocation())));
        this.fatalError(e);
    }

    public void warning(SAXException e) throws SAXException {
        _log.warning(e.getMessage());
        if (this._strict) {
            throw e;
        }
    }

    public void error(SAXException e) throws SAXException {
        _log.warning(e.getMessage());
        if (this._strict) {
            throw e;
        }
    }

    public void fatalError(SAXException e) throws SAXException {
        _log.severe(e.getMessage());
        throw e;
    }

    @Override
    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
        char[] cs = new char[len];
        System.arraycopy(buf, offset, cs, 0, len);
        String s = new String(cs);
        if (this._state.expectText()) {
            if (this._currentL == null) {
                this._currentL = new StringBuffer();
            }
            this._currentL.append(s);
        }
    }

    private boolean nodeIsAllowed(String qname, Resource r) throws SAXException {
        if (NOT_ALLOWED_NODE_TS.contains(r)) {
            this.error("Attribute '" + qname + "' not allowed to be used as a node element.");
            return false;
        }
        return true;
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        char[] cs = new char[len];
        System.arraycopy(buf, offset, cs, 0, len);
        String v = new String(cs);
        boolean ws = v.trim().equals(NULL);
        if (ws) {
            this.ignorableWhitespace(buf, offset, len);
            return;
        }
        if (this._state.expectText()) {
            if (this._currentL == null) {
                this._currentL = new StringBuffer();
            }
            for (int i = offset; i < len + offset; ++i) {
                char c = buf[i];
                if (this._state.equals(State.PTL_XML)) {
                    if (c == '\"') {
                        this._currentL.append("&quot;");
                        continue;
                    }
                    if (c == '&') {
                        this._currentL.append("&amp;");
                        continue;
                    }
                    if (c == '<') {
                        this._currentL.append("&lt;");
                        continue;
                    }
                    if (c == '>') {
                        this._currentL.append("&gt;");
                        continue;
                    }
                    int ci = 0xFFFF & c;
                    if (ci < 160) {
                        this._currentL.append(c);
                        continue;
                    }
                    this._currentL.append("&#");
                    this._currentL.append(new Integer(ci).toString());
                    this._currentL.append(';');
                    continue;
                }
                this._currentL.append(c);
            }
            if (this._state.equals(State.T_CP_OR)) {
                this._state = State.T_CP;
            }
        } else {
            this.fatalError("Dangling text '" + v + "' found outside of enclosing property tags.");
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return null;
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator loc) {
        this._loc = loc;
    }

    private String getLocation() {
        if (this._loc != null) {
            return "Line " + this._loc.getLineNumber() + " column " + this._loc.getColumnNumber() + ".";
        }
        return NULL;
    }

    public static Resource createResource(String raw) {
        return new Resource(raw);
    }

    private void handleStatement(Node ... triple) {
        this.processStatement(triple);
        if (this._currentReify != null) {
            this.processStatement(new Node[]{this._currentReify, RDF.TYPE, RDF.STATEMENT});
            this.processStatement(new Node[]{this._currentReify, RDF.SUBJECT, triple[0]});
            this.processStatement(new Node[]{this._currentReify, RDF.PREDICATE, triple[1]});
            this.processStatement(new Node[]{this._currentReify, RDF.OBJECT, triple[2]});
            this._currentReify = null;
        }
    }

    private void processStatement(Node ... triple) {
        if (this._con != null) {
            this._c.processStatement(new Node[]{triple[0], triple[1], triple[2], this._con});
        } else {
            this._c.processStatement(triple);
        }
    }

    public static class ScopedThing<E> {
        private LinkedList<Integer> _skip = new LinkedList();
        private LinkedList<E> _scoped = new LinkedList();
        private int _currentSkip = -1;
        private E _current = null;
        private E _global;

        public ScopedThing() {
            this(null);
        }

        public boolean inScope(E element) {
            if (this._current != null && this._current.equals(element)) {
                return true;
            }
            if (this._global != null && this._global.equals(element)) {
                return true;
            }
            return this._scoped.contains(element);
        }

        public ScopedThing(E global) {
            this._global = global;
        }

        public void incrementScope() {
            if (this._currentSkip != -1) {
                ++this._currentSkip;
            }
        }

        public E decrementScope() {
            if (this._currentSkip == -1) {
                return null;
            }
            --this._currentSkip;
            if (this._currentSkip == 0) {
                if (this._skip.size() > 0) {
                    this._currentSkip = this._skip.removeLast();
                    this._current = this._scoped.removeLast();
                    return this._current;
                }
                this._currentSkip = -1;
                return this._global;
            }
            return null;
        }

        public void addNewScopedElement(E element) {
            if (this._currentSkip != -1) {
                this._skip.add(this._currentSkip);
                this._scoped.add(this._current);
            }
            this._currentSkip = 0;
            this._current = element;
        }

        public void setCurrent(E element) {
            this._current = element;
        }
    }

    public static class RDFXMLParseException
    extends ParseException {
        private static final long serialVersionUID = 1L;

        public RDFXMLParseException() {
        }

        public RDFXMLParseException(String msg) {
            super(msg);
        }
    }

    public static class ResourceDescription {
        private Node _id = null;
        private ArrayList<Node[]> _edges = new ArrayList();

        public ResourceDescription() {
        }

        public ResourceDescription(Node id) {
            this._id = id;
        }

        public void setIdentifier(Node id) {
            this._id = id;
        }

        public Node getIdentifier() {
            return this._id;
        }

        public void addEdge(Node ... po) {
            this._edges.add(po);
        }

        public ArrayList<Node[]> getEdges() {
            return this._edges;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (Node[] edge : this._edges) {
                buf.append(this._id.toString() + " " + new Nodes(edge) + "\n");
            }
            return buf.toString();
        }
    }

    private static enum State implements Comparable<State>
    {
        START,
        OR,
        CR_OP,
        T_CP_OR,
        CP,
        T_CP,
        PTC_OR_CP,
        PTL_XML,
        PTR_OP_CP,
        PTA;


        public boolean expectText() {
            return this.equals(T_CP_OR) || this.equals(T_CP) || this.equals(PTL_XML);
        }

        public boolean expectOpenResource() {
            return this.equals(START) || this.equals(OR) || this.equals(T_CP_OR) || this.equals(PTC_OR_CP) || this.equals(PTL_XML);
        }

        public boolean expectOpenProperty() {
            return this.equals(CR_OP) || this.equals(PTR_OP_CP) || this.equals(PTL_XML);
        }

        public boolean equals(State s) {
            if (s == null) {
                return false;
            }
            return s.ordinal() == this.ordinal();
        }
    }
}

