/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.yars.nx.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.semanticweb.yars.nx.BNode;
import org.semanticweb.yars.nx.Literal;
import org.semanticweb.yars.nx.Node;
import org.semanticweb.yars.nx.Resource;
import org.semanticweb.yars.nx.Unbound;
import org.semanticweb.yars.nx.Variable;
import org.semanticweb.yars.nx.parser.ParseException;

public class NxParser
implements Iterator<Node[]>,
Iterable<Node[]> {
    private static Logger _log = Logger.getLogger(NxParser.class.getName());
    private int _lineNo = 0;
    private String _line = null;
    private Iterator<String> _stringIt = null;
    private Node[] next = null;

    public Iterator<Node[]> parse(Reader r) {
        return this.parse(new BufferedReader(r));
    }

    public Iterator<Node[]> parse(InputStream is, Charset cs) {
        return this.parse(new BufferedReader(new InputStreamReader(is, cs)));
    }

    public Iterator<Node[]> parse(InputStream is) {
        return this.parse(new BufferedReader(new InputStreamReader(is)));
    }

    public Iterator<Node[]> parse(BufferedReader br) {
        return this.parse(NxParser.stringItFromBufferedReader(br));
    }

    public Iterator<Node[]> parse(Iterable<String> iterable) {
        return this.parse(iterable.iterator());
    }

    public Iterator<Node[]> parse(Iterator<String> iterator) {
        this._stringIt = iterator;
        this.loadNext();
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public Node[] next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        Node[] now = this.next;
        this.loadNext();
        return now;
    }

    private void loadNext() {
        this.next = null;
        do {
            if (!this._stringIt.hasNext()) {
                this.next = null;
                return;
            }
            this._line = this._stringIt.next();
            ++this._lineNo;
        } while (this._line == null || NxParser.isEntirelyWhitespaceOrEmpty(this._line));
        try {
            this.next = NxParser.parseNodesInternal(this._line);
        }
        catch (Exception e) {
            _log.warning("Moving on to the next line, as I couldn't parse line " + this._lineNo + ": " + this._line);
            e.printStackTrace();
            this.loadNext();
        }
        if (this.next == null) {
            return;
        }
        if (this.next.length == 0) {
            this.loadNext();
        }
    }

    private static boolean isEntirelyWhitespaceOrEmpty(String s) {
        for (char c : s.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void remove() {
        this._stringIt.remove();
    }

    @Override
    public Iterator<Node[]> iterator() {
        return this;
    }

    public static Node[] parseNodes(String line) throws ParseException {
        try {
            return NxParser.parseNodesInternal(line);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static Node[] parseNodesInternal(String line) throws ParseException {
        int startIndex = 0;
        int endIndex = 0;
        LinkedList<Object> nx = new LinkedList<Object>();
        if (line.isEmpty()) {
            return new Node[0];
        }
        while (true) {
            if (Character.isWhitespace(line.charAt(startIndex))) {
                ++endIndex;
                if (++startIndex != line.length()) continue;
                if (!nx.isEmpty()) throw new ParseException("Could not find closing '.' bracket for line " + line);
                return new Node[0];
            }
            if (line.charAt(startIndex) == '<') {
                endIndex = startIndex;
                while (!(line.charAt(endIndex) == '>' || line.charAt(endIndex + 1) == '.' && Character.isWhitespace(line.charAt(endIndex + 1)))) {
                    ++endIndex;
                }
                if (++endIndex == 0) {
                    throw new ParseException("Could not find closing '>' bracket for resource starting at char " + startIndex + " while parsing line " + line);
                }
                nx.add(new Resource(line.substring(startIndex, endIndex), true));
            } else if (line.charAt(startIndex) == '_') {
                endIndex = startIndex;
                while ((line.charAt(endIndex) != '.' || endIndex + 2 < line.length() && !Character.isWhitespace(endIndex + 1)) && !Character.isWhitespace(line.charAt(endIndex))) {
                    ++endIndex;
                }
                nx.add(new BNode(line.substring(startIndex, endIndex), true));
            } else {
                if (line.charAt(startIndex) == '.') {
                    if (!nx.isEmpty()) return nx.toArray(new Node[nx.size()]);
                    throw new ParseException("Exception at position " + startIndex + " while parsing: '" + line + "'");
                }
                if (line.charAt(startIndex) == '\"') {
                    endIndex = startIndex;
                    while (line.charAt((endIndex = line.indexOf(34, endIndex + 1)) - 1) == '\\' && (endIndex - 1 - NxParser.onlyCharUntil(line, '\\', endIndex - 1)) % 2 == 0) {
                    }
                    while ((line.charAt(endIndex) != '.' || endIndex + 2 < line.length() && !Character.isWhitespace(endIndex + 1)) && !Character.isWhitespace(line.charAt(endIndex))) {
                        ++endIndex;
                    }
                    nx.add(new Literal(line.substring(startIndex, endIndex), true));
                } else {
                    if (line.charAt(startIndex) == '#' && nx.isEmpty()) {
                        return new Node[0];
                    }
                    if (line.charAt(startIndex) == '?') {
                        endIndex = startIndex;
                        while ((line.charAt(endIndex) != '.' || endIndex + 2 < line.length() && !Character.isWhitespace(endIndex + 1)) && !Character.isWhitespace(line.charAt(endIndex))) {
                            ++endIndex;
                        }
                        nx.add(new Variable(line.substring(startIndex, endIndex), true));
                    } else {
                        if (line.charAt(startIndex) != "UNBOUND".charAt(0)) throw new ParseException("Exception at position " + endIndex + " while parsing: '" + line + "'");
                        if (!line.substring(startIndex, startIndex + "UNBOUND".length()).equals("UNBOUND")) throw new ParseException("Exception at position " + endIndex + " while parsing: '" + line + "'");
                        nx.add(new Unbound());
                        endIndex = startIndex + "UNBOUND".length();
                        if (endIndex >= line.length() || line.charAt(endIndex) != ' ') {
                            throw new ParseException("Exception at position " + startIndex + " while parsing: '" + line + "'");
                        }
                    }
                }
            }
            if (line.charAt(endIndex) == '.') return nx.toArray(new Node[nx.size()]);
            startIndex = endIndex + 1;
        }
    }

    private static int onlyCharUntil(String line, char c, int i) {
        while (line.charAt(i) == c) {
            --i;
        }
        return i + 1;
    }

    private static Iterator<String> stringItFromBufferedReader(final BufferedReader br) {
        return new Iterator<String>(){
            boolean nextIsFetched = true;
            String next = null;

            @Override
            public boolean hasNext() {
                if (!this.nextIsFetched) {
                    return this.next != null;
                }
                try {
                    this.next = br.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.next = null;
                }
                this.nextIsFetched = false;
                return this.next != null;
            }

            @Override
            public String next() {
                if (this.nextIsFetched) {
                    try {
                        this.next = br.readLine();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.nextIsFetched = true;
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                return this.next;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int lineNumber() {
        return this._lineNo;
    }
}

