/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.transaction.spi;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.seedstack.seed.transaction.Propagation;
import org.seedstack.seed.transaction.Transactional;
import org.seedstack.seed.transaction.spi.ExceptionHandler;
import org.seedstack.seed.transaction.spi.TransactionHandler;

public class TransactionMetadata {
    private Propagation propagation;
    private Boolean readOnly;
    private Boolean rollbackOnParticipationFailure;
    private Class<? extends Exception>[] rollbackOn;
    private Class<? extends Exception>[] noRollbackFor;
    private Class<? extends TransactionHandler> handler;
    private Class<? extends ExceptionHandler> exceptionHandler;
    private String resource;
    private Map<String, Object> metadata = new HashMap<String, Object>();

    public Propagation getPropagation() {
        return this.propagation;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean isRollbackOnParticipationFailure() {
        return this.rollbackOnParticipationFailure;
    }

    public void setRollbackOnParticipationFailure(Boolean rollbackOnParticipationFailure) {
        this.rollbackOnParticipationFailure = rollbackOnParticipationFailure;
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Null is used here to denote an undetermined value")
    public Class<? extends Exception>[] getRollbackOn() {
        return this.rollbackOn != null ? (Class[])this.rollbackOn.clone() : null;
    }

    public void setRollbackOn(Class<? extends Exception>[] rollbackOn) {
        this.rollbackOn = (Class[])rollbackOn.clone();
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="Null is used here to denote an undetermined value")
    public Class<? extends Exception>[] getNoRollbackFor() {
        return this.noRollbackFor != null ? (Class[])this.noRollbackFor.clone() : null;
    }

    public void setNoRollbackFor(Class<? extends Exception>[] noRollbackFor) {
        this.noRollbackFor = (Class[])noRollbackFor.clone();
    }

    public Class<? extends TransactionHandler> getHandler() {
        return this.handler;
    }

    public void setHandler(Class<? extends TransactionHandler> handler) {
        this.handler = handler;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Class<? extends ExceptionHandler> getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(Class<? extends ExceptionHandler> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public Object getMetadata(String key) {
        return this.metadata.get(key);
    }

    public void addMetadata(String key, Object value) {
        this.metadata.put(key, value);
    }

    public TransactionMetadata mergeFrom(TransactionMetadata other) {
        if (other != null) {
            if (other.propagation != null) {
                this.propagation = other.propagation;
            }
            if (other.readOnly != null) {
                this.readOnly = other.readOnly;
            }
            if (other.rollbackOnParticipationFailure != null) {
                this.rollbackOnParticipationFailure = other.rollbackOnParticipationFailure;
            }
            if (other.rollbackOn != null) {
                this.rollbackOn = other.rollbackOn;
            }
            if (other.noRollbackFor != null) {
                this.noRollbackFor = other.noRollbackFor;
            }
            if (other.handler != null) {
                this.handler = other.handler;
            }
            if (other.exceptionHandler != null) {
                this.exceptionHandler = other.exceptionHandler;
            }
            if (other.resource != null) {
                this.resource = other.resource;
            }
            this.metadata.putAll(other.metadata);
        }
        return this;
    }

    public TransactionMetadata mergeFrom(Transactional other) {
        if (other != null) {
            if (other.propagation().length > 0) {
                this.propagation = other.propagation()[0];
            }
            if (other.readOnly().length > 0) {
                this.readOnly = other.readOnly()[0];
            }
            if (other.rollbackOnParticipationFailure().length > 0) {
                this.rollbackOnParticipationFailure = other.rollbackOnParticipationFailure()[0];
            }
            if (other.rollbackOn().length > 0) {
                this.rollbackOn = other.rollbackOn();
            }
            if (other.noRollbackFor().length > 0) {
                this.noRollbackFor = other.noRollbackFor();
            }
        }
        return this;
    }

    public String toString() {
        return "transaction metadata {propagation=" + (Object)((Object)this.propagation) + ", readOnly=" + this.readOnly + ", rollbackOnParticipationFailure=" + this.rollbackOnParticipationFailure + ", rollbackOn=" + Arrays.toString(this.rollbackOn) + ", noRollbackFor=" + Arrays.toString(this.noRollbackFor) + ", handler=" + this.handler + ", exceptionHandler=" + this.exceptionHandler + ", resource='" + this.resource + '\'' + ", metadata='" + this.metadata + '\'' + '}';
    }
}

