/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.crypto;

import java.util.Objects;

public class Hash {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private final byte[] hash;
    private final byte[] salt;

    public Hash(byte[] hash, byte[] salt) {
        this.hash = (byte[])Objects.requireNonNull(hash).clone();
        this.salt = (byte[])Objects.requireNonNull(salt).clone();
    }

    public Hash(String hash, String salt) {
        this.hash = Hash.hexToBytes(Objects.requireNonNull(hash));
        this.salt = Hash.hexToBytes(Objects.requireNonNull(salt));
    }

    public byte[] getHash() {
        return (byte[])this.hash.clone();
    }

    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    public String getHashAsString() {
        return Hash.bytesToHex(this.hash);
    }

    public String getSaltAsString() {
        return Hash.bytesToHex(this.salt);
    }

    public String toString() {
        return this.getHashAsString() + ":" + this.getSaltAsString();
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            hexChars[i * 2] = hexArray[v >>> 4];
            hexChars[i * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static byte[] hexToBytes(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException("Invalid hexadecimal string");
        }
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

