/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed.crypto;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.X509KeyManager;
import org.seedstack.coffig.Config;
import org.seedstack.coffig.SingleValue;
import org.seedstack.seed.crypto.spi.SSLAuthenticationMode;

@Config(value="crypto")
public class CryptoConfig {
    public static final String MASTER_KEY_STORE_NAME = "master";
    private StoreConfig truststore;
    private Map<String, KeyStoreConfig> keystores = new HashMap<String, KeyStoreConfig>();
    private SSLConfig ssl = new SSLConfig();

    public StoreConfig getTrustStore() {
        return this.truststore;
    }

    public CryptoConfig setTrustStore(StoreConfig truststore) {
        this.truststore = truststore;
        return this;
    }

    public Map<String, KeyStoreConfig> keyStores() {
        return Collections.unmodifiableMap(this.keystores);
    }

    public CryptoConfig addKeyStore(String name, KeyStoreConfig keyStoreConfig) {
        this.keystores.put(name, keyStoreConfig);
        return this;
    }

    public SSLConfig ssl() {
        return this.ssl;
    }

    @Config(value="ssl")
    public static class SSLConfig {
        private static final String DEFAULT_PROTOCOL = "TLS";
        private String protocol = "TLS";
        private String keystore = "master";
        @SingleValue
        private String keyPassword;
        private SSLAuthenticationMode clientAuthMode = SSLAuthenticationMode.NOT_REQUESTED;
        private Set<String> ciphers = new HashSet<String>();
        private Class<? extends X509KeyManager> x509KeyManager;
        private String keyManagerAlgorithm;
        private String trustManagerAlgorithm;
        private String randomAlgorithm;

        public String getProtocol() {
            return this.protocol;
        }

        public SSLConfig setProtocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public String getKeystore() {
            return this.keystore;
        }

        public SSLConfig setKeystore(String keystore) {
            this.keystore = keystore;
            return this;
        }

        public String getKeyPassword() {
            return this.keyPassword;
        }

        public void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        public SSLAuthenticationMode getClientAuthMode() {
            return this.clientAuthMode;
        }

        public SSLConfig setClientAuthMode(SSLAuthenticationMode clientAuthMode) {
            this.clientAuthMode = clientAuthMode;
            return this;
        }

        public Set<String> getCiphers() {
            return Collections.unmodifiableSet(this.ciphers);
        }

        public SSLConfig addCipher(String cipher) {
            this.ciphers.add(cipher);
            return this;
        }

        public Class<? extends X509KeyManager> getX509KeyManager() {
            return this.x509KeyManager;
        }

        public SSLConfig setX509KeyManager(Class<? extends X509KeyManager> x509KeyManager) {
            this.x509KeyManager = x509KeyManager;
            return this;
        }

        public String getKeyManagerAlgorithm() {
            return this.keyManagerAlgorithm;
        }

        public SSLConfig setKeyManagerAlgorithm(String keyManagerAlgorithm) {
            this.keyManagerAlgorithm = keyManagerAlgorithm;
            return this;
        }

        public String getTrustManagerAlgorithm() {
            return this.trustManagerAlgorithm;
        }

        public SSLConfig setTrustManagerAlgorithm(String trustManagerAlgorithm) {
            this.trustManagerAlgorithm = trustManagerAlgorithm;
            return this;
        }

        public String getRandomAlgorithm() {
            return this.randomAlgorithm;
        }

        public SSLConfig setRandomAlgorithm(String randomAlgorithm) {
            this.randomAlgorithm = randomAlgorithm;
            return this;
        }
    }

    public static class CertificateConfig {
        private String resource;
        @SingleValue
        private String file;

        public String getResource() {
            return this.resource;
        }

        public CertificateConfig setResource(String resource) {
            if (this.file != null) {
                throw new IllegalStateException("A certificate must be configured from either a resource or a file, not both");
            }
            this.resource = resource;
            return this;
        }

        public String getFile() {
            return this.file;
        }

        public CertificateConfig setFile(String file) {
            if (this.resource != null) {
                throw new IllegalStateException("A certificate must be configured from either a resource or a file, not both");
            }
            this.file = file;
            return this;
        }
    }

    public static class KeyStoreConfig
    extends StoreConfig {
        private Map<String, AliasConfig> aliases = new HashMap<String, AliasConfig>();

        public KeyStoreConfig addAlias(String alias, AliasConfig aliasConfig) {
            this.aliases.put(alias, aliasConfig);
            return this;
        }

        public Map<String, AliasConfig> getAliases() {
            return Collections.unmodifiableMap(this.aliases);
        }

        public static class AliasConfig {
            @SingleValue
            private String password;
            private String qualifier;

            public String getPassword() {
                return this.password;
            }

            public AliasConfig setPassword(String password) {
                this.password = password;
                return this;
            }

            public String getQualifier() {
                return this.qualifier;
            }

            public AliasConfig setQualifier(String qualifier) {
                this.qualifier = qualifier;
                return this;
            }
        }
    }

    public static class StoreConfig {
        private String path;
        private String password;
        private String type;
        private String provider;

        public String getPath() {
            return this.path;
        }

        public StoreConfig setPath(String path) {
            this.path = path;
            return this;
        }

        public String getPassword() {
            return this.password;
        }

        public StoreConfig setPassword(String password) {
            this.password = password;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public StoreConfig setType(String type) {
            this.type = type;
            return this;
        }

        public String getProvider() {
            return this.provider;
        }

        public StoreConfig setProvider(String provider) {
            this.provider = provider;
            return this;
        }
    }
}

