/*
 * Decompiled with CFR 0.152.
 */
package org.seedstack.seed;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;

public abstract class ClassConfiguration<T> {
    private final Class<T> targetClass;
    private final Map<String, String> map;

    private ClassConfiguration(Class<T> targetClass, Map<String, String> source) {
        this.targetClass = targetClass;
        this.map = new HashMap<String, String>(source);
    }

    public static <T> ClassConfiguration<T> of(Class<T> targetClass, Map<String, String> source) {
        return new ClassConfiguration<T>((Class)targetClass, (Map)source){};
    }

    public static <T> ClassConfiguration<T> of(Class<T> targetClass, String ... keyValuePairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < keyValuePairs.length - 1; i += 2) {
            map.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        return new ClassConfiguration<T>((Class)targetClass, map){};
    }

    public static <T> ClassConfiguration<T> empty(Class<T> targetClass) {
        return new ClassConfiguration<T>((Class)targetClass, (Map)new HashMap()){};
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public String get(String key) {
        return this.map.get(key);
    }

    public String[] getArray(String key) {
        String s = this.map.get(key);
        if (s == null) {
            return null;
        }
        return (String[])Arrays.stream(s.split(",")).map(String::trim).toArray(String[]::new);
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public Collection<String> values() {
        return Collections.unmodifiableCollection(this.map.values());
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return Collections.unmodifiableSet(this.map.entrySet());
    }

    public String getOrDefault(String key, String defaultValue) {
        return this.map.getOrDefault(key, defaultValue);
    }

    public void forEach(BiConsumer<? super String, ? super String> action) {
        this.map.forEach(action);
    }

    public Map<String, String> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public ClassConfiguration<T> merge(ClassConfiguration<T> other) {
        if (!this.targetClass.isAssignableFrom(other.targetClass)) {
            throw new IllegalArgumentException("Cannot merge class configurations: " + this.targetClass.getName() + " is not assignable to " + other.targetClass.getName());
        }
        this.map.putAll(other.map);
        this.map.values().removeIf(Objects::isNull);
        return this;
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }
}

