/*
 * Copyright © 2013-2020, The SeedStack authors <http://seedstack.org>
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
package org.seedstack.seed.diagnostic.spi;

import static java.lang.annotation.ElementType.TYPE;

import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Marks a diagnostic collector and defines its diagnostic domain.
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({TYPE})
@Inherited
public @interface DiagnosticDomain {
    /**
     * @return the diagnostic domain name.
     */
    String value();
}
