/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.xpath;

import java.io.IOException;
import java.io.Reader;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scriptella.driver.xpath.NodeVariable;
import scriptella.driver.xpath.XPathExpressionCompiler;
import scriptella.driver.xpath.XPathProviderException;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ParametersCallback;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.IOUtils;
import scriptella.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathQueryExecutor
implements ParametersCallback {
    private Node node;
    private PropertiesSubstitutor substitutor = new PropertiesSubstitutor();
    private Document document;
    private String expressionStr;
    private XPathExpressionCompiler compiler;
    private AbstractConnection.StatementCounter counter;
    private boolean returnArrays;
    ThreadLocal<Node> context;

    public XPathQueryExecutor(ThreadLocal<Node> context, Document document, Resource xpathResource, XPathExpressionCompiler compiler, AbstractConnection.StatementCounter counter, boolean returnArrays) {
        this.context = context;
        this.document = document;
        this.compiler = compiler;
        this.counter = counter;
        this.returnArrays = returnArrays;
        try {
            this.expressionStr = IOUtils.toString((Reader)xpathResource.open());
        }
        catch (IOException e) {
            throw new XPathProviderException("Unable to read XPath query content");
        }
    }

    public void execute(QueryCallback queryCallback, ParametersCallback parentParameters) {
        Node contextNode = this.context.get();
        try {
            this.substitutor.setParameters(parentParameters);
            XPathExpression xpathExpression = this.compiler.compile(this.substitutor.substitute(this.expressionStr));
            NodeList nList = (NodeList)xpathExpression.evaluate(contextNode == null ? this.document : contextNode, XPathConstants.NODESET);
            ++this.counter.statements;
            int n = nList.getLength();
            for (int i = 0; i < n; ++i) {
                this.node = nList.item(i);
                this.context.set(this.node);
                queryCallback.processRow((ParametersCallback)this);
            }
        }
        catch (XPathExpressionException e) {
            throw new XPathProviderException("Failed to evaluate XPath query", e);
        }
        finally {
            this.substitutor.setParameters(null);
            this.context.set(contextNode);
        }
    }

    public Object getParameter(String name) {
        Object result = null;
        if (name.equals("node")) {
            return new NodeVariable(this.compiler, this.node);
        }
        if (this.node instanceof Element) {
            Node item = this.node.getAttributes().getNamedItem(name);
            String[] stringArray = result = item == null ? null : StringUtils.nullsafeTrim((CharSequence)item.getNodeValue());
        }
        if (result == null) {
            NodeVariable nodeVariable = new NodeVariable(this.compiler, this.node);
            result = this.returnArrays ? nodeVariable.getStringArray("./" + name) : nodeVariable.getString("./" + name);
        }
        if (result == null && name.equals(this.node.getNodeName())) {
            result = StringUtils.nullsafeTrim((CharSequence)this.node.getTextContent());
        }
        return result == null ? this.substitutor.getParameters().getParameter(name) : result;
    }
}

