/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.xpath;

import java.util.Map;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import scriptella.driver.xpath.XPathProviderException;
import scriptella.util.LRUMap;

class XPathExpressionCompiler {
    private static final int DEFAULT_SIZE = 100;
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private Map<String, XPathExpression> cache = new LRUMap(100);

    XPathExpressionCompiler() {
    }

    public XPathExpression compile(String expression) {
        String trimmedEx = expression.trim();
        XPathExpression ex = this.cache.get(trimmedEx);
        if (ex == null) {
            try {
                ex = XPATH_FACTORY.newXPath().compile(trimmedEx);
                this.cache.put(trimmedEx, ex);
            }
            catch (XPathExpressionException e) {
                throw new XPathProviderException("Unable to compile XPath query: " + trimmedEx, e);
            }
        }
        return ex;
    }
}

