/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.xpath;

import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scriptella.driver.xpath.XPathExpressionCompiler;
import scriptella.driver.xpath.XPathProviderException;
import scriptella.util.StringUtils;

public class NodeVariable {
    public static final String NAME = "node";
    private XPathExpressionCompiler compiler;
    private Node node;

    public NodeVariable(XPathExpressionCompiler compiler, Node node) {
        this.compiler = compiler;
        this.node = node;
    }

    public String[] getStringArray(String expression) {
        try {
            XPathExpression xpathExpression = this.compiler.compile(expression);
            NodeList nList = (NodeList)xpathExpression.evaluate(this.node, XPathConstants.NODESET);
            int n = nList.getLength();
            if (n > 0) {
                String[] r = new String[n];
                for (int i = 0; i < n; ++i) {
                    r[i] = StringUtils.nullsafeTrim((CharSequence)nList.item(i).getTextContent());
                }
                return r;
            }
            return new String[0];
        }
        catch (XPathExpressionException e) {
            throw new XPathProviderException("Failed to evaluate XPath query", e);
        }
    }

    public String getString(String expression) {
        return this.getString(expression, null);
    }

    public String getString(String expression, String ifNull) {
        try {
            XPathExpression xpathExpression = this.compiler.compile(expression);
            Node foundNode = (Node)xpathExpression.evaluate(this.node, XPathConstants.NODE);
            if (foundNode == null) {
                return ifNull;
            }
            return StringUtils.nullsafeTrim((CharSequence)foundNode.getTextContent());
        }
        catch (XPathExpressionException e) {
            throw new XPathProviderException("Failed to evaluate XPath query", e);
        }
    }

    public Object get(String expression) {
        String[] strings = this.getStringArray(expression);
        if (strings == null || strings.length < 1) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        return strings;
    }

    public void remove() {
        Node parentNode = this.node.getParentNode();
        if (parentNode == null) {
            parentNode = this.node.getOwnerDocument();
        }
        parentNode.removeChild(this.node);
    }
}

