/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.text;

import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scriptella.driver.text.TextConnectionParameters;
import scriptella.expression.LineIterator;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ParametersCallback;
import scriptella.spi.QueryCallback;
import scriptella.util.ExceptionUtils;
import scriptella.util.StringUtils;

class TextQueryExecutor
implements ParametersCallback {
    private static final Logger LOG = Logger.getLogger(TextQueryExecutor.class.getName());
    private static final String COLUMN_PREFIX = "column";
    private final PropertiesSubstitutor ps;
    private Pattern[] query;
    private Matcher result;
    private TextConnectionParameters textParams;

    /*
     * Exception decompiling
     */
    public TextQueryExecutor(Reader queryReader, PropertiesSubstitutor substitutor, TextConnectionParameters textParams) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void execute(Reader reader, QueryCallback qc, AbstractConnection.StatementCounter counter) {
        int qCount = this.query.length;
        Matcher[] matchers = new Matcher[qCount];
        LineIterator it = new LineIterator(reader, this.ps, this.textParams.isTrimLines());
        for (int i = this.textParams.getSkipLines(); i > 0 && it.hasNext(); --i) {
            it.next();
        }
        while (it.hasNext()) {
            String line = it.next();
            for (int i = 0; i < qCount; ++i) {
                Matcher m = matchers[i];
                if (m == null) {
                    matchers[i] = m = this.query[i].matcher(line);
                } else {
                    m.reset(line);
                }
                if (!m.find()) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.info("Pattern matched: " + m);
                }
                this.result = m;
                qc.processRow((ParametersCallback)this);
            }
        }
        counter.statements += (long)qCount;
    }

    public Object getParameter(String name) {
        String str = name;
        if (str != null && str.startsWith(COLUMN_PREFIX)) {
            str = name.substring(COLUMN_PREFIX.length());
        }
        if (StringUtils.isDecimalInt((CharSequence)str)) {
            try {
                int ind = Integer.parseInt(str);
                if (ind >= 0 && ind <= this.result.groupCount()) {
                    String s = this.result.group(ind);
                    return this.textParams.getPropertyFormatter().parse(name, s);
                }
            }
            catch (NumberFormatException e) {
                ExceptionUtils.ignoreThrowable((Throwable)e);
            }
        }
        return this.ps.getParameters().getParameter(name);
    }
}

