/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.text;

import java.net.URL;
import scriptella.spi.ConnectionParameters;
import scriptella.text.PropertyFormatInfo;
import scriptella.text.PropertyFormatter;

public class TextConnectionParameters {
    private ConnectionParameters connectionParameters;
    private String encoding;
    private boolean flush;
    private URL url;
    private String eol;
    private int skipLines;
    private boolean trimLines;
    private PropertyFormatter propertyFormatter;

    protected TextConnectionParameters() {
        this.encoding = null;
        this.flush = false;
        this.url = null;
        this.eol = "\n";
        this.skipLines = 0;
        this.trimLines = true;
        this.propertyFormatter = new PropertyFormatter(PropertyFormatInfo.createEmpty());
    }

    public TextConnectionParameters(ConnectionParameters parameters) {
        this.connectionParameters = parameters;
        this.url = parameters.getUrl() == null ? null : parameters.getResolvedUrl();
        this.encoding = parameters.getCharsetProperty("encoding");
        this.flush = this.url == null || parameters.getBooleanProperty("flush", false);
        String eolStr = parameters.getStringProperty("eol");
        this.eol = eolStr != null ? eolStr : "\n";
        this.skipLines = parameters.getIntegerProperty("skip_lines", 0);
        this.trimLines = parameters.getBooleanProperty("trim", true);
        this.propertyFormatter = new PropertyFormatter(PropertyFormatInfo.parse((ConnectionParameters)parameters, (String)"format."));
    }

    public ConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isFlush() {
        return this.flush;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getEol() {
        return this.eol;
    }

    public int getSkipLines() {
        return this.skipLines;
    }

    public PropertyFormatter getPropertyFormatter() {
        return this.propertyFormatter;
    }

    public void setDefaultNullString(String nullString) {
        this.getPropertyFormatter().getFormatInfo().getDefaultFormat().setNullString(nullString);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }

    public void setEol(String eol) {
        this.eol = eol;
    }

    public void setSkipLines(int skipLines) {
        this.skipLines = skipLines;
    }

    public boolean isTrimLines() {
        return this.trimLines;
    }

    public void setTrimLines(boolean trimLines) {
        this.trimLines = trimLines;
    }
}

