/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.text;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import scriptella.driver.text.AbstractTextConnection;
import scriptella.driver.text.Driver;
import scriptella.driver.text.TextProviderException;
import scriptella.driver.text.TextQueryExecutor;
import scriptella.driver.text.TextScriptExecutor;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.IOUtils;

public class TextConnection
extends AbstractTextConnection {
    private TextScriptExecutor out;

    protected TextConnection() {
    }

    public TextConnection(ConnectionParameters parameters) {
        super(Driver.DIALECT, parameters);
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ProviderException {
        this.initOut();
        Reader reader = null;
        try {
            reader = scriptContent.open();
            this.out.execute(reader, parametersCallback, this.counter);
            if (this.getConnectionParameters().isFlush()) {
                this.out.flush();
            }
        }
        catch (IOException e) {
            throw new TextProviderException("Failed to produce a text file", e);
        }
        finally {
            IOUtils.closeSilently((Closeable)reader);
        }
    }

    protected void initOut() {
        if (this.out == null) {
            try {
                this.out = new TextScriptExecutor(this.newOutputWriter(), this.getConnectionParameters());
            }
            catch (IOException e) {
                throw new TextProviderException("Unable to open file " + this.getConnectionParameters().getUrl() + " for writing", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ProviderException {
        Reader q;
        Reader in;
        if (this.out != null) {
            throw new TextProviderException("Cannot query and update a Text file simultaneously");
        }
        try {
            in = this.newInputReader();
        }
        catch (IOException e) {
            throw new TextProviderException("Cannot open a text file for reading", e);
        }
        try {
            q = queryContent.open();
        }
        catch (IOException e) {
            throw new TextProviderException("Cannot read a text query", e);
        }
        try {
            new TextQueryExecutor(q, new PropertiesSubstitutor(parametersCallback), this.getConnectionParameters()).execute(in, queryCallback, this.counter);
        }
        finally {
            IOUtils.closeSilently((Closeable)q);
            IOUtils.closeSilently((Closeable)in);
        }
    }

    public void close() throws ProviderException {
        IOUtils.closeSilently((Closeable)this.out);
        this.out = null;
    }
}

