/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.text;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class ConsoleAdapters {
    public static Reader getConsoleReader(String charsetName) throws UnsupportedEncodingException {
        return charsetName == null ? new SystemInReader() : new SystemInReader(charsetName);
    }

    public static Writer getConsoleWriter(String charsetName) throws UnsupportedEncodingException {
        return charsetName == null ? new SystemOutWriter() : new SystemOutWriter(charsetName);
    }

    static class SystemOutWriter
    extends OutputStreamWriter {
        public SystemOutWriter() throws UnsupportedEncodingException {
            super(System.out);
        }

        public SystemOutWriter(String charsetName) throws UnsupportedEncodingException {
            super((OutputStream)System.out, charsetName);
        }

        public void close() throws IOException {
            this.flush();
        }
    }

    static class SystemInReader
    extends InputStreamReader {
        public SystemInReader() {
            super(System.in);
        }

        public SystemInReader(String charsetName) throws UnsupportedEncodingException {
            super(System.in, charsetName);
        }

        public void close() throws IOException {
        }
    }
}

