/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import scriptella.driver.text.ConsoleAdapters;
import scriptella.driver.text.TextConnectionParameters;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.DialectIdentifier;
import scriptella.util.IOUtils;

public abstract class AbstractTextConnection
extends AbstractConnection {
    private TextConnectionParameters connectionParameters;
    public static final String ENCODING = "encoding";
    public static final String EOL = "eol";
    public static final String TRIM = "trim";
    public static final String FLUSH = "flush";
    public static final String SKIP_LINES = "skip_lines";
    public static final String NULL_STRING = "null_string";
    public static final String FORMAT_PREFIX = "format.";

    protected AbstractTextConnection() {
        this.connectionParameters = new TextConnectionParameters();
    }

    protected AbstractTextConnection(DialectIdentifier dialectIdentifier, ConnectionParameters parameters) {
        this(dialectIdentifier, new TextConnectionParameters(parameters));
    }

    protected AbstractTextConnection(DialectIdentifier dialectIdentifier, TextConnectionParameters parameters) {
        super(dialectIdentifier, parameters.getConnectionParameters());
        this.connectionParameters = parameters;
    }

    protected Writer newOutputWriter() throws IOException {
        URL url = this.connectionParameters.getUrl();
        String encoding = this.connectionParameters.getEncoding();
        return url == null ? ConsoleAdapters.getConsoleWriter(encoding) : IOUtils.getWriter((OutputStream)IOUtils.getOutputStream((URL)url), (String)encoding);
    }

    protected Reader newInputReader() throws IOException {
        URL url = this.connectionParameters.getUrl();
        String encoding = this.connectionParameters.getEncoding();
        return url == null ? ConsoleAdapters.getConsoleReader(encoding) : IOUtils.getReader((InputStream)url.openStream(), (String)encoding);
    }

    protected TextConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }
}

