/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.spring;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import scriptella.driver.spring.EtlExecutorBean;
import scriptella.driver.spring.SpringProviderException;
import scriptella.jdbc.GenericDriver;
import scriptella.util.StringUtils;

public class Driver
extends GenericDriver {
    public Driver() {
        try {
            Class.forName("org.springframework.beans.factory.BeanFactory");
        }
        catch (ClassNotFoundException e) {
            throw new SpringProviderException("Spring not found on classpath. This driver can be used only in a Spring-managed environment, use EtlExecutorBean to run the ETL file.");
        }
    }

    protected Connection getConnection(String url, Properties props) throws SQLException {
        if (url == null) {
            throw new SpringProviderException("Name of the spring bean must be specified in an url attribute of connection element.");
        }
        try {
            BeanFactory beanFactory = EtlExecutorBean.getContextBeanFactory();
            DataSource ds = (DataSource)beanFactory.getBean(StringUtils.removePrefix((String)url, (String)"spring:"));
            return ds.getConnection();
        }
        catch (Exception e) {
            throw new SpringProviderException("A problem occured while trying to lookup a datasource with name " + url, e);
        }
    }
}

