/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.script;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import scriptella.driver.script.BindingsParametersCallback;
import scriptella.driver.script.NashornBindingsParametersCallback;
import scriptella.spi.ParametersCallback;
import scriptella.spi.QueryCallback;

class ScriptEngineWrapper
implements Closeable {
    private ScriptEngine scriptEngine;
    private Compilable compilable;
    private boolean nashornScriptEngine;

    public ScriptEngineWrapper(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
        if (scriptEngine instanceof Compilable) {
            this.compilable = (Compilable)((Object)scriptEngine);
        }
        this.nashornScriptEngine = "jdk.nashorn.api.scripting.NashornScriptEngine".equals(scriptEngine.getClass().getName());
    }

    public boolean isNashornScriptEngine() {
        return this.nashornScriptEngine;
    }

    public boolean isCompilable() {
        return this.compilable != null;
    }

    public Compilable getCompilable() {
        if (this.compilable == null) {
            throw new IllegalStateException("Engine does not support Compilable");
        }
        return this.compilable;
    }

    public BindingsParametersCallback newBindingsParametersCallback(ParametersCallback parentParameters, QueryCallback queryCallback) {
        return this.nashornScriptEngine ? new NashornBindingsParametersCallback(parentParameters, queryCallback) : new BindingsParametersCallback(parentParameters, queryCallback);
    }

    public BindingsParametersCallback newBindingsParametersCallback(ParametersCallback parentParameters) {
        return this.nashornScriptEngine ? new NashornBindingsParametersCallback(parentParameters) : new BindingsParametersCallback(parentParameters);
    }

    public void evalNoCompile(Reader reader, BindingsParametersCallback bindings) throws ScriptException {
        this.scriptEngine.eval(reader, (Bindings)bindings);
    }

    public CompiledScript compile(Reader reader) throws ScriptException {
        return this.getCompilable().compile(reader);
    }

    public void close() throws IOException {
        this.scriptEngine.getContext().getWriter().close();
    }
}

