/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.script;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import scriptella.core.RuntimeIOException;
import scriptella.driver.script.ParametersCallbackMap;
import scriptella.spi.Resource;
import scriptella.util.IOUtils;

public class MissingQueryNextCallDetector {
    private static boolean DISABLE_CHECKER = Boolean.getBoolean("scriptella.disable_missing_query_next_check");
    private static final Logger LOG = Logger.getLogger(MissingQueryNextCallDetector.class.getName());
    private static final Pattern QUERY_NEXT_CALL = Pattern.compile("query.*next", 40);
    private final ParametersCallbackMap map;
    private final Resource resource;

    public MissingQueryNextCallDetector(ParametersCallbackMap map, Resource resource) {
        this.map = map;
        this.resource = resource;
    }

    public boolean detectMissingQueryNextCall() {
        if (DISABLE_CHECKER) {
            return false;
        }
        if (!this.map.isNextCalled()) {
            try {
                String code = IOUtils.toString((Reader)this.resource.open());
                if (!QUERY_NEXT_CALL.matcher(code).find()) {
                    LOG.warning("query.next() was never called in query " + this.resource + ". Nested elements will not be executed. See querying example at http://goo.gl/LrOZS");
                    return true;
                }
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        return false;
    }
}

