/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.mail;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import scriptella.configuration.ConfigurationException;
import scriptella.driver.mail.Driver;
import scriptella.driver.mail.MailProviderException;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.CollectionUtils;
import scriptella.util.StringUtils;

public class MailConnection
extends AbstractConnection {
    private static final Logger LOG = Logger.getLogger(MailConnection.class.getName());
    public static final String TYPE = "type";
    public static final String SUBJECT = "subject";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_HTML = "html";
    private static final Pattern ADDRESS_PTR = Pattern.compile("mailto:([^\\&\\?]*)");
    private String to;
    private Session session;
    private String type;
    private String subject;

    public MailConnection(ConnectionParameters parameters) {
        super(Driver.DIALECT, parameters);
        String url = parameters.getUrl();
        if (StringUtils.isEmpty((CharSequence)url)) {
            throw new ConfigurationException("URL connection attribute is requred");
        }
        Matcher m = ADDRESS_PTR.matcher(url);
        if (!m.find()) {
            throw new ConfigurationException("URL connection attribute is not valid: " + url);
        }
        this.to = m.group(1).trim();
        if (this.to.length() == 0) {
            throw new ConfigurationException("List of email addresses cannot be empty");
        }
        if (this.to.indexOf(36) >= 0) {
            try {
                InternetAddress.parse((String)this.to, (boolean)false);
            }
            catch (AddressException e) {
                throw new ConfigurationException("URL connection attribute must represent comma separated list of email addresses and follow RFC822 syntax: " + url, (Throwable)e);
            }
        }
        Properties properties = CollectionUtils.asProperties((Map)parameters.getProperties());
        properties.putAll((Map<?, ?>)parameters.getUrlQueryMap());
        this.type = properties.getProperty(TYPE);
        if (this.type != null && !this.type.equalsIgnoreCase(TYPE_TEXT) && !this.type.equalsIgnoreCase(TYPE_HTML)) {
            throw new ConfigurationException("Type parameter value must be one of text or html");
        }
        this.subject = properties.getProperty(SUBJECT);
        if (this.subject == null) {
            LOG.fine("EMail subject is not set for connection!");
        }
        this.session = Session.getInstance((Properties)properties);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Mail session initialized");
        }
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ProviderException {
        MimeMessage mimeMessage;
        PropertiesSubstitutor ps = new PropertiesSubstitutor(parametersCallback);
        String addresslist = ps.substitute(this.to);
        try {
            mimeMessage = this.format(scriptContent.open(), ps);
            InternetAddress[] mailto = InternetAddress.parse((String)addresslist, (boolean)false);
            mimeMessage.addRecipients(Message.RecipientType.TO, (Address[])mailto);
        }
        catch (AddressException e) {
            throw new MailProviderException("URL connection attribute must represent comma separated list of email addresses and follow RFC822 syntax: " + addresslist, e);
        }
        catch (MessagingException e) {
            throw new MailProviderException("Failed to prepare message", e);
        }
        catch (IOException e) {
            throw new MailProviderException("Unable to read message text", e);
        }
        if (this.isReadonly()) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Readonly Mode - Not sending a message to " + addresslist);
            }
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Sending a message to " + addresslist);
            }
            try {
                this.send(mimeMessage);
            }
            catch (MessagingException e) {
                throw new MailProviderException("Failed to send message", e);
            }
        }
    }

    protected MimeMessage format(Reader reader, PropertiesSubstitutor ps) throws MessagingException, IOException {
        String text = ps.substitute(reader);
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom((Address)InternetAddress.getLocalAddress((Session)this.session));
        if (this.subject != null) {
            message.setSubject(ps.substitute(this.subject));
        }
        if (TYPE_HTML.equalsIgnoreCase(this.type)) {
            MimeBodyPart body = new MimeBodyPart();
            body.setContent((Object)text, "text/html");
            MimeMultipart mp = new MimeMultipart("related");
            mp.addBodyPart((BodyPart)body);
            message.setContent((Multipart)mp);
        } else {
            message.setText(text);
        }
        return message;
    }

    protected void send(MimeMessage message) throws MessagingException {
        Transport.send((Message)message);
    }

    public void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ProviderException {
        throw new MailProviderException("Queries are not supported");
    }

    public void close() throws ProviderException {
    }
}

