/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.ldap.ldif;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import scriptella.expression.LineIterator;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.ParametersCallback;
import scriptella.util.StringUtils;

public class TrackingLineIterator
extends LineIterator {
    private List<String> lines;
    private int len;

    public TrackingLineIterator(Reader in, ParametersCallback callback) {
        super(in, new PropertiesSubstitutor(callback));
    }

    protected String format(String line) {
        String s = super.format(line);
        if (this.lines != null && !StringUtils.isEmpty((CharSequence)s)) {
            this.lines.add(s);
            this.len += s.length() + 1;
        }
        return s;
    }

    public String getTrackedLines() {
        if (this.lines == null) {
            throw new IllegalStateException("Lines tracking must be switched on prior to calling this method");
        }
        StringBuilder sb = new StringBuilder(this.len);
        for (String s : this.lines) {
            sb.append(s).append('\n');
        }
        return sb.toString();
    }

    public void trackLines() {
        if (this.lines != null) {
            this.lines.clear();
        } else {
            this.lines = new ArrayList<String>();
        }
        this.len = 0;
    }
}

