/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.ldap.ldif;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import scriptella.driver.ldap.ldif.Entry;
import scriptella.driver.ldap.ldif.LdifParseException;
import scriptella.driver.ldap.ldif.Utils;
import scriptella.expression.LineIterator;
import scriptella.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifReader
implements Iterator<Entry>,
Iterable<Entry> {
    private final List<String> lines = new ArrayList<String>();
    private static final int DEFAULT_VERSION = 1;
    private int version = 1;
    private static final int ENTRY = 0;
    private static final int CHANGE = 1;
    private static final int UNKNOWN = 2;
    private final long sizeLimit;
    private static final long SIZE_LIMIT_DEFAULT = 1024000L;
    private static final int MOD_SPEC = 0;
    private static final int ATTRVAL_SPEC = 1;
    private static final int ATTRVAL_SPEC_OR_SEP = 2;
    private Entry prefetched;
    private LineIterator in;
    private boolean containsEntries;
    private boolean containsChanges;
    static final Pattern VERSION_PATTERN = Pattern.compile("[ ]*version\\:[ ]*(\\d+)[ ]*");
    static final Pattern VERSION_PATTERN_LINE1 = Pattern.compile("[ ]*version\\:[ ]*");
    static final Pattern VERSION_PATTERN_LINE2 = Pattern.compile("[ ]\\d+");

    public LdifReader(LineIterator in) {
        this(in, 1024000L);
    }

    public LdifReader(LineIterator in, long sizeLimit) {
        this.in = in;
        this.sizeLimit = sizeLimit;
        this.version = this.parseVersion();
        this.prefetched = this.parseEntry();
    }

    public LdifReader(String string) {
        this(new LineIterator((Reader)new StringReader(string)));
    }

    public int getVersion() {
        return this.version;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    private int parseChangeType(String line) {
        int operation = 0;
        String modOp = line.substring("changetype:".length() + 1).trim();
        if ("add".equalsIgnoreCase(modOp)) {
            operation = 0;
        } else if ("delete".equalsIgnoreCase(modOp)) {
            operation = 4;
        } else if ("modify".equalsIgnoreCase(modOp)) {
            operation = 1;
        } else if ("moddn".equalsIgnoreCase(modOp)) {
            operation = 2;
        } else if ("modrdn".equalsIgnoreCase(modOp)) {
            operation = 3;
        }
        return operation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseDn(String line) {
        int length;
        String dn = null;
        String lowerLine = line.toLowerCase();
        if (!lowerLine.startsWith("dn:")) {
            if (!lowerLine.startsWith("DN:")) throw new LdifParseException("No DN for entry", line);
        }
        if ((length = line.length()) == 3) {
            throw new LdifParseException("No DN for entry", line);
        }
        if (line.charAt(3) != ':') return line.substring(3).trim();
        if (length <= 4) throw new LdifParseException("No DN for entry", line);
        String trimmedLine = line.substring(4).trim();
        try {
            return new String(Utils.base64Decode(trimmedLine.toCharArray()), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new LdifParseException("Invalid base 64 encoded DN", line);
        }
    }

    private Object parseValue(String line, int pos) {
        if (line.length() > pos + 1) {
            char c = line.charAt(pos + 1);
            if (c == ':') {
                String value = line.substring(pos + 2).trim();
                return Utils.base64Decode(value.toCharArray());
            }
            if (c == '<') {
                String urlName = line.substring(pos + 2).trim();
                try {
                    return Utils.toByteArray(this.getUriStream(urlName), this.sizeLimit);
                }
                catch (IOException e) {
                    throw new LdifParseException("Failed to read \"" + urlName + "\" file content", line, e);
                }
            }
            return line.substring(pos + 1).trim();
        }
        return null;
    }

    protected InputStream getUriStream(String uri) throws IOException {
        return new URL(uri).openStream();
    }

    private Control parseControl(String line) {
        String lowerLine = line.toLowerCase().trim();
        int pos = 0;
        char[] controlValue = line.trim().toCharArray();
        int length = controlValue.length;
        if (pos > length) {
            throw new LdifParseException("Bad control, no oid", line);
        }
        int initPos = pos;
        while (Utils.isCharASCII(controlValue, pos, '.') || Utils.isDigit(controlValue, pos)) {
            ++pos;
        }
        if (pos == initPos) {
            throw new LdifParseException("Bad control, no oid", line);
        }
        String oid = lowerLine.substring(0, pos);
        boolean criticality = false;
        byte[] controlBytes = null;
        while (Utils.isCharASCII(controlValue, pos, ' ')) {
            ++pos;
        }
        int criticalPos = lowerLine.indexOf(58);
        int criticalLength = 0;
        criticalLength = criticalPos == -1 ? length - pos : criticalPos - pos;
        if (criticalLength == 4 && "true".equalsIgnoreCase(lowerLine.substring(pos, pos + 4))) {
            criticality = true;
        } else if (criticalLength == 5 && "false".equalsIgnoreCase(lowerLine.substring(pos, pos + 5))) {
            criticality = false;
        } else if (criticalLength != 0) {
            throw new LdifParseException("Bad control criticality", line);
        }
        if (criticalPos > 0) {
            if (Utils.isCharASCII(controlValue, criticalPos + 1, ':')) {
                controlBytes = Utils.base64Decode(line.substring(criticalPos + 2).toCharArray());
            } else if (!Utils.isCharASCII(controlValue, criticalPos + 1, '<')) {
                byte[] value = new byte[length - criticalPos - 1];
                for (int i = 0; i < length - criticalPos - 1; ++i) {
                    value[i] = (byte)controlValue[i + criticalPos + 1];
                }
                controlBytes = value;
            }
        }
        return new BasicControl(oid, criticality, controlBytes);
    }

    public void parseAttributeValue(Entry entry, String line) {
        int colonIndex = line.indexOf(58);
        String attributeType = line.substring(0, colonIndex);
        if (attributeType.equalsIgnoreCase("dn")) {
            throw new LdifParseException("A ldif entry should not have two DN", line);
        }
        Object attributeValue = this.parseValue(line, colonIndex);
        entry.addAttribute(attributeType, attributeValue);
    }

    private void parseModRdn(Entry entry, Iterator iter) {
        String lowerLine;
        String line;
        if (iter.hasNext()) {
            line = (String)iter.next();
            lowerLine = line.toLowerCase();
            if (!lowerLine.startsWith("newrdn::") && !lowerLine.startsWith("newrdn:")) {
                throw new LdifParseException("Bad modrdn operation", line);
            }
        } else {
            throw new LdifParseException("Bad modrdn operation, no newrdn");
        }
        int colonIndex = line.indexOf(58);
        Object attributeValue = this.parseValue(line, colonIndex);
        entry.setNewRdn(attributeValue instanceof String ? (String)attributeValue : Utils.utf8ToString((byte[])attributeValue));
        if (iter.hasNext()) {
            line = (String)iter.next();
            lowerLine = line.toLowerCase();
            if (!lowerLine.startsWith("deleteoldrdn:")) {
                throw new LdifParseException("Bad modrdn operation, no deleteoldrdn", line);
            }
        } else {
            throw new LdifParseException("Bad modrdn operation, no deleteoldrdn");
        }
        colonIndex = line.indexOf(58);
        attributeValue = this.parseValue(line, colonIndex);
        entry.setDeleteOldRdn("1".equals(attributeValue));
    }

    private void parseModify(Entry entry, Iterator iter) {
        int state = 0;
        String modified = null;
        int modification = 0;
        boolean isEmptyValue = true;
        while (iter.hasNext()) {
            String line = (String)iter.next();
            String lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("-")) {
                if (state != 2) {
                    throw new LdifParseException("Bad modify separator", line);
                }
                if (isEmptyValue) {
                    entry.addModificationItem(modification, modified, null);
                }
                state = 0;
                isEmptyValue = true;
                continue;
            }
            if (lowerLine.startsWith("add:")) {
                if (state != 0 && state != 1) {
                    throw new LdifParseException("Bad modify state", line);
                }
                modified = line.substring("add:".length()).trim();
                modification = 1;
                state = 1;
                continue;
            }
            if (lowerLine.startsWith("delete:")) {
                if (state != 0 && state != 1) {
                    throw new LdifParseException("Bad modify state", line);
                }
                modified = line.substring("delete:".length()).trim();
                modification = 3;
                state = 2;
                continue;
            }
            if (lowerLine.startsWith("replace:")) {
                if (state != 0 && state != 1) {
                    throw new LdifParseException("Bad modify state", line);
                }
                modified = line.substring("replace:".length()).trim();
                modification = 2;
                state = 2;
                continue;
            }
            if (state != 1 && state != 2) {
                throw new LdifParseException("Bad modify state", line);
            }
            int colonIndex = line.indexOf(58);
            String attributeType = line.substring(0, colonIndex);
            if (!attributeType.equals(modified)) {
                throw new LdifParseException("Bad modify attribute", line);
            }
            if (attributeType.equals("dn")) {
                throw new LdifParseException("A ldif entry should not have two DN", line);
            }
            Object attributeValue = this.parseValue(line, colonIndex);
            entry.addModificationItem(modification, attributeType, attributeValue);
            isEmptyValue = false;
            state = 2;
        }
    }

    private void parseChange(Entry entry, Iterator iter, int operation, Control control) {
        entry.setChangeType(operation);
        switch (operation) {
            case 4: {
                return;
            }
            case 0: {
                while (iter.hasNext()) {
                    String line = (String)iter.next();
                    this.parseAttributeValue(entry, line);
                }
                return;
            }
            case 1: {
                this.parseModify(entry, iter);
                return;
            }
            case 2: 
            case 3: {
                this.parseModRdn(entry, iter);
                if (iter.hasNext()) {
                    String line = (String)iter.next();
                    String lowerLine = line.toLowerCase();
                    if (lowerLine.startsWith("newsuperior:")) {
                        int colonIndex = line.indexOf(58);
                        Object attributeValue = this.parseValue(line, colonIndex);
                        entry.setNewSuperior(attributeValue instanceof String ? (String)attributeValue : Utils.utf8ToString((byte[])attributeValue));
                    } else if (operation == 2) {
                        throw new LdifParseException("Bad moddn operation, no newsuperior", line);
                    }
                } else if (operation == 2) {
                    throw new LdifParseException("Bad moddn operation, no newsuperior");
                }
                return;
            }
        }
        throw new LdifParseException("Bad operation");
    }

    private Entry parseEntry() {
        if (this.lines == null || this.lines.size() == 0) {
            return null;
        }
        String line = this.lines.get(0);
        String dn = this.parseDn(line);
        Entry entry = new Entry();
        entry.setDn(dn);
        this.lines.remove(0);
        Iterator<String> iter = this.lines.iterator();
        int type = 2;
        boolean controlSeen = false;
        boolean changeTypeSeen = false;
        int operation = 0;
        String lowerLine = null;
        Control control = null;
        while (iter.hasNext()) {
            line = iter.next();
            lowerLine = line.toLowerCase();
            if (lowerLine.startsWith("control:")) {
                if (this.containsEntries) {
                    throw new LdifParseException("No changes withing entries", line);
                }
                this.containsChanges = true;
                if (controlSeen) {
                    throw new LdifParseException("Control misplaced", line);
                }
                control = this.parseControl(line.substring("control:".length()));
                entry.setControl(control);
                continue;
            }
            if (lowerLine.startsWith("changetype:")) {
                if (this.containsEntries) {
                    throw new LdifParseException("No changes withing entries", line);
                }
                this.containsChanges = true;
                if (changeTypeSeen) {
                    throw new LdifParseException("ChangeType misplaced", line);
                }
                type = 1;
                controlSeen = true;
                operation = this.parseChangeType(line);
                this.parseChange(entry, iter, operation, control);
                changeTypeSeen = true;
                continue;
            }
            if (line.indexOf(58) > 0) {
                if (this.containsChanges) {
                    throw new LdifParseException("No entries within changes", line);
                }
                this.containsEntries = true;
                if (controlSeen || changeTypeSeen) {
                    throw new LdifParseException("AttributeType misplaced", line);
                }
                this.parseAttributeValue(entry, line);
                type = 0;
                continue;
            }
            throw new LdifParseException("Bad attribute", line);
        }
        if (type == 1) {
            entry.setChangeType(operation);
        }
        return entry;
    }

    private int parseVersion() {
        this.readLines();
        if (this.lines.size() == 0) {
            return 1;
        }
        String line = this.lines.get(0);
        Matcher versionMatcher = VERSION_PATTERN.matcher(line);
        String versionStr = null;
        if (versionMatcher.matches()) {
            versionStr = versionMatcher.group(1);
            this.lines.remove(0);
        } else {
            versionMatcher = VERSION_PATTERN_LINE1.matcher(line);
            if (versionMatcher.matches()) {
                this.lines.remove(0);
                if (!this.lines.isEmpty()) {
                    versionMatcher = VERSION_PATTERN_LINE2.matcher(this.lines.get(1));
                    if (versionMatcher.matches()) {
                        versionStr = versionMatcher.group(1);
                    }
                    this.lines.remove(0);
                }
            }
        }
        if (versionStr != null) {
            try {
                return Integer.parseInt(versionStr.trim());
            }
            catch (NumberFormatException e) {
                throw new LdifParseException("Invalid LDIF version number " + versionStr, line);
            }
        }
        return 1;
    }

    private void readLines() {
        boolean insideComment = true;
        boolean isFirstLine = true;
        this.lines.clear();
        StringBuilder sb = new StringBuilder(128);
        block4: while (this.in.hasNext()) {
            String line = this.in.next();
            if (StringUtils.isAsciiWhitespacesOnly((CharSequence)line)) {
                if (isFirstLine) continue;
                insideComment = false;
                if (!this.lines.isEmpty()) break;
                continue;
            }
            isFirstLine = false;
            switch (line.charAt(0)) {
                case '#': {
                    insideComment = true;
                    continue block4;
                }
                case ' ': {
                    if (insideComment) continue block4;
                    if (sb.length() == 0) {
                        throw new LdifParseException("Ldif Parsing error: Cannot have an empty continuation line");
                    }
                    sb.append(line.substring(1));
                    insideComment = false;
                    continue block4;
                }
            }
            if (sb.length() != 0) {
                this.lines.add(sb.toString());
            }
            sb = new StringBuilder(line);
            insideComment = false;
        }
        if (sb.length() != 0) {
            this.lines.add(sb.toString());
        }
    }

    @Override
    public Entry next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No LDIF entries to read. Use hasNext().");
        }
        Entry res = this.prefetched;
        this.prefetched = null;
        return res;
    }

    @Override
    public boolean hasNext() {
        if (this.prefetched == null) {
            this.readLines();
            this.prefetched = this.parseEntry();
        }
        return null != this.prefetched;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this;
    }

    List<Entry> asList() {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        while (this.hasNext()) {
            Entry entry = this.next();
            entries.add(entry);
        }
        return entries;
    }

    public boolean containsEntries() {
        return this.containsEntries;
    }
}

