/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.ldap;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import scriptella.driver.ldap.LdapConnection;
import scriptella.driver.ldap.LdapProviderException;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.ParametersCallback;
import scriptella.spi.QueryCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFilterQuery
implements ParametersCallback {
    private static final Logger LOG = Logger.getLogger(SearchFilterQuery.class.getName());
    private QueryCallback queryCallback;
    private SearchResult result;
    private final LdapConnection connection;
    private final PropertiesSubstitutor substitutor;

    public SearchFilterQuery(LdapConnection connection, ParametersCallback parameters, QueryCallback queryCallback) {
        this.queryCallback = queryCallback;
        this.connection = connection;
        this.substitutor = new PropertiesSubstitutor(parameters);
    }

    public Object getParameter(String name) {
        Attributes attributes = this.result.getAttributes();
        Attribute attribute = attributes.get(name);
        if (attribute != null) {
            try {
                return attribute.get();
            }
            catch (NamingException e) {
                throw new LdapProviderException("Failed to get attribute " + name + " value", e);
            }
        }
        if ("dn".equalsIgnoreCase(name)) {
            return this.result.getNameInNamespace();
        }
        return this.substitutor.getParameters().getParameter(name);
    }

    public void execute(String filter) {
        String sFilter = this.substitutor.substitute(filter);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Running a query for search filter " + sFilter);
        }
        try {
            this.iterate(this.query(this.connection, sFilter));
        }
        catch (NamingException e) {
            throw new LdapProviderException("Failed to execute query", e);
        }
        catch (LdapProviderException e2) {
            if (e2.getErrorStatement() != null) {
                e2.setErrorStatement(sFilter);
            }
            throw e2;
        }
    }

    private void iterate(NamingEnumeration<SearchResult> ne) {
        try {
            while (ne.hasMoreElements()) {
                this.result = (SearchResult)ne.nextElement();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Processing search result: " + this.result);
                }
                this.queryCallback.processRow((ParametersCallback)this);
            }
        }
        finally {
            try {
                ne.close();
            }
            catch (Exception e) {
                LOG.log(Level.FINE, "Failed to close naming enumeration", e);
            }
        }
    }

    protected NamingEnumeration<SearchResult> query(LdapConnection connection, String filter) throws NamingException {
        NamingEnumeration<SearchResult> en = connection.getCtx().search(connection.getBaseDn(), filter, connection.getSearchControls());
        ++connection.getStatementCounter().statements;
        return en;
    }
}

