/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.ldap;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.CompoundName;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import scriptella.core.EtlCancelledException;
import scriptella.driver.ldap.LdapConnection;
import scriptella.driver.ldap.LdapProviderException;
import scriptella.driver.ldap.ldif.Entry;
import scriptella.driver.ldap.ldif.LdifParseException;
import scriptella.driver.ldap.ldif.LdifReader;
import scriptella.driver.ldap.ldif.TrackingLineIterator;
import scriptella.expression.LineIterator;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ParametersCallback;

public class LdifScript {
    private static final Logger LOG = Logger.getLogger(LdifScript.class.getName());
    static final Properties DN_SYNTAX = new Properties();
    private final LdapConnection connection;

    public LdifScript(LdapConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        this.connection = connection;
    }

    public void execute(Reader reader, DirContext ctx, ParametersCallback parameters) throws LdapProviderException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader cannot be null");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("DirContext cannot be null");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        TrackingLineIterator in = new TrackingLineIterator(reader, parameters);
        AbstractConnection.StatementCounter counter = this.connection.getStatementCounter();
        try {
            in.trackLines();
            LdifIterator it = this.newLdifIterator(in);
            while (it.hasNext()) {
                EtlCancelledException.checkEtlCancelled();
                Entry e = it.next();
                if (this.isReadonly()) {
                    LOG.info("Readonly Mode - " + e + " has been skipped.");
                } else {
                    LdifScript.modify(ctx, e);
                }
                ++counter.statements;
                in.trackLines();
            }
        }
        catch (LdifParseException e) {
            if (e.getErrorStatement() == null) {
                e.setErrorStatement(in.getTrackedLines());
            }
            throw e;
        }
        catch (NamingException e) {
            LdapProviderException ex = new LdapProviderException("Failed to execute LDIF entry", e);
            ex.setErrorStatement(in.getTrackedLines());
            throw ex;
        }
    }

    static void modify(DirContext ctx, Entry e) throws NamingException {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Processing " + e);
        }
        Attributes atts = e.getAttributes();
        String rootDn = ctx.getNameInNamespace();
        if (atts != null) {
            ctx.createSubcontext(LdifScript.getRelativeDN(rootDn, e.getDn()), e.getAttributes());
        } else if (e.isChangeDelete()) {
            ctx.destroySubcontext(LdifScript.getRelativeDN(rootDn, e.getDn()));
        } else if (e.isChangeModDn() || e.isChangeModRdn()) {
            Name newRdn;
            if (e.getNewSuperior() != null) {
                newRdn = LdifScript.getRelativeDN(rootDn, e.getNewSuperior());
            } else {
                newRdn = LdifScript.getRelativeDN(rootDn, e.getDn());
                newRdn.remove(newRdn.size() - 1);
            }
            newRdn.add(e.getNewRdn());
            ctx.addToEnvironment("java.naming.ldap.deleteRDN", String.valueOf(e.isDeleteOldRdn()));
            ctx.rename(LdifScript.getRelativeDN(rootDn, e.getDn()), newRdn);
            ctx.removeFromEnvironment("java.naming.ldap.deleteRDN");
        } else {
            List<ModificationItem> items = e.getModificationItems();
            ctx.modifyAttributes(LdifScript.getRelativeDN(rootDn, e.getDn()), items.toArray(new ModificationItem[items.size()]));
        }
    }

    static Name getRelativeDN(String rootDn, String dn) throws NamingException {
        CompoundName entry = new CompoundName(dn, DN_SYNTAX);
        CompoundName root = new CompoundName(rootDn, DN_SYNTAX);
        if (!entry.startsWith(root)) {
            throw new NamingException("Dn " + dn + " is not from root DN " + rootDn);
        }
        return entry.getSuffix(root.size());
    }

    protected Long getMaxFileLength() {
        return this.connection == null ? null : this.connection.getMaxFileLength();
    }

    protected boolean isReadonly() {
        return this.connection != null && this.connection.isReadonly();
    }

    private LdifIterator newLdifIterator(LineIterator in) {
        Long mx = this.getMaxFileLength();
        return mx == null ? new LdifIterator(in) : new LdifIterator(in, mx);
    }

    static {
        DN_SYNTAX.setProperty("jndi.syntax.direction", "right_to_left");
        DN_SYNTAX.setProperty("jndi.syntax.separator", ",");
        DN_SYNTAX.setProperty("jndi.syntax.ignorecase", "true");
        DN_SYNTAX.setProperty("jndi.syntax.trimblanks", "true");
    }

    private class LdifIterator
    extends LdifReader {
        public LdifIterator(LineIterator in, long sizeLimit) {
            super(in, sizeLimit);
        }

        public LdifIterator(LineIterator in) {
            super(in);
        }

        protected InputStream getUriStream(String uri) throws IOException {
            return LdifScript.this.connection.getDriversContext().resolve(uri).openStream();
        }
    }
}

