/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.ldap;

import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import scriptella.driver.ldap.Driver;
import scriptella.driver.ldap.LdapProviderException;
import scriptella.driver.ldap.LdifScript;
import scriptella.driver.ldap.SearchFilterQuery;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.DriverContext;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapConnection
extends AbstractConnection {
    private static final Logger LOG = Logger.getLogger(LdapConnection.class.getName());
    private DirContext ctx;
    private final SearchControls searchControls;
    private final Long maxFileLength;
    private final String baseDn;
    private final DriverContext driverContext;
    public static final String SEARCH_SCOPE_KEY = "search.scope";
    public static final String SEARCH_BASEDN_KEY = "search.basedn";
    public static final String SEARCH_TIMELIMIT_KEY = "search.timelimit";
    public static final String SEARCH_COUNTLIMIT_KEY = "search.countlimit";
    public static final String FILE_MAXLENGTH_KEY = "file.maxlength";

    public LdapConnection() {
        this.searchControls = null;
        this.maxFileLength = null;
        this.baseDn = null;
        this.driverContext = null;
    }

    public LdapConnection(ConnectionParameters parameters) {
        super(Driver.DIALECT, parameters);
        Number mfl;
        Integer cl;
        String baseDn;
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        if (parameters.getUrl() == null) {
            throw new LdapProviderException("Connection URL is required");
        }
        env.put("java.naming.provider.url", parameters.getUrl());
        if (parameters.getUser() != null) {
            env.put("java.naming.security.principal", parameters.getUser());
        }
        if (parameters.getPassword() != null) {
            env.put("java.naming.security.credentials", parameters.getPassword());
        }
        env.putAll(parameters.getProperties());
        this.searchControls = new SearchControls();
        String scope = parameters.getStringProperty(SEARCH_SCOPE_KEY);
        if (scope != null) {
            if ("object".equalsIgnoreCase(scope)) {
                this.searchControls.setSearchScope(0);
            } else if ("onelevel".equalsIgnoreCase(scope)) {
                this.searchControls.setSearchScope(1);
            } else if ("subtree".equalsIgnoreCase(scope)) {
                this.searchControls.setSearchScope(2);
            } else {
                throw new LdapProviderException("Unsupported search.scope=" + scope);
            }
        }
        this.baseDn = (baseDn = parameters.getStringProperty(SEARCH_BASEDN_KEY)) == null ? "" : baseDn;
        Integer tl = parameters.getIntegerProperty(SEARCH_TIMELIMIT_KEY);
        if (tl != null) {
            this.searchControls.setTimeLimit(tl);
        }
        if ((cl = parameters.getIntegerProperty(SEARCH_COUNTLIMIT_KEY)) != null) {
            this.searchControls.setCountLimit(cl.intValue());
        }
        this.maxFileLength = (mfl = parameters.getNumberProperty(FILE_MAXLENGTH_KEY, null)) == null ? null : Long.valueOf(mfl.longValue());
        this.driverContext = parameters.getContext();
        this.initializeContext(env);
    }

    protected void initializeContext(Hashtable<String, Object> env) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating initial context, environment: " + env);
        }
        try {
            this.ctx = new InitialDirContext(env);
        }
        catch (NamingException e) {
            throw new LdapProviderException("Unable to establish directory connection", e);
        }
    }

    DirContext getCtx() {
        return this.ctx;
    }

    SearchControls getSearchControls() {
        return this.searchControls;
    }

    Long getMaxFileLength() {
        return this.maxFileLength;
    }

    DriverContext getDriversContext() {
        return this.driverContext;
    }

    String getBaseDn() {
        return this.baseDn;
    }

    AbstractConnection.StatementCounter getStatementCounter() {
        return this.counter;
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ProviderException {
        Reader in;
        try {
            in = scriptContent.open();
        }
        catch (IOException e) {
            throw new LdapProviderException("Failed to read script", e);
        }
        new LdifScript(this).execute(in, this.ctx, parametersCallback);
    }

    public void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ProviderException {
        String filter;
        try {
            filter = IOUtils.toString((Reader)queryContent.open()).trim();
        }
        catch (IOException e) {
            throw new LdapProviderException("Failed to read query filter", e);
        }
        SearchFilterQuery q = new SearchFilterQuery(this, parametersCallback, queryCallback);
        q.execute(filter);
    }

    public void close() throws ProviderException {
        if (this.ctx != null) {
            try {
                this.ctx.close();
                this.ctx = null;
            }
            catch (NamingException e) {
                throw new LdapProviderException("Unable to close directory context", e);
            }
        }
    }
}

