/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.jndi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import scriptella.driver.jndi.JndiProviderException;
import scriptella.jdbc.GenericDriver;
import scriptella.util.StringUtils;

public class Driver
extends GenericDriver {
    protected Connection getConnection(String url, Properties props) throws SQLException {
        if (url == null) {
            throw new JndiProviderException("JNDI name must be specified in an url attribute of connection element.");
        }
        try {
            InitialContext ctx = new InitialContext(props);
            DataSource ds = (DataSource)ctx.lookup(StringUtils.removePrefix((String)url, (String)"jndi:"));
            return ds.getConnection();
        }
        catch (NamingException e) {
            throw new JndiProviderException("A problem occured while trying to lookup a datasource with name " + url, e);
        }
    }
}

