/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.jexl;

import java.io.IOException;
import java.io.Reader;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.Script;
import scriptella.driver.jexl.Driver;
import scriptella.driver.jexl.JexlContextMap;
import scriptella.driver.jexl.JexlProviderException;
import scriptella.driver.script.MissingQueryNextCallDetector;
import scriptella.driver.script.ParametersCallbackMap;
import scriptella.expression.JexlExpression;
import scriptella.spi.AbstractConnection;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.IOUtils;

public class JexlConnection
extends AbstractConnection {
    private Map<Resource, Script> cache = new IdentityHashMap<Resource, Script>();
    private static final JexlEngine jexlEngine = JexlExpression.newJexlEngine();

    public JexlConnection(ConnectionParameters parameters) {
        super(Driver.DIALECT, parameters);
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ProviderException {
        this.run(scriptContent, new JexlContextMap(new ParametersCallbackMap(parametersCallback)));
    }

    public void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ProviderException {
        ParametersCallbackMap parametersMap = new ParametersCallbackMap(parametersCallback, queryCallback);
        MissingQueryNextCallDetector detector = new MissingQueryNextCallDetector(parametersMap, queryContent);
        this.run(queryContent, new JexlContextMap(parametersMap));
        detector.detectMissingQueryNextCall();
    }

    private void run(Resource resource, JexlContextMap ctx) {
        Script script = this.cache.get(resource);
        if (script == null) {
            String s;
            try {
                s = IOUtils.toString((Reader)resource.open());
            }
            catch (IOException e) {
                throw new JexlProviderException("Unable to open resource", e);
            }
            try {
                script = jexlEngine.createScript(s);
                this.cache.put(resource, script);
            }
            catch (Exception e) {
                throw new JexlProviderException("Failed to compile JEXL script", e);
            }
        }
        try {
            script.execute((JexlContext)ctx);
        }
        catch (Exception e) {
            throw new JexlProviderException("Failed to execute JEXL script", e);
        }
    }

    public void close() throws ProviderException {
        this.cache = null;
    }
}

