/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.csv.opencsv;

import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;

public class CSVWriter
implements Closeable {
    private Writer writer;
    private char separator;
    private char quotechar;
    private char escapechar;
    private String lineEnd;
    public static final char DEFAULT_ESCAPE_CHARACTER = '\"';
    public static final char NO_ESCAPE_CHARACTER = '\u0000';
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final char NO_QUOTE_CHARACTER = '\u0000';
    public static final String DEFAULT_LINE_END = "\n";

    public CSVWriter(Writer writer) {
        this(writer, ',');
    }

    public CSVWriter(Writer writer, char separator) {
        this(writer, separator, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar) {
        this(writer, separator, quotechar, '\"');
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar) {
        this(writer, separator, quotechar, escapechar, DEFAULT_LINE_END);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, String lineEnd) {
        this(writer, separator, quotechar, '\"', lineEnd);
    }

    public CSVWriter(Writer writer, char separator, char quotechar, char escapechar, String lineEnd) {
        this.writer = writer;
        this.separator = separator;
        this.quotechar = quotechar;
        this.escapechar = escapechar;
        this.lineEnd = lineEnd;
    }

    public void writeNext(String[] nextLine, boolean quoteall) throws IOException {
        int colCount = nextLine.length;
        for (int i = 0; i < colCount; ++i) {
            boolean hasSpecialCharacters;
            String nextElement;
            if (i != 0) {
                this.writer.append(this.separator);
            }
            if ((nextElement = nextLine[i]) == null) continue;
            boolean bl = hasSpecialCharacters = nextElement.indexOf(this.quotechar) != -1 || nextElement.indexOf(this.escapechar) != -1 || nextElement.indexOf(this.separator) != -1 || nextElement.contains(this.lineEnd) || nextElement.contains("\r");
            if ((quoteall || hasSpecialCharacters) && this.quotechar != '\u0000') {
                this.writer.append(this.quotechar);
            }
            if (!hasSpecialCharacters) {
                this.writer.append(nextElement);
            } else {
                int length = nextElement.length();
                for (int j = 0; j < length; ++j) {
                    char nextChar = nextElement.charAt(j);
                    if (this.escapechar != '\u0000' && (nextChar == this.quotechar || nextChar == this.escapechar)) {
                        this.writer.append(this.escapechar).append(nextChar);
                        continue;
                    }
                    this.writer.append(nextChar);
                }
            }
            if (!quoteall && !hasSpecialCharacters || this.quotechar == '\u0000') continue;
            this.writer.append(this.quotechar);
        }
        this.writer.append(this.lineEnd);
    }

    public void close() throws IOException {
        this.writer.flush();
        this.writer.close();
    }
}

