/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.csv;

import scriptella.driver.text.TextConnectionParameters;
import scriptella.spi.ConnectionParameters;

public class CsvConnectionParameters
extends TextConnectionParameters {
    public static final char DEFAULT_SEPARATOR = ',';
    public static final char DEFAULT_QUERY = '\"';
    public static final char DEFAULT_ESCAPE = '\"';
    public static final boolean DEFAULT_HEADERS = true;
    public static final boolean DEFAULT_QUOTEALL = true;
    protected char separator;
    protected char quote;
    protected char escape;
    protected boolean headers;
    protected boolean quoteall;

    protected CsvConnectionParameters() {
        this.separator = (char)44;
        this.quote = (char)34;
        this.escape = (char)34;
        this.headers = true;
        this.quoteall = true;
    }

    public CsvConnectionParameters(ConnectionParameters parameters) {
        super(parameters);
        String sep = parameters.getStringProperty("separator");
        this.separator = sep != null && sep.length() > 0 ? sep.charAt(0) : (char)44;
        String q = parameters.getStringProperty("quote");
        this.quote = q == null ? (char)34 : (q.length() > 0 ? q.charAt(0) : (char)'\u0000');
        String e = parameters.getStringProperty("escape");
        this.escape = e == null ? (char)34 : (e.length() > 0 ? e.charAt(0) : (char)'\u0000');
        this.headers = parameters.getBooleanProperty("headers", true);
        this.quoteall = parameters.getBooleanProperty("quoteall", true);
    }

    public char getSeparator() {
        return this.separator;
    }

    public char getQuote() {
        return this.quote;
    }

    public char getEscape() {
        return this.escape;
    }

    public boolean isHeaders() {
        return this.headers;
    }

    public boolean isQuoteall() {
        return this.quoteall;
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }

    public void setEscape(char escape) {
        this.escape = escape;
    }

    public void setHeaders(boolean headers) {
        this.headers = headers;
    }

    public void setQuoteall(boolean quoteall) {
        this.quoteall = quoteall;
    }
}

