/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.csv;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import scriptella.core.EtlCancelledException;
import scriptella.driver.csv.CsvConnectionParameters;
import scriptella.driver.csv.CsvProviderException;
import scriptella.driver.csv.CsvQuery;
import scriptella.driver.csv.Driver;
import scriptella.driver.csv.opencsv.CSVReader;
import scriptella.driver.csv.opencsv.CSVWriter;
import scriptella.driver.text.AbstractTextConnection;
import scriptella.expression.PropertiesSubstitutor;
import scriptella.spi.ConnectionParameters;
import scriptella.spi.ParametersCallback;
import scriptella.spi.ProviderException;
import scriptella.spi.QueryCallback;
import scriptella.spi.Resource;
import scriptella.util.StringUtils;

public class CsvConnection
extends AbstractTextConnection {
    protected static final Logger LOG = Logger.getLogger(CsvConnection.class.getName());
    private CSVWriter out;
    private Writer writer;
    public static final String SEPARATOR = "separator";
    public static final String QUOTE = "quote";
    public static final String ESCAPE = "escape";
    public static final String HEADERS = "headers";
    public static final String QUOTEALL = "quoteall";

    public CsvConnection(ConnectionParameters parameters) {
        super(Driver.DIALECT, new CsvConnectionParameters(parameters));
    }

    public void executeScript(Resource scriptContent, ParametersCallback parametersCallback) throws ProviderException {
        CSVReader r;
        try {
            r = this.getScriptingElementReader(scriptContent);
        }
        catch (IOException e) {
            throw new CsvProviderException("Cannot open CSV script content.", e);
        }
        try {
            this.executeScript(r, parametersCallback);
        }
        catch (IOException e) {
            throw new CsvProviderException("Cannot output CSV script.", e);
        }
    }

    void executeScript(CSVReader reader, ParametersCallback parametersCallback) throws IOException {
        Object[] row;
        CSVWriter out = this.getOut();
        CsvConnectionParameters csvParams = this.getConnectionParameters();
        ParametersCallback formattingCallback = csvParams.getPropertyFormatter().format(parametersCallback);
        boolean trimLines = csvParams.isTrimLines();
        boolean quoteall = csvParams.isQuoteall();
        PropertiesSubstitutor ps = new PropertiesSubstitutor(formattingCallback);
        while ((row = reader.readNext()) != null) {
            EtlCancelledException.checkEtlCancelled();
            for (int i = 0; i < row.length; ++i) {
                String field = row[i];
                if (field == null) continue;
                if (trimLines) {
                    field = field.trim();
                }
                row[i] = ps.substitute(field);
            }
            if (row.length == 1 && StringUtils.isAsciiWhitespacesOnly((CharSequence)row[0])) continue;
            if (this.isReadonly()) {
                if (!LOG.isLoggable(Level.INFO)) continue;
                LOG.info("Readonly Mode - " + Arrays.deepToString(row) + " has been skipped.");
                continue;
            }
            try {
                out.writeNext((String[])row, quoteall);
                ++this.counter.statements;
            }
            catch (Exception e) {
                throw new CsvProviderException("Failed to write CSV row ", e);
            }
        }
        if (csvParams.isFlush()) {
            this.writer.flush();
        }
    }

    public void executeQuery(Resource queryContent, ParametersCallback parametersCallback, QueryCallback queryCallback) throws ProviderException {
        CSVReader queryContentReader;
        if (this.out != null) {
            throw new CsvProviderException("Cannot query and update a CSV file simultaneously.");
        }
        try {
            queryContentReader = this.getScriptingElementReader(queryContent);
        }
        catch (IOException e) {
            throw new CsvProviderException("Failed to read query content", e);
        }
        CsvConnectionParameters csvParams = this.getConnectionParameters();
        try {
            CsvQuery q = this.newCsvQuery(queryContentReader, new PropertiesSubstitutor(parametersCallback));
            CSVReader inputCSVContentReader = new CSVReader(this.newInputReader(), csvParams.getSeparator(), csvParams.getQuote(), csvParams.getSkipLines());
            q.execute(inputCSVContentReader, queryCallback, this.counter);
        }
        catch (IOException e) {
            throw new CsvProviderException("Failed to open CSV file " + csvParams.getUrl() + " for input", e);
        }
    }

    private CSVReader getScriptingElementReader(Resource content) throws IOException {
        return new CSVReader(content.open());
    }

    protected CSVWriter getOut() {
        if (this.out == null) {
            CsvConnectionParameters csvParams = this.getConnectionParameters();
            try {
                this.writer = this.newOutputWriter();
                this.out = new CSVWriter(this.writer, csvParams.getSeparator(), csvParams.getQuote(), csvParams.getEscape(), csvParams.getEol());
            }
            catch (IOException e) {
                throw new CsvProviderException("Unable to open URL " + csvParams.getUrl() + " for output", e);
            }
        }
        return this.out;
    }

    protected CsvQuery newCsvQuery(CSVReader csvReader, PropertiesSubstitutor ps) {
        return new CsvQuery(csvReader, ps, this.getConnectionParameters());
    }

    public void close() throws ProviderException {
        if (this.out != null) {
            try {
                this.out.close();
                this.writer = null;
            }
            catch (Exception e) {
                LOG.log(Level.INFO, "A problem occured while trying to close CSV writer", e);
            }
        }
    }

    protected CsvConnectionParameters getConnectionParameters() {
        return (CsvConnectionParameters)super.getConnectionParameters();
    }
}

