/*
 * Decompiled with CFR 0.152.
 */
package scriptella.driver.auto;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import scriptella.configuration.ConfigurationException;
import scriptella.core.DriverFactory;
import scriptella.jdbc.GenericDriver;
import scriptella.spi.AbstractScriptellaDriver;
import scriptella.spi.Connection;
import scriptella.spi.ConnectionParameters;
import scriptella.util.CollectionUtils;
import scriptella.util.StringUtils;

public class Driver
extends AbstractScriptellaDriver {
    private static Logger LOG = Logger.getLogger(Driver.class.getName());
    private static final Map<String, String> MAPPINGS = new HashMap<String, String>();
    private static final String AUTO_URL_PROPERTIES = "scriptella/driver/auto/url.properties";

    public Connection connect(ConnectionParameters connectionParameters) throws ConfigurationException {
        String u = connectionParameters.getUrl();
        if (StringUtils.isEmpty((CharSequence)u)) {
            throw new ConfigurationException("url connection parameter is required");
        }
        u = u.toLowerCase();
        for (Map.Entry<String, String> entry : MAPPINGS.entrySet()) {
            String pattern = entry.getKey().toLowerCase();
            String driver = entry.getValue();
            if (!u.startsWith(pattern)) continue;
            return this.getConnection(driver, connectionParameters);
        }
        if (u.startsWith("jdbc:")) {
            return this.getConnection(GenericDriver.class.getName(), connectionParameters);
        }
        throw new ConfigurationException("Unable to automatically discover driver for url " + connectionParameters.getUrl() + ". Please explicitly specify a \"driver\" connection attribute.");
    }

    protected Connection getConnection(String driver, ConnectionParameters connectionParameters) {
        try {
            Connection c = DriverFactory.getDriver((String)driver, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).connect(connectionParameters);
            LOG.info("Using " + driver + " driver for url " + connectionParameters.getUrl());
            return c;
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Unable to initialize driver " + driver, (Throwable)e);
        }
    }

    static {
        try {
            ArrayList<URL> resources = Collections.list(Driver.class.getClassLoader().getResources(AUTO_URL_PROPERTIES));
            LOG.fine("Loading autodiscovery properties from " + resources);
            for (URL resource : resources) {
                Properties p = new Properties();
                p.load(resource.openStream());
                MAPPINGS.putAll(CollectionUtils.asMap((Properties)p));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to initialize autodiscovery mappings", e);
        }
    }
}

