/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.ImportDecl;
import org.scribble.model.ModelObject;
import org.scribble.model.Module;
import org.scribble.validation.rules.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;

public class ImportDeclValidationRule
implements ValidationRule {
    public void validate(ModuleContext context, ModelObject mobj, IssueLogger logger) {
        ImportDecl elem = (ImportDecl)mobj;
        if (elem.getModuleName() != null) {
            Module importedModule = context.importModule(elem.getModuleName());
            if (importedModule == null) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("NOT_FOUND_MODULE"), elem.getModuleName()), (ModelObject)elem);
            } else if (elem.getMemberName() != null) {
                ModelObject imported = context.getMember(elem.getModuleName(), elem.getMemberName());
                if (imported == null) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("NOT_FOUND_MEMBER"), elem.getMemberName(), elem.getModuleName()), (ModelObject)elem);
                } else if (elem.getAlias() != null && context.getMember(elem.getAlias()) != imported) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("EXISTS_ALIAS"), elem.getAlias()), (ModelObject)elem);
                }
            }
        } else {
            logger.error(ValidationMessages.getMessage("NO_MODULE"), (ModelObject)elem);
        }
    }
}

