/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.validation.rules;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.ModelObject;
import org.scribble.model.ProtocolDecl;
import org.scribble.model.Role;
import org.scribble.model.global.GMessageTransfer;
import org.scribble.validation.rules.ValidationMessages;
import org.scribble.validation.rules.ValidationRule;
import org.scribble.validation.rules.ValidationRuleFactory;

public class GMessageTransferValidationRule
implements ValidationRule {
    public void validate(ModuleContext context, ModelObject mobj, IssueLogger logger) {
        ProtocolDecl pd;
        ValidationRule rule;
        GMessageTransfer elem = (GMessageTransfer)mobj;
        if (elem.getMessage() != null && (rule = ValidationRuleFactory.getValidationRule((ModelObject)elem.getMessage())) != null) {
            rule.validate(context, (ModelObject)elem.getMessage(), logger);
        }
        if ((pd = (ProtocolDecl)elem.getParent(ProtocolDecl.class)) != null) {
            if (elem.getFromRole() != null && pd.getRoleDeclaration(elem.getFromRole().getName()) == null) {
                logger.error(MessageFormat.format(ValidationMessages.getMessage("UNKNOWN_ROLE"), elem.getFromRole().getName()), (ModelObject)elem.getFromRole());
            }
            ArrayList<String> toRoles = new ArrayList<String>();
            for (Role r : elem.getToRoles()) {
                if (toRoles.contains(r.getName())) {
                    logger.error(MessageFormat.format(ValidationMessages.getMessage("ROLE_NOT_DISTINCT"), r.getName()), (ModelObject)elem);
                } else {
                    toRoles.add(r.getName());
                }
                if (pd.getRoleDeclaration(r.getName()) != null) continue;
                logger.error(MessageFormat.format(ValidationMessages.getMessage("UNKNOWN_ROLE"), r.getName()), (ModelObject)r);
            }
        }
    }
}

