/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.projection.rules;

import java.util.HashMap;
import java.util.Map;
import org.scribble.model.ModelObject;
import org.scribble.model.Module;
import org.scribble.model.global.GBlock;
import org.scribble.model.global.GChoice;
import org.scribble.model.global.GContinue;
import org.scribble.model.global.GDo;
import org.scribble.model.global.GInterruptible;
import org.scribble.model.global.GMessageTransfer;
import org.scribble.model.global.GParallel;
import org.scribble.model.global.GProtocolDefinition;
import org.scribble.model.global.GProtocolInstance;
import org.scribble.model.global.GRecursion;
import org.scribble.projection.rules.GBlockProjectionRule;
import org.scribble.projection.rules.GChoiceProjectionRule;
import org.scribble.projection.rules.GContinueProjectionRule;
import org.scribble.projection.rules.GDoProjectionRule;
import org.scribble.projection.rules.GInterruptibleProjectionRule;
import org.scribble.projection.rules.GMessageTransferProjectionRule;
import org.scribble.projection.rules.GParallelProjectionRule;
import org.scribble.projection.rules.GProtocolDefinitionProjectionRule;
import org.scribble.projection.rules.GProtocolInstanceProjectionRule;
import org.scribble.projection.rules.GRecursionProjectionRule;
import org.scribble.projection.rules.ModuleProjectionRule;
import org.scribble.projection.rules.ProjectionRule;

public class ProjectionRuleFactory {
    private static Map<Class<?>, ProjectionRule> _rules = new HashMap();

    public static ProjectionRule getProjectionRule(ModelObject mobj) {
        return _rules.get(mobj.getClass());
    }

    static {
        _rules.put(GBlock.class, new GBlockProjectionRule());
        _rules.put(GDo.class, new GDoProjectionRule());
        _rules.put(GChoice.class, new GChoiceProjectionRule());
        _rules.put(GContinue.class, new GContinueProjectionRule());
        _rules.put(GInterruptible.class, new GInterruptibleProjectionRule());
        _rules.put(GMessageTransfer.class, new GMessageTransferProjectionRule());
        _rules.put(GParallel.class, new GParallelProjectionRule());
        _rules.put(GProtocolDefinition.class, new GProtocolDefinitionProjectionRule());
        _rules.put(GProtocolInstance.class, new GProtocolInstanceProjectionRule());
        _rules.put(GRecursion.class, new GRecursionProjectionRule());
        _rules.put(Module.class, new ModuleProjectionRule());
    }
}

