/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.projection.rules;

import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.Argument;
import org.scribble.model.ModelObject;
import org.scribble.model.ProtocolDecl;
import org.scribble.model.RoleDecl;
import org.scribble.model.RoleInstantiation;
import org.scribble.model.global.GDo;
import org.scribble.model.local.LDo;
import org.scribble.projection.rules.ProjectionRule;

public class GDoProjectionRule
implements ProjectionRule {
    @Override
    public Object project(ModuleContext context, ModelObject mobj, RoleDecl role, IssueLogger logger) {
        LDo projected = null;
        GDo source = (GDo)mobj;
        if (source.isRoleInvolved(role)) {
            projected = new LDo();
            projected.derivedFrom((ModelObject)source);
            String protocolName = source.getProtocol();
            if (protocolName.indexOf(46) != -1) {
                ModelObject mo;
                int index;
                RoleInstantiation targetri = source.getRoleInstantiation(role);
                if (targetri == null) {
                    logger.error("Could not find role '" + role + "'", mobj);
                    return null;
                }
                String otherRole = targetri.getAlias();
                if (otherRole == null && (index = source.getRoleInstantiations().indexOf(targetri)) != -1 && (mo = context.getMember(source.getProtocol())) instanceof ProtocolDecl) {
                    ProtocolDecl pd = (ProtocolDecl)mo;
                    if (pd.getRoleDeclarations().size() <= index) {
                        logger.error("Could not determine target role for '" + role + "'", mobj);
                    } else {
                        otherRole = ((RoleDecl)pd.getRoleDeclarations().get(index)).getName();
                    }
                }
                if (otherRole != null) {
                    index = protocolName.lastIndexOf(46);
                    protocolName = protocolName.substring(0, index) + "_" + otherRole + protocolName.substring(index);
                }
            }
            projected.setProtocol(protocolName);
            for (RoleInstantiation ri : source.getRoleInstantiations()) {
                projected.getRoleInstantiations().add(new RoleInstantiation(ri));
            }
            for (Argument arg : source.getArguments()) {
                projected.getArguments().add(new Argument(arg));
            }
            if (source.getScope() != null) {
                projected.setScope(source.getScope());
            }
        }
        return projected;
    }
}

