/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.projection.rules;

import java.util.HashSet;
import org.scribble.context.ModuleContext;
import org.scribble.logging.IssueLogger;
import org.scribble.model.ImportDecl;
import org.scribble.model.ModelObject;
import org.scribble.model.Module;
import org.scribble.model.PayloadTypeDecl;
import org.scribble.model.ProtocolDecl;
import org.scribble.model.RoleDecl;
import org.scribble.model.global.GProtocolDefinition;
import org.scribble.model.global.GProtocolInstance;
import org.scribble.projection.rules.ProjectionRule;
import org.scribble.projection.rules.ProjectionRuleFactory;

public class ModuleProjectionRule
implements ProjectionRule {
    public Object project(ModuleContext context, ModelObject mobj, RoleDecl role, IssueLogger logger) {
        HashSet<Module> ret = new HashSet<Module>();
        Module source = (Module)mobj;
        HashSet roles = new HashSet();
        for (ProtocolDecl pd : source.getProtocols()) {
            roles.addAll(pd.getRoleDeclarations());
        }
        for (RoleDecl rd : roles) {
            Module projected = new Module();
            projected.derivedFrom((ModelObject)source);
            if (source.getName() != null) {
                projected.setName(source.getName());
            }
            for (ImportDecl imp : source.getImports()) {
                projected.getImports().add(new ImportDecl(imp));
            }
            for (PayloadTypeDecl ptd : source.getPayloadTypeDeclarations()) {
                projected.getPayloadTypeDeclarations().add(new PayloadTypeDecl(ptd));
            }
            for (ProtocolDecl pd : source.getProtocols()) {
                ProtocolDecl lpd;
                ProjectionRule rule;
                if (!(pd instanceof GProtocolDefinition) && !(pd instanceof GProtocolInstance)) continue;
                ProtocolDecl gpd = pd;
                if (!pd.getRoleDeclarations().contains(rd) || (rule = ProjectionRuleFactory.getProjectionRule((ModelObject)gpd)) == null || (lpd = (ProtocolDecl)rule.project(context, (ModelObject)gpd, rd, logger)) == null) continue;
                projected.getProtocols().add(lpd);
            }
            ret.add(projected);
        }
        return ret;
    }
}

