/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.projection.util;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import org.scribble.common.logging.ScribbleLogger;
import org.scribble.model.RoleDecl;
import org.scribble.model.local.LActivity;
import org.scribble.model.local.LBlock;
import org.scribble.model.local.LChoice;

public class ChoiceMergingUtil {
    private static final Logger LOG = Logger.getLogger(ChoiceMergingUtil.class.getName());

    public static Object merge(LChoice projected, RoleDecl role, ScribbleLogger l) {
        Object ret = null;
        ret = ChoiceMergingUtil.extractCommonBehaviour(projected, role, l);
        ChoiceMergingUtil.groupSubpathsWithCommonInitiator(projected, role, l);
        for (int i = projected.getPaths().size() - 1; i >= 0; --i) {
            LBlock b = (LBlock)projected.getPaths().get(i);
            if (b.size() != 0) continue;
            projected.getPaths().remove(i);
        }
        if (projected.getPaths().size() == 0) {
            if (ret == projected) {
                ret = null;
            } else {
                ((List)ret).remove(projected);
            }
            projected = null;
        }
        return ret;
    }

    protected static void groupSubpathsWithCommonInitiator(LChoice projected, RoleDecl role, ScribbleLogger l) {
        List<Object> plist;
        HashMap<LActivity, Vector<LBlock>> pathGroups = new HashMap<LActivity, Vector<LBlock>>();
        for (LBlock path : projected.getPaths()) {
            if (path.size() <= 0) continue;
            plist = (Vector<LBlock>)pathGroups.get(path.get(0));
            if (plist == null) {
                plist = new Vector<LBlock>();
                pathGroups.put(path.get(0), (Vector<LBlock>)plist);
            }
            plist.add(path);
        }
        for (LActivity act : pathGroups.keySet()) {
            plist = (List)pathGroups.get(act);
            if (plist.size() < 2) continue;
            LChoice sub = new LChoice();
            int pos = -1;
            for (LBlock b : plist) {
                if (pos == -1) {
                    pos = projected.getPaths().indexOf(b);
                }
                projected.getPaths().remove(b);
                sub.getPaths().add(b);
            }
            LBlock newPath = new LBlock();
            projected.getPaths().add(pos, newPath);
            Object processed = ChoiceMergingUtil.merge(sub, role, l);
            if (processed instanceof List) {
                newPath.getContents().addAll((List)processed);
                continue;
            }
            LOG.severe("Should have returned a list with extracted common activity(s) followed by choice");
        }
    }

    protected static Object extractCommonBehaviour(LChoice projected, RoleDecl role, ScribbleLogger l) {
        Object ret = projected;
        boolean checkPaths = true;
        do {
            int i;
            boolean allSame = projected.getPaths().size() > 1;
            for (i = 1; allSame && i < projected.getPaths().size(); ++i) {
                LBlock b1 = (LBlock)projected.getPaths().get(0);
                LBlock b2 = (LBlock)projected.getPaths().get(i);
                if (b1.size() == 0 || b2.size() == 0) {
                    allSame = false;
                    continue;
                }
                if (b1.get(0).equals(b2.get(0))) continue;
                allSame = false;
            }
            if (allSame) {
                if (!(ret instanceof List)) {
                    ret = new Vector();
                    ((List)ret).add(projected);
                }
                ((List)ret).add(((List)ret).size() - 1, ((LBlock)projected.getPaths().get(0)).getContents().get(0));
                for (i = 0; i < projected.getPaths().size(); ++i) {
                    ((LBlock)projected.getPaths().get(i)).getContents().remove(0);
                }
            } else {
                checkPaths = false;
            }
        } while (checkPaths);
        return ret;
    }

    protected boolean isSameRole(LChoice c1, LChoice c2) {
        if (c1.getRole() == null && c2.getRole() == null) {
            return true;
        }
        return c1.getRole().equals((Object)c2.getRole());
    }
}

