/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.projection.rules;

import org.scribble.common.logging.ScribbleLogger;
import org.scribble.common.module.ModuleContext;
import org.scribble.model.ModelObject;
import org.scribble.model.Role;
import org.scribble.model.RoleDecl;
import org.scribble.model.global.GChoice;
import org.scribble.model.local.LBlock;
import org.scribble.model.local.LChoice;
import org.scribble.projection.rules.ProjectionRule;
import org.scribble.projection.rules.ProjectionRuleFactory;
import org.scribble.projection.util.ChoiceMergingUtil;

public class GChoiceProjectionRule
implements ProjectionRule {
    public Object project(ModuleContext context, ModelObject mobj, RoleDecl role, ScribbleLogger logger) {
        LChoice projected = new LChoice();
        GChoice source = (GChoice)mobj;
        projected.derivedFrom((ModelObject)source);
        projected.setRole(new Role(source.getRole()));
        boolean f_missingBranch = false;
        for (int i = 0; i < source.getPaths().size(); ++i) {
            ProjectionRule rule = ProjectionRuleFactory.getProjectionRule((ModelObject)source.getPaths().get(i));
            if (rule == null) continue;
            LBlock block = (LBlock)rule.project(context, (ModelObject)source.getPaths().get(i), role, logger);
            if (block != null) {
                if (block.getContents().size() == 1 && block.getContents().get(0) instanceof LChoice && this.isSameRole(projected, (LChoice)block.getContents().get(0))) {
                    projected.getPaths().addAll(((LChoice)block.getContents().get(0)).getPaths());
                    continue;
                }
                projected.getPaths().add(block);
                continue;
            }
            f_missingBranch = true;
        }
        if (f_missingBranch && projected.getPaths().size() <= 0) {
            return null;
        }
        return ChoiceMergingUtil.merge(projected, role, logger);
    }

    protected boolean isSameRole(LChoice c1, LChoice c2) {
        if (c1.getRole() == null && c2.getRole() == null) {
            return true;
        }
        if (c1.getRole() == null || c2.getRole() == null) {
            return false;
        }
        return c1.getRole().equals((Object)c2.getRole());
    }
}

