/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.parser;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.scribble.common.logging.ScribbleLogger;
import org.scribble.common.module.ModuleLoader;
import org.scribble.common.resources.Resource;
import org.scribble.common.resources.ResourceLocator;
import org.scribble.model.Module;
import org.scribble.parser.ProtocolParser;

public class ProtocolModuleLoader
implements ModuleLoader {
    private static final Logger LOG = Logger.getLogger(ProtocolModuleLoader.class.getName());
    private ResourceLocator _locator = null;
    private ScribbleLogger _logger = null;
    private ProtocolParser _parser = null;

    public ProtocolModuleLoader(ProtocolParser parser, ResourceLocator locator, ScribbleLogger logger) {
        this._parser = parser;
        this._locator = locator;
        this._logger = logger;
    }

    public Module loadModule(String module) {
        Module ret = null;
        Resource resource = this._locator.getResource(module);
        if (resource != null) {
            try {
                ret = this._parser.parse(resource, this, this._logger);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to parse imported module '" + module + "'", e);
            }
        }
        return ret;
    }
}

