/*
 * Decompiled with CFR 0.152.
 */
package org.scribble.monitor;

import org.scribble.monitor.Message;
import org.scribble.monitor.Monitor;
import org.scribble.monitor.SessionInstance;
import org.scribble.monitor.SessionScope;
import org.scribble.monitor.model.Node;
import org.scribble.monitor.model.SessionType;

public class DefaultMonitor
implements Monitor {
    @Override
    public void initializeInstance(SessionType type, SessionInstance instance) {
        type.initialize(instance);
    }

    @Override
    public boolean sent(SessionType type, SessionInstance instance, Message message, String toRole) {
        return this.sent(type, instance.getScope(), message, toRole);
    }

    protected boolean sent(SessionType type, SessionScope scope, Message message, String toRole) {
        Node throwNode;
        boolean ret = false;
        if (scope.getThrows() != -1 && (ret = (throwNode = type.getNode(scope.getThrows())).sent(type, scope, -1, message, toRole))) {
            scope.completed(true);
            return true;
        }
        if (scope.getNodeIndexes() != null) {
            int index;
            Node node;
            for (int i = 0; i < scope.getNodeIndexes().size() && !(ret = (node = type.getNode(index = scope.getNodeIndexes().get(i).intValue())).sent(type, scope, i, message, toRole)); ++i) {
            }
        }
        if (!ret && scope.getSubScopes() != null) {
            for (int i = 0; i < scope.getSubScopes().size(); ++i) {
                SessionScope subScope = scope.getSubScopes().get(i);
                ret = this.sent(type, subScope, message, toRole);
                if (!ret) continue;
                this.checkScope(type, scope, subScope, i);
                break;
            }
        }
        return ret;
    }

    @Override
    public boolean received(SessionType type, SessionInstance instance, Message message, String fromRole) {
        return this.received(type, instance.getScope(), message, fromRole);
    }

    protected boolean received(SessionType type, SessionScope scope, Message message, String fromRole) {
        Node catchNode;
        boolean ret = false;
        if (scope.getCatches() != -1 && (ret = (catchNode = type.getNode(scope.getCatches())).received(type, scope, -1, message, fromRole))) {
            scope.completed(true);
            return true;
        }
        if (scope.getNodeIndexes() != null) {
            int index;
            Node node;
            for (int i = 0; i < scope.getNodeIndexes().size() && !(ret = (node = type.getNode(index = scope.getNodeIndexes().get(i).intValue())).received(type, scope, i, message, fromRole)); ++i) {
            }
        }
        if (!ret && scope.getSubScopes() != null) {
            for (int i = 0; i < scope.getSubScopes().size(); ++i) {
                SessionScope subScope = scope.getSubScopes().get(i);
                ret = this.received(type, subScope, message, fromRole);
                if (!ret) continue;
                this.checkScope(type, scope, subScope, i);
                break;
            }
        }
        return ret;
    }

    protected void checkScope(SessionType type, SessionScope scope, SessionScope subScope, int scopeIndex) {
        if (scope.getMutuallyExclusive() && scope.getSubScopes().size() != 1) {
            scope.getSubScopes().clear();
            scope.getSubScopes().add(subScope);
            scopeIndex = 0;
        }
        if (subScope.completed()) {
            scope.getSubScopes().remove(scopeIndex);
            if (subScope.getCompletionIndex() != -1) {
                Node node = type.getNode(subScope.getCompletionIndex());
                node.evaluate(type, subScope.getCompletionIndex(), scope);
            }
        }
    }
}

